/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.HistoryTextField;
import workbench.interfaces.ValidatingComponent;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class LoginPrompt
extends JPanel
implements ValidatingComponent,
ActionListener {
    private JLabel lblPwd;
    private JLabel lblUsername;
    private JPasswordField tfPwd;
    private JComboBox tfUsername;

    public LoginPrompt(String string) {
        this.initComponents();
        this.getUsernameField().setSettingsProperty(string);
        WbSwingUtilities.setMinimumSize(this.tfUsername, 25);
        WbSwingUtilities.setMinimumSize(this.tfPwd, 25);
    }

    public String getUserName() {
        return this.getUsernameField().getText().trim();
    }

    public String getPassword() {
        return this.tfPwd.getText();
    }

    @Override
    public boolean validateInput() {
        this.getUsernameField().addToHistory(this.getUserName());
        this.getUsernameField().saveSettings(Settings.getInstance(), "workbench.loginprompt.");
        return true;
    }

    private HistoryTextField getUsernameField() {
        return (HistoryTextField)this.tfUsername;
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
        this.getUsernameField().restoreSettings(Settings.getInstance(), "workbench.loginprompt.");
        this.getUsernameField().setText("");
        WbSwingUtilities.requestFocus(this.tfUsername);
    }

    private void initComponents() {
        this.lblUsername = new JLabel();
        this.tfPwd = new JPasswordField();
        this.lblPwd = new JLabel();
        this.tfUsername = new HistoryTextField("usernames");
        this.setLayout(new GridBagLayout());
        this.lblUsername.setText(ResourceMgr.getString("LblUsername"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        this.add((Component)this.lblUsername, gridBagConstraints);
        this.tfPwd.setName("password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 4, 2);
        this.add((Component)this.tfPwd, gridBagConstraints);
        this.lblPwd.setText(ResourceMgr.getString("LblPassword"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        this.add((Component)this.lblPwd, gridBagConstraints);
        this.tfUsername.setEditable(true);
        this.tfUsername.setMaximumRowCount(10);
        this.tfUsername.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 6, 4, 2);
        this.add((Component)this.tfUsername, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.tfUsername) {
            this.tfUsernameActionPerformed(actionEvent);
        }
    }

    private void tfUsernameActionPerformed(ActionEvent actionEvent) {
        try {
            JTextField jTextField = (JTextField)this.tfUsername.getEditor().getEditorComponent();
            jTextField.selectAll();
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not select text of username combobox", throwable);
        }
    }
}

