/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import workbench.db.ConnectionMgr;
import workbench.db.ProfileManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ExtensionFileFilter;
import workbench.gui.components.WbLabelField;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbToolbar;
import workbench.gui.profiles.ProfileListModel;
import workbench.gui.profiles.ProfileTree;
import workbench.interfaces.ValidatingComponent;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ProfileImporterPanel
extends JPanel
implements ActionListener,
ValidatingComponent {
    private static final String CONFIG_PREFIX = "workbench.gui.profileimporter.";
    private static final String DIRKEY_SOURCE = "lastsourcedir";
    private static final String DIRKEY_CURRENT = "lastprofilesdir";
    private static final String CMD_SAVE_CURRENT = "saveCurrent";
    private static final String CMD_OPEN_CURRENT = "openCurrent";
    private static final String CMD_SAVE_SOURCE = "saveSource";
    private static final String CMD_OPEN_SOURCE = "openSource";
    private WbAction openSourceAction;
    private WbAction saveSourceAction;
    private WbAction openCurrentAction;
    private WbAction saveCurrentAction;
    private WbLabelField currentFilename;
    private JPanel currentInfopanel;
    private JPanel currentPanel;
    private ProfileTree currentProfiles;
    private WbToolbar currentToolbar;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private WbLabelField sourceFilename;
    private JPanel sourceInfoPanel;
    private JPanel sourcePanel;
    private ProfileTree sourceProfiles;
    private WbToolbar sourceToolbar;
    private WbSplitPane splitPane;

    public ProfileImporterPanel() {
        this.initComponents();
        this.sourceFilename.setText(ResourceMgr.getString("LblNone"));
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        this.sourceFilename.setBorder(emptyBorder);
        this.currentFilename.setBorder(emptyBorder);
        this.sourceProfiles.setModel(ProfileListModel.emptyModel());
        this.openSourceAction = new WbAction(this, CMD_OPEN_SOURCE);
        this.openSourceAction.setIcon("open");
        this.sourceToolbar.add(this.openSourceAction);
        this.saveSourceAction = new WbAction(this, CMD_SAVE_SOURCE);
        this.saveSourceAction.setIcon("save");
        this.sourceToolbar.add(this.saveSourceAction);
        this.sourceToolbar.addSeparator();
        this.openCurrentAction = new WbAction(this, CMD_OPEN_CURRENT);
        this.openCurrentAction.setIcon("open");
        this.currentToolbar.add(this.openCurrentAction);
        this.saveCurrentAction = new WbAction(this, CMD_SAVE_CURRENT);
        this.saveCurrentAction.setIcon("save");
        this.currentToolbar.add(this.saveCurrentAction);
        this.currentToolbar.addSeparator();
        this.currentInfopanel.setPreferredSize(this.sourceInfoPanel.getPreferredSize());
    }

    public void loadCurrentProfiles() {
        ProfileListModel profileListModel = new ProfileListModel(ConnectionMgr.getInstance().getProfiles());
        profileListModel.setSourceFile(ConnectionMgr.getInstance().getProfilesFile());
        profileListModel.resetChanged();
        WbSwingUtilities.invoke(() -> {
            this.currentProfiles.setModel(profileListModel);
            this.currentFilename.setText(ConnectionMgr.getInstance().getProfilesPath());
        });
    }

    public void applyProfiles() {
        ProfileListModel profileListModel = this.currentProfiles.getModel();
        profileListModel.applyProfiles();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ProfileListModel profileListModel;
        if (actionEvent.getActionCommand().equals(CMD_OPEN_SOURCE) && (profileListModel = this.loadFile(DIRKEY_SOURCE, this.sourceFilename)) != null) {
            WbSwingUtilities.invokeLater(() -> this.sourceProfiles.setModel(profileListModel));
        }
        if (actionEvent.getActionCommand().equals(CMD_OPEN_CURRENT) && (profileListModel = this.loadFile(DIRKEY_CURRENT, this.currentFilename)) != null) {
            WbSwingUtilities.invokeLater(() -> this.currentProfiles.setModel(profileListModel));
        }
        if (actionEvent.getActionCommand().equals(CMD_SAVE_SOURCE)) {
            this.saveSource(WbAction.isCtrlPressed(actionEvent));
        }
        if (actionEvent.getActionCommand().equals(CMD_SAVE_CURRENT)) {
            this.saveCurrent(WbAction.isCtrlPressed(actionEvent));
        }
    }

    private JFileChooser createFileChooser(String string) {
        String string2 = CONFIG_PREFIX + string;
        String string3 = Settings.getInstance().getProperty(string2, Settings.getInstance().getConfigDir().getAbsolutePath());
        JFileChooser jFileChooser = new JFileChooser(string3);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(new ExtensionFileFilter("XML Profiles", CollectionUtil.arrayList("xml"), true));
        jFileChooser.addChoosableFileFilter(new ExtensionFileFilter("Properties Profiles", CollectionUtil.arrayList("properties"), true));
        jFileChooser.setMultiSelectionEnabled(false);
        return jFileChooser;
    }

    private ProfileListModel loadFile(String string, JTextField jTextField) {
        String string2 = CONFIG_PREFIX + string;
        JFileChooser jFileChooser = this.createFileChooser(string);
        int n = jFileChooser.showOpenDialog(this);
        WbFile wbFile = new WbFile(jFileChooser.getCurrentDirectory());
        Settings.getInstance().setProperty(string2, wbFile.getFullPath());
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return null;
            }
            if (ConnectionMgr.getInstance().getProfilesFile().equals(file)) {
                jTextField.setText(ConnectionMgr.getInstance().getProfilesPath());
                ProfileListModel profileListModel = new ProfileListModel(ConnectionMgr.getInstance().getProfiles());
                profileListModel.setSourceFile(ConnectionMgr.getInstance().getProfilesFile());
                profileListModel.resetChanged();
            } else {
                jTextField.setText(new WbFile(file).getFullPath());
                ProfileManager profileManager = new ProfileManager(file);
                profileManager.load();
                ProfileListModel profileListModel = new ProfileListModel(profileManager.getProfiles());
                profileListModel.setSourceFile(file);
                profileListModel.resetChanged();
                return profileListModel;
            }
        }
        return null;
    }

    private void saveCurrent(boolean bl) {
        ProfileListModel profileListModel = this.currentProfiles.getModel();
        File file = profileListModel.getSourceFile();
        if ((file == null || bl) && (file = this.selectOutputFile(DIRKEY_CURRENT)) != null) {
            this.currentFilename.setText(file.getAbsolutePath());
        }
        if (file == null) {
            return;
        }
        if (ConnectionMgr.getInstance().getProfilesFile().equals(file)) {
            if (profileListModel.profilesAreModified() || profileListModel.groupsChanged()) {
                this.currentProfiles.getModel().saveProfiles();
            }
        } else {
            profileListModel.saveTo(file);
        }
    }

    private File selectOutputFile(String string) {
        JFileChooser jFileChooser = this.createFileChooser(string);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return null;
            }
            WbFile wbFile = new WbFile(file);
            if (StringUtil.isEmptyString(wbFile.getExtension())) {
                ExtensionFileFilter extensionFileFilter = (ExtensionFileFilter)jFileChooser.getFileFilter();
                String string2 = extensionFileFilter.getDefaultExtension();
                String string3 = wbFile.getFullPath() + "." + string2;
                return new File(string3);
            }
            return file;
        }
        return null;
    }

    private boolean saveSource(boolean bl) {
        File file = this.sourceProfiles.getModel().getSourceFile();
        if ((file == null || bl) && (file = this.selectOutputFile(DIRKEY_SOURCE)) != null) {
            this.sourceFilename.setText(file.getAbsolutePath());
        }
        if (file == null) {
            return false;
        }
        ProfileListModel profileListModel = this.sourceProfiles.getModel();
        try {
            profileListModel.saveTo(file);
            return true;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not save profiles", exception);
            return false;
        }
    }

    @Override
    public boolean validateInput() {
        CheckResult checkResult = this.checkUnsaved(this.currentProfiles.getModel());
        if (checkResult == CheckResult.cancel) {
            return false;
        }
        if (checkResult == CheckResult.saveFile) {
            this.saveCurrent(false);
        }
        if ((checkResult = this.checkUnsaved(this.sourceProfiles.getModel())) == CheckResult.cancel) {
            return false;
        }
        if (checkResult == CheckResult.saveFile) {
            this.saveSource(false);
        }
        return true;
    }

    private CheckResult checkUnsaved(ProfileListModel profileListModel) {
        if (profileListModel == null) {
            return CheckResult.ok;
        }
        if (!profileListModel.isChanged()) {
            return CheckResult.ok;
        }
        File file = profileListModel.getSourceFile();
        String string = null;
        string = file == null ? ResourceMgr.getString("LblNone") : file.getAbsolutePath();
        String string2 = ResourceMgr.getFormattedString("MsgConfirmUnsavedEditorFile", string);
        int n = WbSwingUtilities.getYesNoCancel(this, string2);
        if (n == 0) {
            return CheckResult.saveFile;
        }
        if (n == 2) {
            return CheckResult.cancel;
        }
        return CheckResult.ok;
    }

    @Override
    public void componentDisplayed() {
        this.splitPane.setDividerLocation(0.5);
        this.loadCurrentProfiles();
        ProfileListModel profileListModel = new ProfileListModel();
        this.sourceProfiles.setModel(profileListModel);
    }

    @Override
    public void componentWillBeClosed() {
    }

    private void initComponents() {
        this.splitPane = new WbSplitPane();
        this.sourcePanel = new JPanel();
        this.sourceInfoPanel = new JPanel();
        this.sourceFilename = new WbLabelField();
        this.sourceToolbar = new WbToolbar();
        this.jScrollPane3 = new JScrollPane();
        this.sourceProfiles = new ProfileTree();
        this.currentPanel = new JPanel();
        this.currentInfopanel = new JPanel();
        this.currentFilename = new WbLabelField();
        this.currentToolbar = new WbToolbar();
        this.jScrollPane4 = new JScrollPane();
        this.currentProfiles = new ProfileTree();
        this.setLayout(new BorderLayout());
        this.splitPane.setBorder(BorderFactory.createEmptyBorder(1, 5, 15, 5));
        this.splitPane.setDividerLocation(150);
        this.sourcePanel.setLayout(new BorderLayout());
        this.sourceInfoPanel.setBorder(BorderFactory.createEtchedBorder());
        this.sourceInfoPanel.setLayout(new GridBagLayout());
        this.sourceFilename.setText("wbLabelField2");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.sourceInfoPanel.add((Component)this.sourceFilename, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.sourceInfoPanel.add((Component)this.sourceToolbar, gridBagConstraints);
        this.sourcePanel.add((Component)this.sourceInfoPanel, "North");
        this.sourceProfiles.setName("sourceProfiles");
        this.jScrollPane3.setViewportView(this.sourceProfiles);
        this.sourcePanel.add((Component)this.jScrollPane3, "Center");
        this.splitPane.setLeftComponent(this.sourcePanel);
        this.currentPanel.setLayout(new BorderLayout());
        this.currentInfopanel.setBorder(BorderFactory.createEtchedBorder());
        this.currentInfopanel.setLayout(new GridBagLayout());
        this.currentFilename.setText("wbLabelField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.currentInfopanel.add((Component)this.currentFilename, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.currentInfopanel.add((Component)this.currentToolbar, gridBagConstraints);
        this.currentPanel.add((Component)this.currentInfopanel, "North");
        this.currentProfiles.setName("currentProfiles");
        this.jScrollPane4.setViewportView(this.currentProfiles);
        this.currentPanel.add((Component)this.jScrollPane4, "Center");
        this.splitPane.setRightComponent(this.currentPanel);
        this.add((Component)this.splitPane, "Center");
    }

    private static enum CheckResult {
        ok,
        saveFile,
        cancel;

    }
}

