/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ClassFinderGUI;
import workbench.gui.components.ClasspathEditor;
import workbench.gui.components.FlatButton;
import workbench.gui.components.StringPropertyEditor;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.WbButton;
import workbench.gui.components.WbStatusLabel;
import workbench.gui.lnf.LnFDefinition;
import workbench.gui.lnf.LnFLoader;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.util.ClassFinder;

public class LnFDefinitionPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private LnFDefinition currentLnF;
    private PropertyChangeListener changeListener;
    private boolean ignoreChange;
    public JButton changeLnfButton;
    public ClasspathEditor classpathEditor;
    public JLabel currentLabel;
    public JTextArea infoText;
    public JSeparator jSeparator1;
    public JLabel lblClassName;
    public JLabel lblLibrary;
    public JLabel lblName;
    public JButton selectClass;
    public JLabel statusLabel;
    public JTextField tfClassName;
    public JTextField tfName;

    public LnFDefinitionPanel() {
        this.initComponents();
        this.lblLibrary.setToolTipText(ResourceMgr.getDescription("LblLnFLib"));
        this.classpathEditor.setLastDirProperty("workbench.lnf.lastdir");
        this.tfName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                LnFDefinitionPanel.this.nameFieldFocusLost(focusEvent);
            }
        });
        Font font = UIManager.getDefaults().getFont("Label.font");
        if (font != null) {
            font = font.deriveFont(1, (float)((double)font.getSize() * 1.2));
            this.infoText.setFont(font);
        }
        String string = this.changeLnfButton.getText();
        String string2 = ResourceMgr.getString("TxtChangeLnFInfo").replace("%button%", string);
        this.infoText.setText(string2);
        this.infoText.setWrapStyleWord(true);
        this.infoText.setLineWrap(true);
        this.infoText.setBackground(this.getBackground());
        this.classpathEditor.addActionListener(actionEvent -> this.selectClass());
    }

    public void setStatusMessage(String string) {
        this.statusLabel.setText(string);
    }

    public void setPropertyListener(PropertyChangeListener propertyChangeListener) {
        this.changeListener = propertyChangeListener;
    }

    public void nameFieldFocusLost(FocusEvent focusEvent) {
        if (this.changeListener != null) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.currentLnF, "name", null, this.tfName.getText());
            this.changeListener.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.tfClassName.setEnabled(bl);
        this.classpathEditor.setFileSelectionEnabled(bl);
        this.tfName.setEnabled(bl);
        this.selectClass.setEnabled(bl);
    }

    private boolean testLnF(LnFDefinition lnFDefinition) {
        LnFLoader lnFLoader = new LnFLoader(lnFDefinition);
        return lnFLoader.isAvailable();
    }

    private void selectClass() {
        ClassFinder classFinder = new ClassFinder(LookAndFeel.class);
        classFinder.setSearchForServices(false);
        List<String> list = this.classpathEditor.getLibraries();
        this.currentLnF.setLibraries(list);
        ClassFinderGUI classFinderGUI = new ClassFinderGUI(classFinder, this.tfClassName, this.statusLabel);
        classFinderGUI.setStatusBarKey("TxtSearchingLnF");
        classFinderGUI.setWindowTitleKey("TxtSelectLnF");
        classFinderGUI.setClassPath(list.stream().map(string -> new File((String)string)).collect(Collectors.toList()));
        classFinderGUI.startCheck();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.ignoreChange) {
            return;
        }
        this.selectClass();
    }

    private void initComponents() {
        this.lblName = new JLabel();
        this.tfName = new StringPropertyEditor();
        this.lblClassName = new JLabel();
        this.tfClassName = new StringPropertyEditor();
        this.lblLibrary = new JLabel();
        this.infoText = new JTextArea();
        this.jSeparator1 = new JSeparator();
        this.changeLnfButton = new WbButton();
        this.currentLabel = new HtmlLabel();
        this.statusLabel = new WbStatusLabel();
        this.selectClass = new FlatButton();
        this.classpathEditor = new ClasspathEditor();
        this.setLayout(new GridBagLayout());
        this.lblName.setLabelFor(this.tfName);
        this.lblName.setText(ResourceMgr.getString("LblLnFName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 10, 1, 7);
        this.add((Component)this.lblName, gridBagConstraints);
        this.tfName.setHorizontalAlignment(2);
        this.tfName.setName("name");
        this.tfName.addMouseListener(new TextComponentMouseListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 3, 1, 3);
        this.add((Component)this.tfName, gridBagConstraints);
        this.lblClassName.setLabelFor(this.tfClassName);
        this.lblClassName.setText(ResourceMgr.getString("LblLnFClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 7);
        this.add((Component)this.lblClassName, gridBagConstraints);
        this.tfClassName.setColumns(10);
        this.tfClassName.setHorizontalAlignment(2);
        this.tfClassName.setName("className");
        this.tfClassName.addMouseListener(new TextComponentMouseListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 3, 0, 3);
        this.add((Component)this.tfClassName, gridBagConstraints);
        this.lblLibrary.setLabelFor(this.lblLibrary);
        this.lblLibrary.setText(ResourceMgr.getString("LblLnFLib"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 10, 0, 7);
        this.add((Component)this.lblLibrary, gridBagConstraints);
        this.infoText.setLineWrap(true);
        this.infoText.setText("Please click on the \"Make current\" button to switch the current Look and Feel");
        this.infoText.setWrapStyleWord(true);
        this.infoText.setDisabledTextColor(this.infoText.getForeground());
        this.infoText.setEnabled(false);
        this.infoText.setFocusable(false);
        this.infoText.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 10, 0, 10);
        this.add((Component)this.infoText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.changeLnfButton.setText(ResourceMgr.getString("LblActivateLnf"));
        this.changeLnfButton.setMaximumSize(new Dimension(200, 50));
        this.changeLnfButton.setMinimumSize(new Dimension(140, 30));
        this.changeLnfButton.setPreferredSize(new Dimension(140, 30));
        ((WbButton)this.changeLnfButton).setResourceKey("LblSwitchLnF");
        this.changeLnfButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 8, 0, 0);
        this.add((Component)this.changeLnfButton, gridBagConstraints);
        this.currentLabel.setBackground(new Color(255, 255, 255));
        this.currentLabel.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 2));
        this.currentLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(13, 8, 5, 8);
        this.add((Component)this.currentLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 10, 0, 7);
        this.add((Component)this.statusLabel, gridBagConstraints);
        this.selectClass.setText("...");
        this.selectClass.setMaximumSize(new Dimension(22, 22));
        this.selectClass.setMinimumSize(new Dimension(22, 22));
        this.selectClass.setPreferredSize(new Dimension(22, 22));
        this.selectClass.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 3);
        this.add((Component)this.selectClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 3, 0, 3);
        this.add((Component)this.classpathEditor, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.changeLnfButton) {
            this.changeLnfButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.selectClass) {
            this.selectClassActionPerformed(actionEvent);
        }
    }

    private void changeLnfButtonActionPerformed(ActionEvent actionEvent) {
        LnFDefinition lnFDefinition = this.getDefinition();
        if (this.testLnF(lnFDefinition)) {
            String string = lnFDefinition.getClassName();
            this.currentLabel.setText(lnFDefinition.getName());
            GuiSettings.setLookAndFeelClass(string);
            WbSwingUtilities.showMessage(SwingUtilities.getWindowAncestor(this), ResourceMgr.getString("MsgLnFChanged"));
        } else {
            WbSwingUtilities.showErrorMessageKey(this, "MsgLnFNotLoaded");
        }
    }

    private void selectClassActionPerformed(ActionEvent actionEvent) {
        this.selectClass();
    }

    public void setCurrentLookAndFeeld(LnFDefinition lnFDefinition) {
        if (lnFDefinition != null) {
            this.currentLabel.setText(lnFDefinition.getName());
        }
    }

    public void setDefinition(LnFDefinition lnFDefinition) {
        try {
            this.ignoreChange = true;
            this.currentLnF = lnFDefinition;
            if (this.currentLnF != null) {
                WbSwingUtilities.initPropertyEditors(this.currentLnF, this);
                this.classpathEditor.setLibraries(this.currentLnF.getLibraries());
                this.setEnabled(!this.currentLnF.isBuiltIn());
                if (lnFDefinition.isExt()) {
                    this.selectClass.setEnabled(true);
                }
            } else {
                this.classpathEditor.setLibraries(null);
                this.setEnabled(false);
                this.selectClass.setEnabled(false);
            }
        }
        finally {
            this.ignoreChange = false;
        }
    }

    public LnFDefinition getDefinition() {
        return this.currentLnF;
    }

    private static class HtmlLabel
    extends JLabel {
        private HtmlLabel() {
        }

        @Override
        public void setText(String string) {
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            super.setText("<html>" + ResourceMgr.getString("LblCurrLnf") + " <b>" + string + "</b></html>");
        }
    }
}

