/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import workbench.gui.components.WbTraversalPolicy;
import workbench.interfaces.Restoreable;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;

public class WindowTitleOptionsPanel
extends JPanel
implements Restoreable {
    private JComboBox encloseChar;
    private JLabel encloseCharLabel;
    private JCheckBox includeUser;
    private JPanel jPanel1;
    private JCheckBox productAtEnd;
    private JCheckBox showProfileGroup;
    private JCheckBox showUrl;
    private JCheckBox showWorkspace;
    private JTextField titleGroupSep;
    private JLabel titleGroupSepLabel;
    private JComboBox windowTitleComboBox;
    private JLabel windowTitleLabel;

    public WindowTitleOptionsPanel() {
        this.initComponents();
        this.windowTitleComboBox.addItem(ResourceMgr.getString("TxtShowNone"));
        this.windowTitleComboBox.addItem(ResourceMgr.getString("TxtShowName"));
        this.windowTitleComboBox.addItem(ResourceMgr.getString("TxtShowPath"));
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.productAtEnd);
        wbTraversalPolicy.addComponent(this.showProfileGroup);
        wbTraversalPolicy.addComponent(this.showWorkspace);
        wbTraversalPolicy.addComponent(this.windowTitleComboBox);
        wbTraversalPolicy.setDefaultComponent(this.productAtEnd);
        this.encloseChar.insertItemAt(ResourceMgr.getString("TxtNothingItem"), 0);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
        this.setFocusCycleRoot(false);
        this.restoreSettings();
    }

    @Override
    public final void restoreSettings() {
        int n = GuiSettings.getShowFilenameInWindowTitle();
        if (n >= 0 && n <= 2) {
            this.windowTitleComboBox.setSelectedIndex(n);
        }
        this.showProfileGroup.setSelected(GuiSettings.getShowProfileGroupInWindowTitle());
        this.showWorkspace.setSelected(GuiSettings.getShowWorkspaceInWindowTitle());
        this.productAtEnd.setSelected(GuiSettings.getShowProductNameAtEnd());
        this.showUrl.setSelected(GuiSettings.getShowURLinWindowTitle());
        this.includeUser.setSelected(GuiSettings.getIncludeUserInTitleURL());
        this.includeUser.setEnabled(this.showUrl.isSelected());
        String string = GuiSettings.getTitleGroupBracket();
        if (string == null) {
            this.encloseChar.setSelectedIndex(0);
        } else {
            int n2 = this.encloseChar.getItemCount();
            for (int i = 1; i < n2; ++i) {
                String string2 = (String)this.encloseChar.getItemAt(i);
                if (!string2.startsWith(string.trim())) continue;
                this.encloseChar.setSelectedIndex(i);
                break;
            }
        }
        this.checkShowProfile();
        this.titleGroupSep.setText(GuiSettings.getTitleGroupSeparator());
    }

    @Override
    public void saveSettings() {
        GuiSettings.setShowFilenameInWindowTitle(this.windowTitleComboBox.getSelectedIndex());
        GuiSettings.setShowProfileGroupInWindowTitle(this.showProfileGroup.isSelected());
        GuiSettings.setShowWorkspaceInWindowTitle(this.showWorkspace.isSelected());
        GuiSettings.setShowProductNameAtEnd(this.productAtEnd.isSelected());
        GuiSettings.setTitleGroupSeparator(this.titleGroupSep.getText());
        GuiSettings.setShowURLinWindowTitle(this.showUrl.isSelected());
        GuiSettings.setIncludeUserInTitleURL(this.includeUser.isSelected());
        int n = this.encloseChar.getSelectedIndex();
        if (n == 0) {
            GuiSettings.setTitleGroupBracket(null);
        } else {
            String string = (String)this.encloseChar.getSelectedItem();
            GuiSettings.setTitleGroupBracket(string.substring(0, 1));
        }
    }

    protected void checkShowProfile() {
        this.encloseChar.setEnabled(this.showProfileGroup.isSelected());
        this.titleGroupSep.setEnabled(this.showProfileGroup.isSelected());
    }

    private void initComponents() {
        this.productAtEnd = new JCheckBox();
        this.showProfileGroup = new JCheckBox();
        this.showWorkspace = new JCheckBox();
        this.windowTitleLabel = new JLabel();
        this.windowTitleComboBox = new JComboBox();
        this.encloseCharLabel = new JLabel();
        this.encloseChar = new JComboBox();
        this.jPanel1 = new JPanel();
        this.titleGroupSepLabel = new JLabel();
        this.titleGroupSep = new JTextField();
        this.showUrl = new JCheckBox();
        this.includeUser = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.productAtEnd.setText(ResourceMgr.getString("LblShowProductAtEnd"));
        this.productAtEnd.setToolTipText(ResourceMgr.getString("d_LblShowProductAtEnd"));
        this.productAtEnd.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 2, 11);
        this.add((Component)this.productAtEnd, gridBagConstraints);
        this.showProfileGroup.setText(ResourceMgr.getString("LblShowProfileGroup"));
        this.showProfileGroup.setToolTipText(ResourceMgr.getString("d_LblShowProfileGroup"));
        this.showProfileGroup.setBorder(null);
        this.showProfileGroup.setHorizontalAlignment(2);
        this.showProfileGroup.setHorizontalTextPosition(4);
        this.showProfileGroup.setIconTextGap(5);
        this.showProfileGroup.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                WindowTitleOptionsPanel.this.showProfileGroupStateChanged(changeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 11);
        this.add((Component)this.showProfileGroup, gridBagConstraints);
        this.showWorkspace.setText(ResourceMgr.getString("LblShowWorkspace"));
        this.showWorkspace.setToolTipText(ResourceMgr.getString("d_LblShowWorkspace"));
        this.showWorkspace.setBorder(null);
        this.showWorkspace.setHorizontalAlignment(2);
        this.showWorkspace.setHorizontalTextPosition(4);
        this.showWorkspace.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 1);
        this.add((Component)this.showWorkspace, gridBagConstraints);
        this.windowTitleLabel.setLabelFor(this.windowTitleComboBox);
        this.windowTitleLabel.setText(ResourceMgr.getString("LblShowEditorInfo"));
        this.windowTitleLabel.setToolTipText(ResourceMgr.getString("d_LblShowEditorInfo"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(16, 0, 0, 0);
        this.add((Component)this.windowTitleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 4, 0, 11);
        this.add((Component)this.windowTitleComboBox, gridBagConstraints);
        this.encloseCharLabel.setText(ResourceMgr.getString("LblEncloseGroupChar"));
        this.encloseCharLabel.setToolTipText(ResourceMgr.getString("d_LblEncloseGroupChar"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 2, 0);
        this.add((Component)this.encloseCharLabel, gridBagConstraints);
        this.encloseChar.setModel(new DefaultComboBoxModel<String>(new String[]{"( )", "{ }", "[ ]", "< >"}));
        this.encloseChar.setToolTipText(ResourceMgr.getDescription("LblEncloseGroupChar"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 4, 0, 11);
        this.add((Component)this.encloseChar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.titleGroupSepLabel.setText(ResourceMgr.getString("LblGroupSeparator"));
        this.titleGroupSepLabel.setToolTipText(ResourceMgr.getString("d_LblGroupSeparator"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 2, 2, 0);
        this.add((Component)this.titleGroupSepLabel, gridBagConstraints);
        this.titleGroupSep.setColumns(5);
        this.titleGroupSep.setToolTipText(ResourceMgr.getDescription("LblGroupSeparator"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 2, 11);
        this.add((Component)this.titleGroupSep, gridBagConstraints);
        this.showUrl.setText(ResourceMgr.getString("LblUrlInTitle"));
        this.showUrl.setToolTipText(ResourceMgr.getString("d_LblUrlInTitle"));
        this.showUrl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowTitleOptionsPanel.this.showUrlActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 2, 11);
        this.add((Component)this.showUrl, gridBagConstraints);
        this.includeUser.setText(ResourceMgr.getString("LblUrlWithUser"));
        this.includeUser.setToolTipText(ResourceMgr.getString("d_LblUrlWithUser"));
        this.includeUser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 21, 2, 11);
        this.add((Component)this.includeUser, gridBagConstraints);
    }

    private void showProfileGroupStateChanged(ChangeEvent changeEvent) {
        this.checkShowProfile();
    }

    private void showUrlActionPerformed(ActionEvent actionEvent) {
        this.includeUser.setEnabled(this.showUrl.isSelected());
    }
}

