/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import workbench.WbManager;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.sql.EditorPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.storage.DmlStatement;
import workbench.storage.SqlLiteralFormatter;
import workbench.util.ExceptionUtil;
import workbench.util.MemoryWatcher;
import workbench.util.MessageBuffer;

public class DwUpdatePreview {
    public boolean confirmUpdate(Component component, DataStore dataStore, WbConnection wbConnection) {
        boolean bl = true;
        Window window = SwingUtilities.getWindowAncestor(component);
        MessageBuffer messageBuffer = null;
        try {
            List<DmlStatement> list = dataStore.getUpdateStatements(wbConnection);
            if (list.isEmpty()) {
                return true;
            }
            Dimension dimension = new Dimension(800, 600);
            Dimension dimension2 = new Dimension(400, 300);
            EditorPanel editorPanel = EditorPanel.createSqlEditor();
            editorPanel.setEditable(false);
            editorPanel.showFindOnPopupMenu();
            editorPanel.setBorder(WbSwingUtilities.EMPTY_BORDER);
            editorPanel.setPreferredSize(dimension2);
            editorPanel.setMaximumSize(dimension);
            JPanel jPanel = new JPanel(new BorderLayout(0, 8));
            JScrollPane jScrollPane = new JScrollPane(editorPanel);
            jScrollPane.setMaximumSize(dimension);
            int n = Settings.getInstance().getIntProperty("workbench.db.previewsql.maxstatements", 5000);
            if (n < list.size()) {
                LogMgr.logWarning(new CallerInfo(){}, "Only " + n + " of " + list.size() + " statments displayed. To view all statements increase the value of the property 'workbench.db.previewsql.maxstatements'");
            }
            messageBuffer = new MessageBuffer(n);
            SqlLiteralFormatter sqlLiteralFormatter = new SqlLiteralFormatter(wbConnection);
            sqlLiteralFormatter.createDbmsBlobLiterals(wbConnection);
            boolean bl2 = false;
            for (DmlStatement dmlStatement : list) {
                messageBuffer.append(dmlStatement.getExecutableStatement(sqlLiteralFormatter, wbConnection));
                messageBuffer.append(";");
                messageBuffer.appendNewLine();
                if (!MemoryWatcher.isMemoryLow(true)) continue;
                bl2 = true;
                messageBuffer.clear();
            }
            if (bl2) {
                WbManager.getInstance().showLowMemoryError();
                return false;
            }
            editorPanel.setText(messageBuffer.getBuffer().toString());
            editorPanel.setCaretPosition(0);
            editorPanel.repaint();
            jPanel.add((Component)jScrollPane, "Center");
            JCheckBox jCheckBox = new JCheckBox(ResourceMgr.getString("LblCopyToClp"));
            boolean bl3 = Settings.getInstance().getBoolProperty("workbench.db.previewsql.copyclipboard", false);
            jCheckBox.setSelected(bl3);
            jPanel.add((Component)jCheckBox, "Last");
            ValidatingDialog validatingDialog = ValidatingDialog.createDialog(window, jPanel, ResourceMgr.getString("MsgConfirmUpdates"), null, 0, false);
            if (Settings.getInstance().restoreWindowSize(validatingDialog, "workbench.gui.confirmupdate.dialog")) {
                WbSwingUtilities.center(validatingDialog, window);
            }
            validatingDialog.setVisible(true);
            Settings.getInstance().storeWindowSize(validatingDialog, "workbench.gui.confirmupdate.dialog");
            bl = !validatingDialog.isCancelled();
            bl3 = jCheckBox.isSelected();
            Settings.getInstance().setProperty("workbench.db.previewsql.copyclipboard", bl3);
            if (bl && bl3) {
                this.copyToClipboard(editorPanel);
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error when previewing SQL", sQLException);
            String string = ExceptionUtil.getDisplay(sQLException);
            WbSwingUtilities.showErrorMessage(window, string);
            return false;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (messageBuffer != null) {
                messageBuffer.clear();
                System.gc();
            }
            WbManager.getInstance().showOutOfMemoryError();
            return false;
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error when previewing SQL", throwable);
            WbSwingUtilities.showErrorMessage(component, ExceptionUtil.getDisplay(throwable));
            return false;
        }
        return bl;
    }

    private void copyToClipboard(EditorPanel editorPanel) {
        try {
            Clipboard clipboard = editorPanel.getToolkit().getSystemClipboard();
            String string = editorPanel.getText();
            clipboard.setContents(new StringSelection(string), null);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not copy text to clipboard", throwable);
        }
    }
}

