/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import workbench.gui.WbSwingUtilities;
import workbench.gui.sql.EditorPanel;
import workbench.resource.GuiSettings;
import workbench.sql.ErrorDescriptor;
import workbench.sql.parser.ScriptParser;

public class Highlighter {
    private EditorPanel editor;

    public Highlighter(EditorPanel editorPanel) {
        this.editor = editorPanel;
    }

    public void highlightStatement(ScriptParser scriptParser, int n, int n2) {
        if (this.editor == null) {
            return;
        }
        int n3 = scriptParser.getStartPosForCommand(n) + n2;
        int n4 = scriptParser.getEndPosForCommand(n) + n2;
        int n5 = this.editor.getLineOfOffset(n3);
        WbSwingUtilities.invoke(() -> {
            this.editor.scrollTo(n5, 0);
            this.editor.selectStatementTemporary(n3, n4);
        });
    }

    public void markError(boolean bl, ScriptParser scriptParser, int n, int n2, ErrorDescriptor errorDescriptor) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.editor == null) {
            return;
        }
        if (scriptParser == null) {
            return;
        }
        if (!bl && !GuiSettings.jumpToError()) {
            return;
        }
        if (errorDescriptor != null && errorDescriptor.getErrorPosition() > -1) {
            int n7 = scriptParser.getStartPosForCommand(n) + n2;
            n6 = this.editor.getLineOfOffset(n7 + errorDescriptor.getErrorPosition());
            n5 = this.editor.getLineStartOffset(n6);
            n4 = this.editor.getLineEndOffset(n6) - 1;
            n3 = errorDescriptor.getErrorColumn() > -1 ? n5 + errorDescriptor.getErrorColumn() : n7 + errorDescriptor.getErrorPosition();
        } else {
            n5 = scriptParser.getStartPosForCommand(n) + n2;
            n4 = scriptParser.getEndPosForCommand(n) + n2;
            if (this.editor.getCaretPosition() >= n5 && this.editor.getCaretPosition() <= n4 && !bl) {
                return;
            }
            n6 = this.editor.getLineOfOffset(n5);
            n3 = this.editor.getLineStartOffset(n6);
        }
        WbSwingUtilities.invoke(() -> {
            this.editor.scrollTo(n6, 0);
            if (bl) {
                this.editor.selectError(n5, n4);
            } else {
                this.editor.setCaretPosition(n3);
            }
        });
    }
}

