/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import workbench.console.TextPrinter;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ClearMessagesAction;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.editor.SearchAndReplace;
import workbench.interfaces.FontChangedListener;
import workbench.interfaces.ResultLogger;
import workbench.interfaces.TextContainer;
import workbench.resource.Settings;

public class LogArea
extends JTextArea
implements FontChangedListener,
PropertyChangeListener,
TextContainer,
ResultLogger,
TextPrinter {
    private TextComponentMouseListener contextMenu;
    private int maxLines = Integer.MAX_VALUE;

    public LogArea(Container container) {
        this.setDoubleBuffered(true);
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.setFont(Settings.getInstance().getMsgLogFont());
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.initColors();
        this.contextMenu = new TextComponentMouseListener(this);
        this.addMouseListener(this.contextMenu);
        this.contextMenu.addActionAtStart(new ClearMessagesAction(this), true);
        if (container != null) {
            SearchAndReplace searchAndReplace = new SearchAndReplace(container, this);
            this.contextMenu.addAction(searchAndReplace.getFindAction());
            this.contextMenu.addAction(searchAndReplace.getFindNextAction());
            searchAndReplace.getFindAction().addToInputMap(this);
            searchAndReplace.getFindNextAction().addToInputMap(this);
        }
        Settings.getInstance().addPropertyChangeListener(this, "workbench.editor.color.foreground", "workbench.editor.color.background");
        Settings.getInstance().addFontChangedListener(this);
    }

    @Override
    public void print(String string) {
        this.append(string);
    }

    @Override
    public void println(String string) {
        this.addLine(string);
    }

    @Override
    public void println() {
        this.append("\n");
    }

    @Override
    public void flush() {
    }

    @Override
    public void clearLog() {
        this.setText("");
    }

    @Override
    public void appendToLog(CharSequence charSequence) {
        if (charSequence != null) {
            this.append(charSequence.toString());
        }
    }

    @Override
    public void showLogMessage(CharSequence charSequence) {
        if (charSequence == null) {
            this.setText("");
        } else {
            this.setText(charSequence.toString());
        }
    }

    @Override
    public void setSelectedText(String string) {
        super.replaceSelection(string);
    }

    @Override
    public boolean isTextSelected() {
        return this.getSelectionEnd() > this.getSelectionStart();
    }

    @Override
    public String getWordAtCursor(String string) {
        return null;
    }

    public void dispose() {
        this.setText("");
        Settings.getInstance().removePropertyChangeListener(this);
        Settings.getInstance().removeFontChangedListener(this);
        if (this.contextMenu != null) {
            this.removeMouseListener(this.contextMenu);
            this.contextMenu.dispose();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.initColors();
    }

    @Override
    public void fontChanged(String string, Font font) {
        if (string.equals("msglog")) {
            this.setFont(font);
        }
    }

    private void initColors() {
        Color color;
        Color color2 = Settings.getInstance().getEditorBackgroundColor();
        if (color2 != null) {
            this.setBackground(color2);
        }
        if ((color = Settings.getInstance().getEditorTextColor()) != null) {
            this.setForeground(color);
        }
    }

    public void setMaxLineCount(int n) {
        this.maxLines = n;
    }

    public void deleteLine(int n) {
        try {
            int n2 = this.getLineStartOffset(n);
            int n3 = this.getLineEndOffset(n);
            this.getDocument().remove(n2, n3 - n2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void addLine(String string) {
        if (string == null) {
            return;
        }
        if (this.getLineCount() >= this.maxLines) {
            this.deleteLine(0);
        }
        this.append(string + "\n");
    }

    @Override
    public int getStartInLine(int n) {
        try {
            int n2 = this.getLineOfOffset(n);
            int n3 = this.getLineStartOffset(n2);
            return n - n3;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    @Override
    public String getLineText(int n) {
        try {
            int n2 = this.getLineStartOffset(n);
            int n3 = this.getLineEndOffset(n);
            return this.getText(n3, n2 - n3);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    @Override
    public int getLineOfOffset(int n) {
        try {
            return super.getLineOfOffset(n);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }
}

