/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import javax.swing.JSplitPane;
import workbench.gui.WbSwingUtilities;

public class SplitPaneExpander {
    private JSplitPane contentPanel;
    private int lastDivider = -1;
    private boolean upperPartExpanded;
    private boolean lowerPartExpanded;

    public SplitPaneExpander(JSplitPane jSplitPane) {
        this.contentPanel = jSplitPane;
    }

    public boolean isUpperPartExpanded() {
        int n = this.contentPanel.getDividerLocation();
        return n >= this.contentPanel.getHeight() - this.contentPanel.getDividerSize();
    }

    public void undoExpand() {
        int n = -1;
        n = this.lastDivider != -1 ? this.lastDivider : (this.contentPanel.getLastDividerLocation() > -1 ? this.contentPanel.getLastDividerLocation() : this.contentPanel.getHeight() / 2);
        this.contentPanel.setDividerLocation(n);
        this.lastDivider = -1;
        this.repaintClient();
    }

    public void toggleUpperComponentExpand() {
        if (this.upperPartExpanded) {
            this.undoExpand();
            this.upperPartExpanded = false;
        } else {
            if (!this.lowerPartExpanded) {
                this.lastDivider = this.contentPanel.getDividerLocation();
            }
            this.contentPanel.setDividerLocation(this.contentPanel.getHeight());
            this.upperPartExpanded = true;
        }
        this.lowerPartExpanded = false;
        this.contentPanel.invalidate();
    }

    public void toggleLowerComponentExpand() {
        if (this.lowerPartExpanded) {
            this.undoExpand();
            this.lowerPartExpanded = false;
        } else {
            if (!this.upperPartExpanded) {
                this.lastDivider = this.contentPanel.getDividerLocation();
            }
            this.contentPanel.setDividerLocation(0);
            this.lowerPartExpanded = true;
        }
        this.upperPartExpanded = false;
        this.contentPanel.invalidate();
    }

    private void repaintClient() {
        WbSwingUtilities.invokeLater(this.contentPanel::validate);
    }
}

