/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import workbench.gui.MainWindow;
import workbench.gui.PanelReloader;
import workbench.gui.components.RowHeightOptimizer;
import workbench.gui.components.WbMenu;
import workbench.gui.components.WbTable;
import workbench.gui.macros.MacroMenuBuilder;
import workbench.gui.sql.AutomaticRefreshMgr;
import workbench.gui.sql.DwPanel;
import workbench.sql.annotations.KeepResultAnnotation;
import workbench.sql.annotations.MacroAnnotation;
import workbench.sql.annotations.OptimizeRowHeightAnnotation;
import workbench.sql.annotations.RefreshAnnotation;
import workbench.sql.annotations.ScrollAnnotation;
import workbench.sql.annotations.WbAnnotation;
import workbench.sql.macros.MacroManager;
import workbench.sql.macros.MacroStorage;
import workbench.storage.DataStore;
import workbench.util.StringUtil;

public class TableAnnotationProcessor {
    public void handleAnnotations(PanelReloader panelReloader, DwPanel dwPanel, AutomaticRefreshMgr automaticRefreshMgr) {
        Object object;
        if (dwPanel == null) {
            return;
        }
        WbTable wbTable = dwPanel.getTable();
        if (wbTable == null) {
            return;
        }
        DataStore dataStore = wbTable.getDataStore();
        if (dataStore == null) {
            return;
        }
        String string = dataStore.getGeneratingSql();
        if (StringUtil.isEmptyString(string)) {
            return;
        }
        List<WbAnnotation> list = WbAnnotation.readAllAnnotations(string, new ScrollAnnotation(), new MacroAnnotation(), new RefreshAnnotation(), new OptimizeRowHeightAnnotation(), new KeepResultAnnotation());
        ArrayList<MacroAnnotation> arrayList = new ArrayList<MacroAnnotation>();
        boolean bl = false;
        int n = -1;
        boolean bl2 = false;
        int n2 = -1;
        MainWindow mainWindow = (MainWindow)SwingUtilities.getWindowAncestor(wbTable);
        MacroStorage macroStorage = MacroManager.getInstance().getMacros(mainWindow.getMacroClientId());
        for (WbAnnotation object2 : list) {
            Object object3;
            if (object2.is("WbScrollTo")) {
                object3 = object2.getValue();
                if (object3 == null) continue;
                bl2 = ScrollAnnotation.scrollToEnd((String)object3);
                n2 = ScrollAnnotation.scrollToLine((String)object3);
                continue;
            }
            if (object2.is("WbOptimizeRowHeight")) {
                bl = true;
                n = ((OptimizeRowHeightAnnotation)object2).getMaxLines();
                continue;
            }
            if (automaticRefreshMgr != null && object2.is("WbRefresh")) {
                object3 = object2.getValue();
                int string2 = AutomaticRefreshMgr.parseInterval((String)object3);
                automaticRefreshMgr.addRefresh(panelReloader, dwPanel, string2);
                continue;
            }
            if (object2.is("WbMacro")) {
                object3 = (MacroAnnotation)object2;
                String string2 = ((MacroAnnotation)object3).getMacroName();
                if (string2 == null || macroStorage.getMacro(string2) == null) continue;
                arrayList.add((MacroAnnotation)object3);
                continue;
            }
            if (!object2.is("WbKeepResult")) continue;
            dwPanel.setLocked(true);
        }
        if (arrayList.size() > 0) {
            try {
                object = new MacroMenuBuilder();
                WbMenu wbMenu = ((MacroMenuBuilder)object).buildDataMacroMenu(mainWindow, wbTable, arrayList);
                wbTable.addMacroMenu(wbMenu);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            object = new RowHeightOptimizer(wbTable);
            ((RowHeightOptimizer)object).optimizeAllRows(n);
        }
        if (bl2) {
            wbTable.scrollToRow(wbTable.getRowCount() - 1);
        } else if (n2 > 0) {
            wbTable.scrollToRow(n2 - 1);
        }
    }
}

