/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.toolbar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.toolbar.ActionListModel;
import workbench.gui.toolbar.ActionRenderer;
import workbench.gui.toolbar.ToolbarBuilder;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.FileDialogUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ConfigureToolbarPanel
extends JPanel
implements ValidatingComponent {
    private List<WbAction> allActions;
    private JButton addItem;
    private JButton addSeparator;
    private JList<String> allActionList;
    private JButton assignIconButton;
    private JList<String> configuredActions;
    private Box.Filler filler2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton moveDown;
    private JButton moveUp;
    private JButton removeIconButton;
    private JButton removeItem;
    private JButton resetButton;

    public ConfigureToolbarPanel(List<WbAction> list) {
        this.initComponents();
        this.addItem.setIcon(IconMgr.getInstance().getLabelIcon("move-right"));
        this.addItem.setText("");
        this.removeItem.setIcon(IconMgr.getInstance().getLabelIcon("move-left"));
        this.removeItem.setText("");
        this.allActions = new ArrayList<WbAction>(list);
        this.allActions.sort((wbAction, wbAction2) -> StringUtil.compareStrings(wbAction.getMenuLabel(), wbAction2.getMenuLabel(), true));
        this.allActionList.setCellRenderer(new ActionRenderer());
        this.configuredActions.setCellRenderer(new ActionRenderer());
        List<String> list2 = ToolbarBuilder.getConfiguredToolbarCommands();
        this.allActionList.setModel(new ActionListModel(this.getAvailableToolbarActions(list2)));
        this.configuredActions.setModel(new ActionListModel(this.getConfiguredActions(list2)));
    }

    private void reset() {
        List<String> list = ToolbarBuilder.getDefaultToolbarCommands();
        this.allActionList.setModel(new ActionListModel(this.getAvailableToolbarActions(list)));
        this.configuredActions.setModel(new ActionListModel(this.getConfiguredActions(list)));
    }

    private boolean isEmpty(int[] nArray) {
        return nArray == null || nArray.length == 0;
    }

    private boolean isNotEmpty(int[] nArray) {
        return nArray != null || nArray.length > 0;
    }

    private void addItem() {
        int[] nArray = this.allActionList.getSelectedIndices();
        ActionListModel actionListModel = (ActionListModel)this.allActionList.getModel();
        ActionListModel actionListModel2 = (ActionListModel)this.configuredActions.getModel();
        if (this.isEmpty(nArray)) {
            return;
        }
        int n = -1;
        n = this.configuredActions.getMaxSelectionIndex() > -1 ? this.configuredActions.getMaxSelectionIndex() + 1 : actionListModel2.getSize();
        for (int i = nArray.length - 1; i >= 0; --i) {
            Object object = actionListModel.getElementAt(nArray[i]);
            actionListModel2.addItem(n, object);
            ++n;
            actionListModel.removeItem(nArray[i]);
        }
        this.configuredActions.setSelectedIndex(n - 1);
    }

    private void removeItem() {
        int[] nArray = this.configuredActions.getSelectedIndices();
        if (this.isEmpty(nArray)) {
            return;
        }
        ActionListModel actionListModel = (ActionListModel)this.configuredActions.getModel();
        ActionListModel actionListModel2 = (ActionListModel)this.allActionList.getModel();
        for (int i = nArray.length - 1; i >= 0; --i) {
            Object object = actionListModel.getElementAt(nArray[i]);
            if (object instanceof WbAction) {
                actionListModel2.addItem(object);
            }
            actionListModel.removeItem(nArray[i]);
        }
        this.configuredActions.clearSelection();
    }

    private void checkAddButton() {
        int[] nArray = this.allActionList.getSelectedIndices();
        this.addItem.setEnabled(this.isNotEmpty(nArray));
        this.addSeparator.setEnabled(this.isNotEmpty(nArray));
    }

    private void checkRemoveButton() {
        int[] nArray = this.configuredActions.getSelectedIndices();
        this.removeItem.setEnabled(this.isNotEmpty(nArray));
    }

    private void selectIcon() {
        WbFile wbFile;
        int n = this.configuredActions.getSelectedIndex();
        ActionListModel actionListModel = (ActionListModel)this.configuredActions.getModel();
        Object object = actionListModel.getElementAt(n);
        if (object instanceof WbAction && (wbFile = FileDialogUtil.selectPngFile(this, "workbench.toolbaricon.lastdir")) != null) {
            String string = FileDialogUtil.removeConfigDir(wbFile);
            ((WbAction)object).setCustomIconFile(string);
            this.configuredActions.invalidate();
            WbSwingUtilities.repaintLater(this.configuredActions);
        }
    }

    private void removeCustomIcon() {
        int n = this.configuredActions.getSelectedIndex();
        ActionListModel actionListModel = (ActionListModel)this.configuredActions.getModel();
        Object object = actionListModel.getElementAt(n);
        if (object instanceof WbAction) {
            WbAction wbAction = (WbAction)object;
            wbAction.setCustomIconFile(null);
            this.configuredActions.invalidate();
            WbSwingUtilities.repaintLater(this.configuredActions);
        }
    }

    private void checkIconButtons() {
        ActionListModel actionListModel;
        Object object;
        this.assignIconButton.setEnabled(false);
        this.removeIconButton.setEnabled(false);
        int[] nArray = this.configuredActions.getSelectedIndices();
        if (nArray.length == 1 && (object = (actionListModel = (ActionListModel)this.configuredActions.getModel()).getElementAt(nArray[0])) instanceof WbAction) {
            WbAction wbAction = (WbAction)object;
            this.removeIconButton.setEnabled(wbAction.hasCustomIcon());
            this.assignIconButton.setEnabled(true);
        }
    }

    private void checkMoveButtons() {
        int[] nArray = this.configuredActions.getSelectedIndices();
        if (this.isEmpty(nArray)) {
            this.moveDown.setEnabled(false);
            this.moveUp.setEnabled(false);
            return;
        }
        this.moveUp.setEnabled(true);
        this.moveDown.setEnabled(true);
        if (nArray[0] == 0) {
            this.moveUp.setEnabled(false);
        }
        if (nArray[nArray.length - 1] == this.configuredActions.getModel().getSize() - 1) {
            this.moveDown.setEnabled(false);
        }
    }

    private void addSeparator() {
        int n = this.configuredActions.getMaxSelectionIndex();
        ActionListModel actionListModel = (ActionListModel)this.configuredActions.getModel();
        int n2 = -1;
        if (n == actionListModel.getSize() - 1 || n < 0) {
            actionListModel.addItem("$sep$");
            n2 = actionListModel.getSize() - 1;
        } else {
            actionListModel.addItem(n + 1, "$sep$");
            n2 = n + 1;
        }
        this.configuredActions.setSelectedIndex(n2);
    }

    private void moveUp() {
        int[] nArray = this.configuredActions.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        ActionListModel actionListModel = (ActionListModel)this.configuredActions.getModel();
        int n = nArray[0];
        if (n <= 0) {
            return;
        }
        int n2 = nArray[nArray.length - 1];
        Object object = actionListModel.getElementAt(n - 1);
        for (int i = 0; i < nArray.length; ++i) {
            actionListModel.set(nArray[i] - 1, actionListModel.getElementAt(nArray[i]));
        }
        actionListModel.set(nArray[nArray.length - 1], object);
        this.configuredActions.setSelectionInterval(n - 1, n2 - 1);
    }

    private void moveDown() {
        int[] nArray = this.configuredActions.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        int n = nArray[nArray.length - 1];
        ActionListModel actionListModel = (ActionListModel)this.configuredActions.getModel();
        if (n >= actionListModel.getSize() - 1) {
            return;
        }
        int n2 = nArray[0];
        Object object = actionListModel.getElementAt(n + 1);
        for (int i = nArray.length - 1; i >= 0; --i) {
            actionListModel.set(nArray[i] + 1, actionListModel.getElementAt(nArray[i]));
        }
        actionListModel.set(nArray[0], object);
        this.configuredActions.setSelectionInterval(n2 + 1, n + 1);
    }

    private List getConfiguredActions(List<String> list) {
        List<WbAction> list2 = this.getAllToolbarActions();
        ArrayList<Object> arrayList = new ArrayList<Object>(list2.size());
        for (String string : list) {
            if (string.equals("$sep$")) {
                arrayList.add(string);
                continue;
            }
            WbAction wbAction = this.findAction(list2, string);
            if (wbAction == null) continue;
            arrayList.add(wbAction);
        }
        return arrayList;
    }

    private List<WbAction> getAvailableToolbarActions(List<String> list) {
        List<WbAction> list2 = this.getAllToolbarActions();
        ArrayList<WbAction> arrayList = new ArrayList<WbAction>(list2.size());
        for (WbAction wbAction : list2) {
            if (list.contains(wbAction.getActionCommand())) continue;
            arrayList.add(wbAction);
        }
        return arrayList;
    }

    private List<WbAction> getAllToolbarActions() {
        ArrayList<WbAction> arrayList = new ArrayList<WbAction>(this.allActions.size());
        for (WbAction wbAction : this.allActions) {
            if (!wbAction.useInToolbar() || arrayList.contains(wbAction)) continue;
            arrayList.add(wbAction);
        }
        return arrayList;
    }

    private WbAction findAction(List<WbAction> list, String string) {
        for (WbAction wbAction : list) {
            if (!wbAction.getActionCommand().equals(string)) continue;
            return wbAction;
        }
        return null;
    }

    @Override
    public boolean validateInput() {
        ActionListModel actionListModel = (ActionListModel)this.configuredActions.getModel();
        String string = actionListModel.getToolbarCommands();
        Settings.getInstance().setProperty("workbench.gui.toolbar.actions", string);
        List<WbAction> list = actionListModel.getActions();
        for (WbAction wbAction : list) {
            if (wbAction.hasCustomIcon()) {
                String string2 = wbAction.getCustomIconFile();
                Settings.getInstance().setProperty(wbAction.getCustomIconProperty(), string2);
                continue;
            }
            Settings.getInstance().setProperty(wbAction.getCustomIconProperty(), null);
        }
        return true;
    }

    @Override
    public void componentDisplayed() {
    }

    @Override
    public void componentWillBeClosed() {
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.allActionList = new JList();
        this.jPanel1 = new JPanel();
        this.addItem = new JButton();
        this.removeItem = new JButton();
        this.addSeparator = new JButton();
        this.resetButton = new JButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.configuredActions = new JList();
        this.jPanel2 = new JPanel();
        this.moveUp = new JButton();
        this.moveDown = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.assignIconButton = new JButton();
        this.removeIconButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.allActionList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.allActionList.setSelectionMode(1);
        this.allActionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ConfigureToolbarPanel.this.allActionListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.allActionList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.addItem.setText(">>");
        this.addItem.setEnabled(false);
        this.addItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureToolbarPanel.this.addItemActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        this.jPanel1.add((Component)this.addItem, gridBagConstraints);
        this.removeItem.setText("<<");
        this.removeItem.setEnabled(false);
        this.removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureToolbarPanel.this.removeItemActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        this.jPanel1.add((Component)this.removeItem, gridBagConstraints);
        this.addSeparator.setText(ResourceMgr.getString("LblAddSep"));
        this.addSeparator.setToolTipText(ResourceMgr.getString("d_LblAddSep"));
        this.addSeparator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureToolbarPanel.this.addSeparatorActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 0, 0, 0);
        this.jPanel1.add((Component)this.addSeparator, gridBagConstraints);
        this.resetButton.setText(ResourceMgr.getString("LblReset"));
        this.resetButton.setToolTipText(ResourceMgr.getString("d_LblReset"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureToolbarPanel.this.resetButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.resetButton, gridBagConstraints);
        this.jPanel3.setLayout(new GridLayout(0, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.configuredActions.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.configuredActions.setSelectionMode(1);
        this.configuredActions.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ConfigureToolbarPanel.this.configuredActionsValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane2.setViewportView(this.configuredActions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 5);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel2.setLayout(new GridLayout(0, 1));
        this.moveUp.setIcon(IconMgr.getInstance().getLabelIcon("Up"));
        this.moveUp.setEnabled(false);
        this.moveUp.setPreferredSize(new Dimension(33, 18));
        this.moveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureToolbarPanel.this.moveUpActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.moveUp);
        this.moveDown.setIcon(IconMgr.getInstance().getLabelIcon("Down"));
        this.moveDown.setEnabled(false);
        this.moveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureToolbarPanel.this.moveDownActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.moveDown);
        this.jPanel2.add(this.filler2);
        this.assignIconButton.setIcon(IconMgr.getInstance().getLabelIcon("open"));
        this.assignIconButton.setToolTipText(ResourceMgr.getString("d_LblSelectTbIcon"));
        this.assignIconButton.setEnabled(false);
        this.assignIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureToolbarPanel.this.assignIconButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.assignIconButton);
        this.removeIconButton.setIcon(IconMgr.getInstance().getLabelIcon("delete"));
        this.removeIconButton.setToolTipText(ResourceMgr.getString("d_LblRemoveTbIcon"));
        this.removeIconButton.setEnabled(false);
        this.removeIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureToolbarPanel.this.removeIconButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.removeIconButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void configuredActionsValueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkMoveButtons();
        this.checkRemoveButton();
        this.checkIconButtons();
    }

    private void moveUpActionPerformed(ActionEvent actionEvent) {
        this.moveUp();
    }

    private void moveDownActionPerformed(ActionEvent actionEvent) {
        this.moveDown();
    }

    private void allActionListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkAddButton();
    }

    private void addItemActionPerformed(ActionEvent actionEvent) {
        this.addItem();
    }

    private void removeItemActionPerformed(ActionEvent actionEvent) {
        this.removeItem();
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        this.reset();
    }

    private void addSeparatorActionPerformed(ActionEvent actionEvent) {
        this.addSeparator();
    }

    private void removeIconButtonActionPerformed(ActionEvent actionEvent) {
        this.removeCustomIcon();
    }

    private void assignIconButtonActionPerformed(ActionEvent actionEvent) {
        this.selectIcon();
    }
}

