/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.toolbar;

import java.util.ArrayList;
import java.util.List;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.AppendResultsAction;
import workbench.gui.actions.CommitAction;
import workbench.gui.actions.CopyRowAction;
import workbench.gui.actions.DeleteRowAction;
import workbench.gui.actions.ExecuteCurrentAction;
import workbench.gui.actions.ExecuteSelAction;
import workbench.gui.actions.FilterDataAction;
import workbench.gui.actions.FilterPickerAction;
import workbench.gui.actions.FirstStatementAction;
import workbench.gui.actions.IgnoreErrorsAction;
import workbench.gui.actions.InsertRowAction;
import workbench.gui.actions.LastStatementAction;
import workbench.gui.actions.NextStatementAction;
import workbench.gui.actions.PrevStatementAction;
import workbench.gui.actions.ResetFilterAction;
import workbench.gui.actions.RollbackAction;
import workbench.gui.actions.SelectionFilterAction;
import workbench.gui.actions.ShowDbExplorerAction;
import workbench.gui.actions.ShowDbTreeAction;
import workbench.gui.actions.StopAction;
import workbench.gui.actions.UpdateDatabaseAction;
import workbench.gui.actions.WbAction;
import workbench.gui.toolbar.MainToolbar;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class ToolbarBuilder {
    public static final String CONFIG_PROPERTY = "workbench.gui.toolbar.actions";
    public static final String SEPARATOR_KEY = "$sep$";
    private static final String DEFAULT_ACTIONS = ExecuteSelAction.class.getSimpleName() + "," + ExecuteCurrentAction.class.getSimpleName() + "," + "$sep$" + "," + StopAction.class.getSimpleName() + "," + "$sep$" + "," + FirstStatementAction.class.getSimpleName() + "," + PrevStatementAction.class.getSimpleName() + "," + NextStatementAction.class.getSimpleName() + "," + LastStatementAction.class.getSimpleName() + "," + "$sep$" + "," + UpdateDatabaseAction.class.getSimpleName() + "," + InsertRowAction.class.getSimpleName() + "," + CopyRowAction.class.getSimpleName() + "," + DeleteRowAction.class.getSimpleName() + "," + SelectionFilterAction.class.getSimpleName() + "," + FilterDataAction.class.getSimpleName() + "," + FilterPickerAction.class.getSimpleName() + "," + ResetFilterAction.class.getSimpleName() + "," + "$sep$" + "," + CommitAction.class.getSimpleName() + "," + RollbackAction.class.getSimpleName() + "," + "$sep$" + "," + IgnoreErrorsAction.class.getSimpleName() + "," + AppendResultsAction.class.getSimpleName() + "," + "$sep$" + "," + ShowDbExplorerAction.class.getSimpleName() + "," + ShowDbTreeAction.class.getSimpleName();
    private MainToolbar toolbar;
    private final List<WbAction> mainActions;
    private final List<WbAction> panelActions;

    public ToolbarBuilder(List<WbAction> list, List<WbAction> list2) {
        this.mainActions = new ArrayList<WbAction>(list2);
        this.panelActions = new ArrayList<WbAction>(list);
    }

    public MainToolbar createToolbar() {
        WbSwingUtilities.invoke(this::_createToolbar);
        return this.toolbar;
    }

    private void _createToolbar() {
        this.toolbar = new MainToolbar();
        List<String> list = ToolbarBuilder.getConfiguredToolbarCommands();
        LogMgr.logTrace(new CallerInfo(){}, "Using toolbar list: " + list);
        for (String string : list) {
            if (string.equals(SEPARATOR_KEY)) {
                this.toolbar.addSeparator();
                continue;
            }
            WbAction wbAction = this.getPanelAction(string);
            if (wbAction != null) {
                wbAction.addToToolbar(this.toolbar);
                continue;
            }
            wbAction = this.getGlobalAction(string);
            if (wbAction != null) {
                this.toolbar.add(wbAction.getToolbarButton(true));
                continue;
            }
            LogMgr.logWarning(new CallerInfo(){}, "Action: " + string + " not found!");
        }
        if (!list.get(list.size() - 1).equals(SEPARATOR_KEY)) {
            this.toolbar.addSeparator();
        }
        this.toolbar.addConnectionInfo();
    }

    public static List<String> getDefaultToolbarCommands() {
        return StringUtil.stringToList(DEFAULT_ACTIONS, ",", true, true, false, false);
    }

    public static List<String> getConfiguredToolbarCommands() {
        return Settings.getInstance().getListProperty(CONFIG_PROPERTY, false, DEFAULT_ACTIONS);
    }

    private WbAction getPanelAction(String string) {
        for (WbAction wbAction : this.panelActions) {
            if (!wbAction.getActionCommand().equals(string)) continue;
            return wbAction;
        }
        return null;
    }

    private WbAction getGlobalAction(String string) {
        for (WbAction wbAction : this.mainActions) {
            if (!wbAction.getActionCommand().equals(string)) continue;
            return wbAction;
        }
        return null;
    }
}

