/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import workbench.WbManager;
import workbench.console.ConsolePrinter;
import workbench.console.DataStorePrinter;
import workbench.console.TextPrinter;
import workbench.db.ConnectionInfoBuilder;
import workbench.db.DriverInfo;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbTabbedPane;
import workbench.gui.components.WbTable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;

public class ConnectionInfoPanel
extends JPanel {
    private WbTable extendedInfoData;
    private JButton copyButton;
    private JPanel extendedPanel;
    private JTabbedPane infoTabs;
    private JEditorPane infotext;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    public ConnectionInfoPanel(WbConnection wbConnection) {
        this.initComponents();
        try {
            ConnectionInfoBuilder connectionInfoBuilder = new ConnectionInfoBuilder();
            this.infotext.setContentType("text/html");
            this.infotext.setFont(Settings.getInstance().getEditorFont());
            this.infotext.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.infotext.setText(connectionInfoBuilder.getHtmlDisplay(wbConnection));
            this.infotext.setCaretPosition(0);
            TextComponentMouseListener.addListener(this.infotext);
            FontMetrics fontMetrics = this.infotext.getFontMetrics(this.infotext.getFont());
            int n = fontMetrics.getHeight() * 12 + 40;
            Dimension dimension = new Dimension(470, n);
            this.jScrollPane1.setSize(dimension);
            this.jScrollPane1.setPreferredSize(dimension);
            this.jScrollPane1.setMaximumSize(dimension);
            this.infoTabs.setTitleAt(0, ResourceMgr.getString("TxtInfoBasic"));
            if (wbConnection.isBusy()) {
                this.infoTabs.remove(1);
            } else {
                DriverInfo driverInfo = new DriverInfo(wbConnection.getSqlConnection());
                this.extendedInfoData = new WbTable(true, false, false);
                WbScrollPane wbScrollPane = new WbScrollPane(this.extendedInfoData);
                wbScrollPane.setPreferredSize(dimension);
                wbScrollPane.setMaximumSize(dimension);
                DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(driverInfo.getInfo());
                this.extendedInfoData.setModel(dataStoreTableModel, true);
                this.extendedPanel.add((Component)wbScrollPane, "Center");
                this.infoTabs.setTitleAt(1, ResourceMgr.getString("TxtInfoExt"));
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not read connection properties", exception);
        }
    }

    public void dispose() {
        if (this.extendedInfoData != null) {
            this.extendedInfoData.dispose();
        }
    }

    public static void showConnectionInfo(WbConnection wbConnection) {
        ConnectionInfoPanel connectionInfoPanel = new ConnectionInfoPanel(wbConnection);
        JFrame jFrame = WbManager.getInstance().getCurrentWindow();
        ValidatingDialog validatingDialog = new ValidatingDialog((Frame)jFrame, ResourceMgr.getString("LblConnInfo"), (JComponent)connectionInfoPanel, false);
        validatingDialog.pack();
        WbSwingUtilities.center(validatingDialog, jFrame);
        validatingDialog.setVisible(true);
        connectionInfoPanel.dispose();
        validatingDialog.dispose();
    }

    private void initComponents() {
        this.infoTabs = new WbTabbedPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.infotext = new InfoEditorPane();
        this.copyButton = new JButton();
        this.extendedPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.infotext.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.infotext.setContentType("text/html");
        this.infotext.setEditable(false);
        this.infotext.setFont(new Font("Dialog", 0, 11));
        this.jScrollPane1.setViewportView(this.infotext);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.copyButton.setText(ResourceMgr.getString("LblCopyToClp"));
        this.copyButton.setToolTipText(ResourceMgr.getString("d_LblCopyToClp"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionInfoPanel.this.copyButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.copyButton, gridBagConstraints);
        this.infoTabs.addTab("Basic", this.jPanel1);
        this.extendedPanel.setLayout(new BorderLayout());
        this.infoTabs.addTab("Extended", this.extendedPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.infoTabs, gridBagConstraints);
    }

    private void copyButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.infotext.getText();
        this.copyText(string, true);
    }

    public void copyText(String string, boolean bl) {
        Object object;
        Object object2;
        String string2 = string;
        if (bl) {
            string2 = string.replaceAll("((\r\n)|(\n\r)|\r|\n)", " ");
        }
        string2 = string2.replaceAll(" {2,}", "");
        string2 = string2.replaceAll("<br>", "\r\n");
        string2 = string2.replaceAll("<div[0-9 a-zA-Z;=\\-\":]*>", "");
        string2 = string2.replaceAll("</div>", "\r\n");
        string2 = string2.replaceAll("<[/a-z]*>", "").trim();
        if (this.extendedInfoData != null && bl) {
            object2 = this.extendedInfoData.getDataStore();
            object = new DataStorePrinter((DataStore)object2);
            ((ConsolePrinter)object).setPrintRowCount(false);
            StringWriter stringWriter = new StringWriter(100);
            TextPrinter textPrinter = TextPrinter.createPrinter(stringWriter);
            ((DataStorePrinter)object).printTo(textPrinter);
            string2 = string2 + "\n\n" + stringWriter.toString();
        }
        object2 = Toolkit.getDefaultToolkit().getSystemClipboard();
        object = new StringSelection(string2);
        ((Clipboard)object2).setContents((Transferable)object, (ClipboardOwner)object);
    }

    private class InfoEditorPane
    extends JEditorPane {
        InfoEditorPane() {
        }

        @Override
        public void copy() {
            String string = this.getSelectedText();
            if (string == null) {
                string = this.getText();
            }
            ConnectionInfoPanel.this.copyText(string, false);
        }
    }
}

