/*
 * Decompiled with CFR 0.152.
 */
package workbench.interfaces;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeSelectionModel;
import workbench.interfaces.WbSelectionListener;
import workbench.interfaces.WbSelectionModel;

public class SelectionFacade
implements WbSelectionModel,
ListSelectionListener,
TreeSelectionListener {
    private final ListSelectionModel listModel;
    private final TreeSelectionModel treeModel;
    private List<WbSelectionListener> listenerList = new ArrayList<WbSelectionListener>(2);

    public SelectionFacade(ListSelectionModel listSelectionModel) {
        this.listModel = listSelectionModel;
        this.listModel.addListSelectionListener(this);
        this.treeModel = null;
    }

    public SelectionFacade(TreeSelectionModel treeSelectionModel) {
        this.treeModel = treeSelectionModel;
        this.treeModel.addTreeSelectionListener(this);
        this.listModel = null;
    }

    @Override
    public void addSelectionListener(WbSelectionListener wbSelectionListener) {
        this.listenerList.add(wbSelectionListener);
    }

    @Override
    public void removeSelectionListener(WbSelectionListener wbSelectionListener) {
        this.listenerList.remove(wbSelectionListener);
    }

    @Override
    public boolean hasSelection() {
        if (this.treeModel != null) {
            return this.treeModel.getSelectionCount() > 0;
        }
        if (this.listModel != null) {
            return this.listModel.getMinSelectionIndex() >= 0;
        }
        return false;
    }

    @Override
    public int getSelectionCount() {
        if (this.treeModel != null) {
            return this.treeModel.getSelectionCount();
        }
        if (this.listModel == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.listModel.getMinSelectionIndex();
        int n3 = this.listModel.getMaxSelectionIndex();
        for (int i = n2; i <= n3; ++i) {
            if (!this.listModel.isSelectedIndex(i)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        for (WbSelectionListener wbSelectionListener : this.listenerList) {
            if (wbSelectionListener == null) continue;
            wbSelectionListener.selectionChanged(this);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        for (WbSelectionListener wbSelectionListener : this.listenerList) {
            if (wbSelectionListener == null) continue;
            wbSelectionListener.selectionChanged(this);
        }
    }
}

