/*
 * Decompiled with CFR 0.152.
 */
package workbench.resource;

import java.awt.Color;
import java.io.File;
import java.util.Set;
import javax.swing.KeyStroke;
import workbench.db.objectcache.ObjectCacheStorage;
import workbench.gui.components.GuiPosition;
import workbench.gui.sql.FileReloadType;
import workbench.interfaces.ResultReceiver;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DataTooltipType;
import workbench.resource.ErrorPromptType;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.MacOSHelper;
import workbench.util.StringUtil;

public class GuiSettings {
    public static final String PROPERTY_HILITE_ERROR_LINE = "workbench.gui.editor.execute.highlighterror";
    public static final String PROPERTY_CLOSE_ACTIVE_TAB = "workbench.gui.display.tab.closebutton.onlyactive";
    public static final String PROPERTY_SQLTAB_CLOSE_BUTTON = "workbench.gui.display.sqltab.closebutton";
    public static final String PROPERTY_RESULTTAB_CLOSE_BUTTON = "workbench.gui.display.resulttab.closebutton";
    public static final String PROPERTY_RESULTTAB_CLOSE_BUTTON_RIGHT = "workbench.gui.closebutton.right";
    public static final String PROPERTY_EXEC_SEL_ONLY = "workbench.gui.editor.execute.onlyselected";
    public static final String PROPERTY_QUICK_FILTER_REGEX = "workbench.gui.quickfilter.useregex";
    public static final String PROPERTY_COMPLETE_CHARS = "workbench.editor.completechars";
    public static final String PROPERTY_EXPAND_KEYSTROKE = "workbench.editor.expand.macro.key";
    public static final String PROPERTY_EXPAND_MAXDURATION = "workbench.editor.expand.maxduration";
    public static final String PROPERTY_SHOW_RESULT_SQL = "workbench.gui.display.result.sql";
    public static final String PROPERTY_MACRO_POPUP_WKSP = "workbench.gui.macropopup.useworkspace";
    public static final String PROPERTY_MACRO_POPUP_CLOSE_ESC = "workbench.gui.macropopup.esc.closes";
    public static final String PROPERTY_MACRO_POPUP_RUN_ON_ENTER = "workbench.gui.macropopup.enter.run";
    public static final String PROPERTY_MACRO_POPUP_SHOW_TOOLBAR = "workbench.gui.macropopup.show.filter";
    public static final String PROPERTY_MACRO_POPUP_QUICKFILTER = "workbench.gui.macropopup.quickfilter";
    public static final String PROPERTY_MACRO_SOURCE_TOOLTIP_LENGTH = "workbench.gui.macro.source.tooltip.length";
    public static final String PROPERTY_MACRO_MENU_USE_SOURCE_TOOLTIP = "workbench.gui.macro.menuitem.tooltip.usesource";
    public static final String PROP_TITLE_SHOW_WKSP = "workbench.gui.display.showpworkspace";
    public static final String PROP_TITLE_SHOW_URL = "workbench.gui.display.showurl";
    public static final String PROP_TITLE_SHOW_URL_USER = "workbench.gui.display.showurl.includeuser";
    public static final String PROP_TITLE_SHOW_URL_CLEANUP = "workbench.gui.display.showurl.cleanup";
    public static final String PROP_TITLE_REMOVE_URL_PRODUCT = "workbench.gui.display.showurl.removeproduct";
    public static final String PROP_TITLE_SHOW_PROF_GROUP = "workbench.gui.display.showprofilegroup";
    public static final String PROP_TITLE_APP_AT_END = "workbench.gui.display.name_at_end";
    public static final String PROP_TITLE_SHOW_EDITOR_FILE = "workbench.gui.display.showfilename";
    public static final String PROP_TITLE_GROUP_SEP = "workbench.gui.display.titlegroupsep";
    public static final String PROP_TITLE_GROUP_BRACKET = "workbench.gui.display.titlegroupbracket";
    public static final String PROP_FONT_ZOOM_WHEEL = "workbench.gui.fontzoom.mousewheel";
    public static final String PROP_NUMBER_ALIGN = "workbench.gui.renderer.numberalignment";
    public static final String PROPERTY_BOOKMARKS_UPDATE_ON_OPEN = "workbench.bookmarks.update.ondisplay";
    public static final String PROPERTY_BOOKMARKS_USE_WBRESULT = "workbench.bookmarks.use.wbresult";
    public static final String PROPERTY_BOOKMARKS_PARSE_PROCS = "workbench.bookmarks.parse.procs";
    public static final String PROPERTY_BOOKMARKS_PROCS_INCL_PNAME = "workbench.bookmarks.procs.parm_name";
    public static final String PROPERTY_BOOKMARKS_MAX_COL_WIDTH = "workbench.bookmarks.list.max_col_width";
    public static final String PROPERTY_BOOKMARKS_PKG_DEF_CHAR = "workbench.bookmarks.package_spec.character";
    public static final Set<String> WINDOW_TITLE_PROPS = CollectionUtil.treeSet("workbench.gui.display.name_at_end", "workbench.gui.display.showpworkspace", "workbench.gui.display.showurl", "workbench.gui.display.showprofilegroup", "workbench.gui.display.showfilename", "workbench.gui.display.titlegroupsep", "workbench.gui.display.titlegroupbracket");
    public static final String PROP_TABLE_HEADER_BOLD = "workbench.gui.table.header.bold";
    public static final String PROP_TABLE_HEADER_DATATYPE = "workbench.gui.table.header.include.type";
    public static final String PROP_TABLE_HEADER_REMARKS = "workbench.gui.table.header.include.remarks";
    public static final String PROP_TABLE_HEADER_FULL_TYPE_INFO = "workbench.gui.table.header.typeinfo.full";
    public static final String PROP_WRAP_MULTILINE_RENDERER = "workbench.gui.display.multiline.renderer.wrap";
    public static final String PROP_MULTILINE_RENDERER_USE_READER = "workbench.gui.display.multiline.renderer.use.reader";
    public static final String PROP_WRAP_MULTILINE_EDITOR = "workbench.gui.display.multiline.editor.wrap";
    public static final String PROP_FILE_RELOAD_TYPE = "workbench.gui.editor.file.reloadtype";
    public static final String PROP_LOCAL_OBJECT_CACHE = "workbench.gui.completioncache.localstorage";
    public static final String PROP_LOCAL_OBJECT_CACHE_MAXAGE = "workbench.gui.completioncache.localstorage.maxage";
    public static final String PROP_LOCAL_OBJECT_CACHE_DIR = "workbench.gui.completioncache.localstorage.cachedir";
    public static final String PROP_USE_CURRENT_LINE_FOR_CURRENT_STMT = "workbench.gui.sql.current.line.statement";
    public static final String PROP_SHOW_SCRIPT_PROGRESS = "workbench.gui.sql.script.statement.feedback";
    public static final String PROP_COPY_TEXT_DISPLAY_DLG = "workbench.gui.copy.text.displayoptions";
    public static final String PROP_BOOKMARK_PREFIX = "workbench.gui.bookmarks.";
    public static final String PROP_BOOKMARKS_SAVE_WIDTHS = "workbench.gui.bookmarks.colwidths.save";
    public static final String PROP_BOOKMARKS_SAVE_SORT = "workbench.gui.bookmarks.sort.save";
    public static final String PROP_PLAIN_EDITOR_WRAP = "workbench.editor.plain.wordwrap";
    public static final String PROP_GLOBAL_SEARCH_SAVE_COLWIDTHS = "workbench.gui.global.search.save.colwidths";
    public static final String PROP_SHOW_TEXT_SELECTION_INFO = "workbench.gui.text.selection.summary";
    public static final int SHOW_NO_FILENAME = 0;
    public static final int SHOW_FILENAME = 1;
    public static final int SHOW_FULL_PATH = 2;

    public static boolean includeQueryWithResultAsText() {
        return Settings.getInstance().getBoolProperty("workbench.gui.resultastext.include.sql", false);
    }

    public static boolean showScriptProgress() {
        return Settings.getInstance().getBoolProperty(PROP_SHOW_SCRIPT_PROGRESS, true);
    }

    public static void setShowScriptProgress(boolean bl) {
        Settings.getInstance().setProperty(PROP_SHOW_SCRIPT_PROGRESS, bl);
    }

    public static boolean showApplyDDLHint() {
        return Settings.getInstance().getBoolProperty("workbench.gui.apply.ddl.hint", true);
    }

    public static boolean getSaveBookmarkColWidths() {
        return Settings.getInstance().getBoolProperty(PROP_BOOKMARKS_SAVE_WIDTHS, false);
    }

    public static void setSaveBookmarksColWidths(boolean bl) {
        Settings.getInstance().setProperty(PROP_BOOKMARKS_SAVE_WIDTHS, bl);
    }

    public static boolean getSaveBookmarkSort() {
        return Settings.getInstance().getBoolProperty(PROP_BOOKMARKS_SAVE_SORT, false);
    }

    public static void setSaveBookmarksSort(boolean bl) {
        Settings.getInstance().setProperty(PROP_BOOKMARKS_SAVE_SORT, bl);
    }

    public static boolean getUseResultTagForBookmarks() {
        return Settings.getInstance().getBoolProperty(PROPERTY_BOOKMARKS_USE_WBRESULT, false);
    }

    public static void setUseResultTagForBookmarks(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_BOOKMARKS_USE_WBRESULT, bl);
    }

    public static boolean getProcBookmarksIncludeParmName() {
        return Settings.getInstance().getBoolProperty(PROPERTY_BOOKMARKS_PROCS_INCL_PNAME, false);
    }

    public static void setProcBookmarksIncludeParmName(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_BOOKMARKS_PROCS_INCL_PNAME, bl);
    }

    public static boolean getParseProceduresForBookmarks() {
        return Settings.getInstance().getBoolProperty(PROPERTY_BOOKMARKS_PARSE_PROCS, true);
    }

    public static void setParseProceduresForBookmarks(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_BOOKMARKS_PARSE_PROCS, bl);
    }

    public static String getBookmarksPkgSpecPrefix() {
        return Settings.getInstance().getProperty(PROPERTY_BOOKMARKS_PKG_DEF_CHAR, "$");
    }

    public static boolean updateAllBookmarksOnOpen() {
        return Settings.getInstance().getBoolProperty(PROPERTY_BOOKMARKS_UPDATE_ON_OPEN, false);
    }

    public static int getBookmarksMaxColumnWidth() {
        return Settings.getInstance().getIntProperty(PROPERTY_BOOKMARKS_MAX_COL_WIDTH, 60);
    }

    public static void setBookmarksMaxColumnWidth(int n) {
        Settings.getInstance().setProperty(PROPERTY_BOOKMARKS_MAX_COL_WIDTH, n);
    }

    public static int getMaxExpansionPause() {
        return Settings.getInstance().getIntProperty(PROPERTY_EXPAND_MAXDURATION, 350);
    }

    public static KeyStroke getExpansionKey() {
        String string = Settings.getInstance().getProperty(PROPERTY_EXPAND_KEYSTROKE, "32,0");
        String[] stringArray = string.split(",");
        int n = Integer.valueOf(stringArray[0]);
        int n2 = Integer.valueOf(stringArray[1]);
        return KeyStroke.getKeyStroke(n, n2);
    }

    public static void setExpansionKey(KeyStroke keyStroke) {
        int n = keyStroke.getKeyCode();
        int n2 = keyStroke.getModifiers();
        Settings.getInstance().setProperty(PROPERTY_EXPAND_KEYSTROKE, Integer.toString(n) + "," + Integer.toString(n2));
    }

    public static int getMacroSourceTooltipLength() {
        return Settings.getInstance().getIntProperty(PROPERTY_MACRO_SOURCE_TOOLTIP_LENGTH, 500);
    }

    public static boolean useMacroSourceForMenuTooltip() {
        return Settings.getInstance().getBoolProperty(PROPERTY_MACRO_MENU_USE_SOURCE_TOOLTIP, true);
    }

    public static void setRunMacroWithEnter(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_MACRO_POPUP_RUN_ON_ENTER, bl);
    }

    public static boolean getRunMacroWithEnter() {
        return Settings.getInstance().getBoolProperty(PROPERTY_MACRO_POPUP_RUN_ON_ENTER, true);
    }

    public static boolean getCloseMacroPopupWithEsc() {
        return Settings.getInstance().getBoolProperty(PROPERTY_MACRO_POPUP_CLOSE_ESC, false);
    }

    public static void setCloseMacroPopupWithEsc(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_MACRO_POPUP_CLOSE_ESC, bl);
    }

    public static boolean getStoreMacroPopupInWorkspace() {
        return Settings.getInstance().getBoolProperty(PROPERTY_MACRO_POPUP_WKSP, false);
    }

    public static void setStoreMacroPopupInWorkspace(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_MACRO_POPUP_WKSP, bl);
    }

    public static boolean getShowToolbarInMacroPopup() {
        return Settings.getInstance().getBoolProperty(PROPERTY_MACRO_POPUP_SHOW_TOOLBAR, true);
    }

    public static void setShowToolbarInMacroPopup(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_MACRO_POPUP_SHOW_TOOLBAR, bl);
    }

    public static boolean filterMacroWhileTyping() {
        return Settings.getInstance().getBoolProperty(PROPERTY_MACRO_POPUP_QUICKFILTER, false);
    }

    public static boolean getShowResultSQL() {
        return Settings.getInstance().getBoolProperty(PROPERTY_SHOW_RESULT_SQL, false);
    }

    public static void setShowResultSQL(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_SHOW_RESULT_SQL, bl);
    }

    public static boolean getHighlightErrorStatement() {
        return Settings.getInstance().getBoolProperty(PROPERTY_HILITE_ERROR_LINE, false);
    }

    public static void setHighlightErrorStatement(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_HILITE_ERROR_LINE, bl);
    }

    public static boolean getDisableEditorDuringExecution() {
        return Settings.getInstance().getBoolProperty("workbench.gui.editor.exec.disable", true);
    }

    public static void setDisableEditorDuringExecution(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.editor.exec.disable", bl);
    }

    public static boolean getUseRegexInQuickFilter() {
        return Settings.getInstance().getBoolProperty(PROPERTY_QUICK_FILTER_REGEX, true);
    }

    public static void setUseRegexInQuickFilter(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_QUICK_FILTER_REGEX, bl);
    }

    public static boolean getUseShellFolders() {
        return Settings.getInstance().getBoolProperty("workbench.gui.filechooser.useshellfolder", true);
    }

    public static boolean getShowMaxRowsReached() {
        return Settings.getInstance().getBoolProperty("workbench.gui.maxrows.warning.show", true);
    }

    public static void setShowMaxRowsReached(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.maxrows.warning.show", bl);
    }

    public static int getRowNumberMargin() {
        return Settings.getInstance().getIntProperty("workbench.gui.table.rownumber.margin", 1);
    }

    public static boolean getShowTableRowNumbers() {
        return Settings.getInstance().getBoolProperty("workbench.gui.table.rownumber.show", false);
    }

    public static void setShowTableRowNumbers(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.table.rownumber.show", bl);
    }

    public static boolean getCycleCompletionPopup() {
        return Settings.getInstance().getBoolProperty("workbench.gui.autocompletion.cycle.popup", true);
    }

    public static void setCycleCompletionPopup(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.autocompletion.cycle.popup", bl);
    }

    public static boolean getSortCompletionColumns() {
        return Settings.getInstance().getBoolProperty("workbench.gui.autocompletion.sortcolumns", true);
    }

    public static void setSortCompletionColumns(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.autocompletion.sortcolumns", bl);
    }

    public static boolean getPartialCompletionSearch() {
        return Settings.getInstance().getBoolProperty("workbench.gui.autocompletion.partialsearch", true);
    }

    public static void setPartialCompletionSearch(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.autocompletion.partialsearch", bl);
    }

    public static boolean getFilterCompletionSearch() {
        return Settings.getInstance().getBoolProperty("workbench.gui.autocompletion.filtersearch", false);
    }

    public static void setFilterCompletionSearch(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.autocompletion.filtersearch", bl);
    }

    public static boolean showColumnDataTypesInCompletion() {
        return Settings.getInstance().getBoolProperty("workbench.gui.autocompletion.show.datatype", true);
    }

    public static void setShowColumnDataTypesInCompletion(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.autocompletion.show.datatype", bl);
    }

    public static boolean getRetrieveQueryComments() {
        return Settings.getInstance().getBoolProperty("workbench.gui.query.retrieve.comments", false);
    }

    public static void setRetrieveQueryComments(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.query.retrieve.comments", bl);
    }

    public static boolean useFlatTabCloseButton() {
        return Settings.getInstance().getBoolProperty("workbench.gui.tabclose.flat", true);
    }

    public static boolean useSystemTrayForAlert() {
        return Settings.getInstance().getBoolProperty("workbench.gui.script.alert.systemtray", false);
    }

    public static void setUseSystemTrayForAlert(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.script.alert.systemtray", bl);
    }

    public static boolean showScriptFinishedAlert() {
        return Settings.getInstance().getBoolProperty("workbench.gui.script.alert", false);
    }

    public static void setShowScriptFinishedAlert(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.script.alert", bl);
    }

    public static long getScriptFinishedAlertDuration() {
        String string = Settings.getInstance().getProperty("workbench.gui.script.alert.minduration", null);
        if (StringUtil.isBlank(string)) {
            return 0L;
        }
        return Long.parseLong(string);
    }

    public static void setScriptFinishedAlertDuration(long l) {
        Settings.getInstance().setProperty("workbench.gui.script.alert.minduration", Long.toString(l));
    }

    public static boolean showSynonymTargetInDbExplorer() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.synonyms.showtarget", true);
    }

    public static void setShowSynonymTargetInDbExplorer(boolean bl) {
        Settings.getInstance().setProperty("workbench.dbexplorer.synonyms.showtarget", bl);
    }

    public static boolean getKeepCurrentSqlHighlight() {
        return Settings.getInstance().getBoolProperty("workbench.gui.keep.currentsql.selection", true);
    }

    public static void setKeepCurrentSqlHighlight(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.keep.currentsql.selection", bl);
    }

    public static int getDefaultMaxRows() {
        return Settings.getInstance().getIntProperty("workbench.gui.data.maxrows", 0);
    }

    public static void setDefaultMaxRows(int n) {
        Settings.getInstance().setProperty("workbench.gui.data.maxrows", n);
    }

    public static boolean getUseLRUForTabs() {
        return Settings.getInstance().getBoolProperty("workbench.gui.tabs.lru", true);
    }

    public static void setUseLRUForTabs(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.tabs.lru", bl);
    }

    public static boolean getExecuteOnlySelected() {
        return Settings.getInstance().getBoolProperty(PROPERTY_EXEC_SEL_ONLY, false);
    }

    public static void setExecuteOnlySelected(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_EXEC_SEL_ONLY, bl);
    }

    public static boolean getFollowFileDirectory() {
        return Settings.getInstance().getBoolProperty("workbench.gui.editor.followfiledir", false);
    }

    public static void setFollowFileDirectory(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.editor.followfiledir", bl);
    }

    public static File getDefaultFileDir() {
        String string = Settings.getInstance().getProperty("workbench.gui.editor.defaultdir", null);
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public static void setDefaultFileDir(String string) {
        Settings.getInstance().setProperty("workbench.gui.editor.defaultdir", string);
    }

    public static boolean getShowCloseButtonOnRightSide() {
        return Settings.getInstance().getBoolProperty(PROPERTY_RESULTTAB_CLOSE_BUTTON_RIGHT, true);
    }

    public static void setShowCloseButtonOnRightSide(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_RESULTTAB_CLOSE_BUTTON_RIGHT, bl);
    }

    public static boolean getCloseActiveTabOnly() {
        return Settings.getInstance().getBoolProperty(PROPERTY_CLOSE_ACTIVE_TAB, false);
    }

    public static void setCloseActiveTabOnly(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_CLOSE_ACTIVE_TAB, bl);
    }

    public static boolean getShowSqlTabCloseButton() {
        return Settings.getInstance().getBoolProperty(PROPERTY_SQLTAB_CLOSE_BUTTON, false);
    }

    public static void setShowTabCloseButton(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_SQLTAB_CLOSE_BUTTON, bl);
    }

    public static boolean getShowResultTabCloseButton() {
        return Settings.getInstance().getBoolProperty(PROPERTY_RESULTTAB_CLOSE_BUTTON, false);
    }

    public static void setShowResultTabCloseButton(boolean bl) {
        Settings.getInstance().setProperty(PROPERTY_RESULTTAB_CLOSE_BUTTON, bl);
    }

    public static boolean getWrapMultilineEditor() {
        return Settings.getInstance().getBoolProperty(PROP_WRAP_MULTILINE_EDITOR, false);
    }

    public static void setWrapMultilineEditor(boolean bl) {
        Settings.getInstance().setProperty(PROP_WRAP_MULTILINE_EDITOR, bl);
    }

    public static boolean getWrapMultilineRenderer() {
        return Settings.getInstance().getBoolProperty(PROP_WRAP_MULTILINE_RENDERER, false);
    }

    public static void setWrapMultilineRenderer(boolean bl) {
        Settings.getInstance().setProperty(PROP_WRAP_MULTILINE_RENDERER, bl);
    }

    public static boolean getUseReaderForMultilineRenderer() {
        return Settings.getInstance().getBoolProperty(PROP_MULTILINE_RENDERER_USE_READER, false);
    }

    public static int getMultiLineThreshold() {
        return Settings.getInstance().getIntProperty("workbench.gui.display.multilinethreshold", 250);
    }

    public static void setMultiLineThreshold(int n) {
        Settings.getInstance().setProperty("workbench.gui.display.multilinethreshold", n);
    }

    public static int getDefaultFormFieldWidth() {
        return Settings.getInstance().getIntProperty("workbench.gui.form.fieldwidth", 30);
    }

    public static void setDefaultFormFieldWidth(int n) {
        Settings.getInstance().setProperty("workbench.gui.form.fieldwidth", n);
    }

    public static int getDefaultFormFieldLines() {
        return Settings.getInstance().getIntProperty("workbench.gui.form.fieldlines", 5);
    }

    public static void setDefaultFormFieldLines(int n) {
        Settings.getInstance().setProperty("workbench.gui.form.fieldlines", n);
    }

    public static boolean getConfirmTabClose() {
        return Settings.getInstance().getBoolProperty("workbench.gui.closetab.confirm", false);
    }

    public static void setConfirmTabClose(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.closetab.confirm", bl);
    }

    public static boolean getConfirmMultipleTabClose() {
        return Settings.getInstance().getBoolProperty("workbench.gui.closetab.multiple.confirm", true);
    }

    public static void setConfirmMultipleTabClose(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.closetab.multiple.confirm", bl);
    }

    public static boolean getShowTabIndex() {
        return Settings.getInstance().getBoolProperty("workbench.gui.tabs.showindex", true);
    }

    public static void setShowTabIndex(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.tabs.showindex", bl);
    }

    public static boolean getIncludeHeaderInOptimalWidth() {
        return Settings.getInstance().getBoolProperty("workbench.gui.optimalwidth.includeheader", true);
    }

    public static void setIncludeHeaderInOptimalWidth(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.optimalwidth.includeheader", bl);
    }

    public static boolean getAutomaticOptimalRowHeight() {
        return Settings.getInstance().getBoolProperty("workbench.gui.optimalrowheight.automatic", false);
    }

    public static void setAutomaticOptimalRowHeight(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.optimalrowheight.automatic", bl);
    }

    public static boolean getAutomaticOptimalWidth() {
        return Settings.getInstance().getBoolProperty("workbench.gui.optimalwidth.automatic", true);
    }

    public static void setAutomaticOptimalWidth(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.optimalwidth.automatic", bl);
    }

    public static void setUseDynamicLayout(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.dynamiclayout", bl);
    }

    public static boolean getRestoreExpandedProfiles() {
        return Settings.getInstance().getBoolProperty("workbench.gui.profiles.restored.expanded", true);
    }

    public static void setRestoreExpandedProfiles(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.profiles.restored.expanded", bl);
    }

    public static int getProfileDividerLocation() {
        return Settings.getInstance().getIntProperty("workbench.gui.profiles.divider", -1);
    }

    public static void setProfileDividerLocation(int n) {
        Settings.getInstance().setProperty("workbench.gui.profiles.divider", Integer.toString(n));
    }

    public static void setMinColumnWidth(int n) {
        Settings.getInstance().setProperty("workbench.gui.optimalwidth.minsize", n);
    }

    public static int getMinColumnWidth() {
        return Settings.getInstance().getIntProperty("workbench.gui.optimalwidth.minsize", 50);
    }

    public static int getMaxColumnWidth() {
        return Settings.getInstance().getIntProperty("workbench.gui.optimalwidth.maxsize", 850);
    }

    public static void setMaxColumnWidth(int n) {
        Settings.getInstance().setProperty("workbench.gui.optimalwidth.maxsize", n);
    }

    public static int getAutRowHeightMaxLines() {
        return Settings.getInstance().getIntProperty("workbench.gui.optimalrowheight.maxlines", 10);
    }

    public static void setAutRowHeightMaxLines(int n) {
        Settings.getInstance().setProperty("workbench.gui.optimalrowheight.maxlines", n);
    }

    public static boolean getIgnoreWhitespaceForAutoRowHeight() {
        return Settings.getInstance().getBoolProperty("workbench.gui.optimalrowheight.ignore.emptylines", false);
    }

    public static void setIgnoreWhitespaceForAutoRowHeight(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.optimalrowheight.ignore.emptylines", bl);
    }

    public static void setLookAndFeelClass(String string) {
        Settings.getInstance().setProperty("workbench.gui.lookandfeelclass", string);
    }

    public static String getLookAndFeelClass() {
        return Settings.getInstance().getProperty("workbench.gui.lookandfeelclass", "");
    }

    public static Boolean getUseBrushedMetal() {
        return Settings.getInstance().getBoolProperty("workbench.gui.macos.brushedmetal", false);
    }

    public static void setUseBrushedMetal(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.macos.brushedmetal", bl);
    }

    public static void setShowFilenameInWindowTitle(int n) {
        switch (n) {
            case 0: {
                Settings.getInstance().setProperty(PROP_TITLE_SHOW_EDITOR_FILE, "none");
                break;
            }
            case 1: {
                Settings.getInstance().setProperty(PROP_TITLE_SHOW_EDITOR_FILE, "name");
                break;
            }
            case 2: {
                Settings.getInstance().setProperty(PROP_TITLE_SHOW_EDITOR_FILE, "path");
            }
        }
    }

    public static int getShowFilenameInWindowTitle() {
        String string = Settings.getInstance().getProperty(PROP_TITLE_SHOW_EDITOR_FILE, "none");
        if ("name".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("path".equalsIgnoreCase(string)) {
            return 2;
        }
        return 0;
    }

    public static String getTitleGroupSeparator() {
        String string = Settings.getInstance().getProperty(PROP_TITLE_GROUP_SEP, "/");
        if ("XXX".equals(string)) {
            return "";
        }
        return string;
    }

    public static void setTitleGroupSeparator(String string) {
        if (StringUtil.isBlank(string)) {
            string = "XXX";
        }
        Settings.getInstance().setProperty(PROP_TITLE_GROUP_SEP, string);
    }

    public static String getTitleGroupBracket() {
        return Settings.getInstance().getProperty(PROP_TITLE_GROUP_BRACKET, null);
    }

    public static void setTitleGroupBracket(String string) {
        Settings.getInstance().setProperty(PROP_TITLE_GROUP_BRACKET, string);
    }

    public static void setShowWorkspaceInWindowTitle(boolean bl) {
        Settings.getInstance().setProperty(PROP_TITLE_SHOW_WKSP, bl);
    }

    public static boolean getCleanupURLParametersInWindowTitle() {
        return Settings.getInstance().getBoolProperty(PROP_TITLE_SHOW_URL_CLEANUP, true);
    }

    public static void setCleanupURLParametersInWindowTitle(boolean bl) {
        Settings.getInstance().setProperty(PROP_TITLE_SHOW_URL_CLEANUP, bl);
    }

    public static boolean getRemoveJDBCProductInWindowTitle() {
        return Settings.getInstance().getBoolProperty(PROP_TITLE_REMOVE_URL_PRODUCT, true);
    }

    public static void setRemoveJDBCProductInWindowTitle(boolean bl) {
        Settings.getInstance().setProperty(PROP_TITLE_REMOVE_URL_PRODUCT, bl);
    }

    public static boolean getShowWorkspaceInWindowTitle() {
        return Settings.getInstance().getBoolProperty(PROP_TITLE_SHOW_WKSP, true);
    }

    public static void setShowURLinWindowTitle(boolean bl) {
        Settings.getInstance().setProperty(PROP_TITLE_SHOW_URL, bl);
    }

    public static boolean getShowURLinWindowTitle() {
        return Settings.getInstance().getBoolProperty(PROP_TITLE_SHOW_URL, false);
    }

    public static void setIncludeUserInTitleURL(boolean bl) {
        Settings.getInstance().setProperty(PROP_TITLE_SHOW_URL_USER, bl);
    }

    public static boolean getIncludeUserInTitleURL() {
        return Settings.getInstance().getBoolProperty(PROP_TITLE_SHOW_URL_USER, false);
    }

    public static void setShowProfileGroupInWindowTitle(boolean bl) {
        Settings.getInstance().setProperty(PROP_TITLE_SHOW_PROF_GROUP, bl);
    }

    public static boolean getShowProfileGroupInWindowTitle() {
        return Settings.getInstance().getBoolProperty(PROP_TITLE_SHOW_PROF_GROUP, false);
    }

    public static void setShowProductNameAtEnd(boolean bl) {
        Settings.getInstance().setProperty(PROP_TITLE_APP_AT_END, bl);
    }

    public static boolean getShowProductNameAtEnd() {
        return Settings.getInstance().getBoolProperty(PROP_TITLE_APP_AT_END, false);
    }

    public static boolean getShowToolbar() {
        return Settings.getInstance().getBoolProperty("workbench.gui.mainwindow.showtoolbar", true);
    }

    public static void setShowToolbar(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.mainwindow.showtoolbar", bl);
    }

    public static boolean getAllowRowHeightResizing() {
        return Settings.getInstance().getBoolProperty("workbench.gui.display.rowheightresize", false);
    }

    public static void setAllowRowHeightResizing(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.display.rowheightresize", bl);
    }

    public static boolean getUseAlternateRowColor() {
        return Settings.getInstance().getBoolProperty("workbench.gui.table.alternate.use", false);
    }

    public static void setUseAlternateRowColor(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.table.alternate.use", bl);
    }

    public static boolean getAlwaysEnableSaveButton() {
        return Settings.getInstance().getBoolProperty("workbench.gui.savebutton.always.enabled", false);
    }

    public static void setDisplayNullFontStyle(int n) {
        if (n >= 0 && n <= 3) {
            Settings.getInstance().setProperty("workbench.gui.renderer.null.fontstyle", Integer.toString(n));
        }
    }

    public static int getDisplayNullFontStyle() {
        return GuiSettings.getFontStyle("workbench.gui.renderer.null.fontstyle", 0);
    }

    public static int getFontStyle(String string, int n) {
        String string2 = Settings.getInstance().getProperty(string, null);
        if (string2 == null) {
            return n;
        }
        if ("italic".equalsIgnoreCase(string2)) {
            return 2;
        }
        if ("bold".equalsIgnoreCase(string2)) {
            return 1;
        }
        if ("bolditalic".equalsIgnoreCase(string2)) {
            return 3;
        }
        int n2 = StringUtil.getIntValue(string2, 0);
        if (n2 < 0 || n2 > 3) {
            return 0;
        }
        return n2;
    }

    public static String getDisplayNullString() {
        return Settings.getInstance().getProperty("workbench.gui.renderer.nullstring", null);
    }

    public static void setDisplayNullString(String string) {
        if (StringUtil.isBlank(string)) {
            Settings.getInstance().setProperty("workbench.gui.renderer.nullstring", null);
        } else {
            Settings.getInstance().setProperty("workbench.gui.renderer.nullstring", string.trim());
        }
    }

    public static void setNullColor(Color color) {
        Settings.getInstance().setColor("workbench.gui.table.null.color", color);
    }

    public static Color getNullColor() {
        return Settings.getInstance().getColor("workbench.gui.table.null.color", null);
    }

    public static void setColumnModifiedColor(Color color) {
        Settings.getInstance().setColor("workbench.gui.table.modified.color", color);
    }

    public static Color getColumnModifiedColor() {
        return Settings.getInstance().getColor("workbench.gui.table.modified.color", null);
    }

    public static Color getExpressionHighlightColor() {
        return Settings.getInstance().getColor("workbench.gui.table.searchhighlite.color", Color.YELLOW);
    }

    public static void setExpressionHighlightColor(Color color) {
        Settings.getInstance().setColor("workbench.gui.table.searchhighlite.color", color);
    }

    public static Color getAlternateRowColor() {
        Color color = GuiSettings.getUseAlternateRowColor() ? new Color(245, 245, 245) : null;
        return Settings.getInstance().getColor("workbench.gui.table.alternate.color", color);
    }

    public static void setAlternateRowColor(Color color) {
        Settings.getInstance().setColor("workbench.gui.table.alternate.color", color);
    }

    public static void setRequiredFieldColor(Color color) {
        Settings.getInstance().setColor("workbench.gui.edit.requiredfield.color", color);
    }

    public static Color getRequiredFieldColor() {
        return Settings.getInstance().getColor("workbench.gui.edit.requiredfield.color", new Color(255, 100, 100));
    }

    public static void setHighlightRequiredFields(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.edit.requiredfield.dohighlight", bl);
    }

    public static boolean getHighlightRequiredFields() {
        return Settings.getInstance().getBoolProperty("workbench.gui.edit.requiredfield.dohighlight", true);
    }

    public static void setConfirmDiscardResultSetChanges(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.edit.warn.discard.changes", bl);
    }

    public static boolean getConfirmDiscardResultSetChanges() {
        return Settings.getInstance().getBoolProperty("workbench.gui.edit.warn.discard.changes", false);
    }

    public static boolean getShowTextSelectionSummary() {
        return Settings.getInstance().getBoolProperty(PROP_SHOW_TEXT_SELECTION_INFO, true);
    }

    public static void setShowTextSelectionSummary(boolean bl) {
        Settings.getInstance().setProperty(PROP_SHOW_TEXT_SELECTION_INFO, bl);
    }

    public static boolean getShowSelectionSummary() {
        return Settings.getInstance().getBoolProperty("workbench.gui.data.selection.summary", true);
    }

    public static void setShowSelectionSummary(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.data.selection.summary", bl);
    }

    public static boolean getForceRedraw() {
        return Settings.getInstance().getBoolProperty("workbench.gui.forcedraw", MacOSHelper.isMacOS());
    }

    public static boolean getShowMnemonics() {
        return Settings.getInstance().getBoolProperty("workbench.gui.showmnemonics", true);
    }

    public static boolean getTransformSequenceDisplay() {
        return Settings.getInstance().getBoolProperty("workbench.dbexplorer.sequence.transpose", true);
    }

    public static boolean limitMenuLength() {
        return Settings.getInstance().getBoolProperty("workbench.gui.limit.menu", true);
    }

    public static int maxMenuItems() {
        return Settings.getInstance().getIntProperty("workbench.gui.menu.items.max", 9999);
    }

    public static int getWheelScrollLines() {
        return Settings.getInstance().getIntProperty("workbench.gui.editor.wheelscroll.units", -1);
    }

    public static void setWheelScrollLines(int n) {
        Settings.getInstance().setProperty("workbench.gui.editor.wheelscroll.units", n);
    }

    public static int getNumberDataAlignment() {
        String string = Settings.getInstance().getProperty(PROP_NUMBER_ALIGN, "right");
        if ("left".equalsIgnoreCase(string)) {
            return 2;
        }
        return 4;
    }

    public static void setNumberDataAlignment(String string) {
        if (StringUtil.isNonBlank(string) && ("left".equalsIgnoreCase(string) || "right".equalsIgnoreCase(string))) {
            Settings.getInstance().setProperty(PROP_NUMBER_ALIGN, string.toLowerCase());
        }
    }

    public static boolean getShowMaxRowsTooltip() {
        return Settings.getInstance().getBoolProperty("workbench.gui.maxrows.tooltipwarning", true);
    }

    public static void setShowMaxRowsTooltip(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.maxrows.tooltipwarning", bl);
    }

    public static boolean showSelectFkValueAtTop() {
        return Settings.getInstance().getBoolProperty("workbench.gui.sql.show.selectfk.top", false);
    }

    public static boolean showTableHeaderInBold() {
        return Settings.getInstance().getBoolProperty(PROP_TABLE_HEADER_BOLD, false);
    }

    public static void setShowTableHeaderInBold(boolean bl) {
        Settings.getInstance().setProperty(PROP_TABLE_HEADER_BOLD, bl);
    }

    public static boolean showDatatypeInTableHeader() {
        return Settings.getInstance().getBoolProperty(PROP_TABLE_HEADER_DATATYPE, false);
    }

    public static void setShowDatatypeInTableHeader(boolean bl) {
        Settings.getInstance().setProperty(PROP_TABLE_HEADER_DATATYPE, bl);
    }

    public static boolean showRemarksInTableHeader() {
        return Settings.getInstance().getBoolProperty(PROP_TABLE_HEADER_REMARKS, false);
    }

    public static void setShowRemarksInTableHeader(boolean bl) {
        Settings.getInstance().setProperty(PROP_TABLE_HEADER_REMARKS, bl);
    }

    public static void setReloadType(FileReloadType fileReloadType) {
        Settings.getInstance().setProperty(PROP_FILE_RELOAD_TYPE, fileReloadType.name());
    }

    public static FileReloadType getReloadType() {
        String string = Settings.getInstance().getProperty(PROP_FILE_RELOAD_TYPE, "none");
        try {
            return FileReloadType.valueOf(string);
        }
        catch (Exception exception) {
            return FileReloadType.none;
        }
    }

    public static void setLocalStorageMaxAge(String string) {
        Settings.getInstance().setProperty(PROP_LOCAL_OBJECT_CACHE_MAXAGE, string);
    }

    public static String getLocalStorageMaxAge() {
        return Settings.getInstance().getProperty(PROP_LOCAL_OBJECT_CACHE_MAXAGE, "5d");
    }

    public static void setLocalStorageForObjectCache(ObjectCacheStorage objectCacheStorage) {
        Settings.getInstance().setProperty(PROP_LOCAL_OBJECT_CACHE, objectCacheStorage.name());
    }

    public static ObjectCacheStorage getLocalStorageForObjectCache() {
        String string = Settings.getInstance().getProperty(PROP_LOCAL_OBJECT_CACHE, ObjectCacheStorage.profile.name());
        try {
            return ObjectCacheStorage.valueOf(string);
        }
        catch (Exception exception) {
            return ObjectCacheStorage.never;
        }
    }

    public static boolean showTableNameInColumnHeader() {
        return Settings.getInstance().getBoolProperty("workbench.gui.data.column.header.includetable", false);
    }

    public static void setShowTableNameInColumnHeader(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.data.column.header.includetable", bl);
    }

    public static boolean showTableNameAsColumnPrefix() {
        return Settings.getInstance().getBoolProperty("workbench.gui.data.column.header.tablename.columnprefix", false);
    }

    public static boolean showTableNameInColumnTooltip() {
        return Settings.getInstance().getBoolProperty("workbench.gui.data.column.header.tablename.tooltip", true);
    }

    public static void setshowTableNameAsColumnPrefix(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.data.column.header.tablename.columnprefix", bl);
    }

    public static boolean getUseTablenameAsResultName() {
        return Settings.getInstance().getBoolProperty("workbench.gui.data.resultname.firsttable", false);
    }

    public static void setUseTablenameAsResultName(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.data.resultname.firsttable", bl);
    }

    public static boolean getDefaultAppendResults() {
        return Settings.getInstance().getBoolProperty("workbench.gui.data.append.results", false);
    }

    public static void setDefaultAppendResults(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.data.append.results", bl);
    }

    public static boolean alwaysDisplayCopyAsTextDialog() {
        return Settings.getInstance().getBoolProperty(PROP_COPY_TEXT_DISPLAY_DLG, true);
    }

    public static void setAlwaysDisplayCopyAsTextDialog(boolean bl) {
        Settings.getInstance().setProperty(PROP_COPY_TEXT_DISPLAY_DLG, bl);
    }

    public static boolean jumpToError() {
        return Settings.getInstance().getBoolProperty("workbench.gui.editor.errorjump", true);
    }

    public static void setJumpToError(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.editor.errorjump", bl);
    }

    public static int getMinTagLength() {
        return Settings.getInstance().getIntProperty("workbench.gui.profiles.tagfilter.minlength", 2);
    }

    public static boolean focusToProfileQuickFilter() {
        return Settings.getInstance().getBoolProperty("workbench.gui.profiles.quickfilter.initialfocus", true);
    }

    public static void setFocusToProfileQuickFilter(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.profiles.quickfilter.initialfocus", bl);
    }

    public static boolean restoreProfileSelectionBeforeFilter() {
        return Settings.getInstance().getBoolProperty("workbench.gui.profiles.filter.reset.restore.oldprofile", true);
    }

    public static void setRestoreProfileSelectionBeforeFilter(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.profiles.filter.reset.restore.oldprofile", bl);
    }

    public static boolean enableProfileQuickFilter() {
        return Settings.getInstance().getBoolProperty("workbench.gui.profiles.quickfilter", true);
    }

    public static void setEnableProfileQuickFilter(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.profiles.quickfilter", bl);
    }

    public static boolean getZoomFontWithMouseWheel() {
        return Settings.getInstance().getBoolProperty(PROP_FONT_ZOOM_WHEEL, true);
    }

    public static void setZoomFontWithMouseWheel(boolean bl) {
        Settings.getInstance().setProperty(PROP_FONT_ZOOM_WHEEL, bl);
    }

    public static int getDpiThreshold() {
        return Settings.getInstance().getIntProperty("workbench.gui.dpi.threshold", 144);
    }

    public static boolean showScriptFinishTime() {
        return Settings.getInstance().getBoolProperty("workbench.gui.sql.script.showtime", false);
    }

    public static void setShowScriptFinishTime(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.sql.script.showtime", bl);
    }

    public static boolean showScriptStmtFinishTime() {
        return Settings.getInstance().getBoolProperty("workbench.gui.sql.script.statement.showtime", GuiSettings.showScriptFinishTime());
    }

    public static void setShowScriptStmtFinishTime(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.sql.script.statement.showtime", bl);
    }

    public static boolean getUseStatementInCurrentLine() {
        return Settings.getInstance().getBoolProperty(PROP_USE_CURRENT_LINE_FOR_CURRENT_STMT, false);
    }

    public static void setUseStatementInCurrentLine(boolean bl) {
        Settings.getInstance().setProperty(PROP_USE_CURRENT_LINE_FOR_CURRENT_STMT, bl);
    }

    public static boolean getUseLastIfNoCurrentStmt() {
        return Settings.getInstance().getBoolProperty("workbench.gui.sql.uselast.alternative", GuiSettings.getUseStatementInCurrentLine());
    }

    public static void setUseLastIfNoCurrentStmt(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.sql.uselast.alternative", bl);
    }

    public static boolean getVariablesDDEditable() {
        return Settings.getInstance().getBoolProperty("workbench.sql.parameter.prompt.dd.editable", false);
    }

    public static boolean cancellingVariablePromptStopsExecution() {
        return Settings.getInstance().getBoolProperty("workbench.sql.parameter.prompt.cancel.stops", true);
    }

    public static boolean enableErrorPromptForWbInclude() {
        return Settings.getInstance().getBoolProperty("workbench.gui.sql.error.include.prompt", true);
    }

    public static boolean retryForSingleStatement() {
        return Settings.getInstance().getBoolProperty("workbench.gui.sql.error.retry.single", false);
    }

    public static void setErrorPromptType(ErrorPromptType errorPromptType) {
        Settings.getInstance().setProperty("workbench.gui.sql.error.prompt", errorPromptType.name());
    }

    public static ErrorPromptType getErrorPromptType() {
        String string = Settings.getInstance().getProperty("workbench.gui.sql.error.prompt", ErrorPromptType.PromptWithErroressage.name());
        try {
            return ErrorPromptType.valueOf(string);
        }
        catch (Throwable throwable) {
            return ErrorPromptType.PromptWithErroressage;
        }
    }

    public static boolean allowWordWrapForErrorMessage() {
        return Settings.getInstance().getBoolProperty("workbench.gui.sql.error.prompt.wordwrap", false);
    }

    public static void setShowMessageInErrorContinueDialog(boolean bl) {
        Settings.getInstance().setProperty("workbench.sql.error.prompt.show.error", bl);
    }

    public static void setDataTooltipType(DataTooltipType dataTooltipType) {
        Settings.getInstance().setProperty("workbench.gui.data.sql.tooltip", dataTooltipType.name());
    }

    public static DataTooltipType getDataTooltipType() {
        String string = Settings.getInstance().getProperty("workbench.gui.data.sql.tooltip", DataTooltipType.full.name());
        try {
            return DataTooltipType.valueOf(string);
        }
        catch (Throwable throwable) {
            if ("true".equalsIgnoreCase(string)) {
                return DataTooltipType.full;
            }
            if ("false".equalsIgnoreCase(string)) {
                return DataTooltipType.none;
            }
            return DataTooltipType.full;
        }
    }

    public static boolean getTagCompletionUseContainsFilter() {
        return Settings.getInstance().getBoolProperty("workbench.gui.tags.dropdown.containsfilter", true);
    }

    public static boolean getSaveSearchAllColWidths() {
        return Settings.getInstance().getBoolProperty(PROP_GLOBAL_SEARCH_SAVE_COLWIDTHS, true);
    }

    public static ResultReceiver.ShowType getDefaultShowType() {
        String string = Settings.getInstance().getProperty("workbench.gui.refnavigator.showtype", ResultReceiver.ShowType.showNone.name());
        try {
            return ResultReceiver.ShowType.valueOf(string);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Invalid type \"" + string + "\" specified!", throwable);
            return ResultReceiver.ShowType.appendText;
        }
    }

    public static ResultReceiver.ShowType getDefaultShowTypeNewTab() {
        String string = Settings.getInstance().getProperty("workbench.gui.refnavigator.showtype.newtab", ResultReceiver.ShowType.replaceText.name());
        try {
            return ResultReceiver.ShowType.valueOf(string);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Invalid type \"" + string + "\" specified!", throwable);
            return ResultReceiver.ShowType.appendText;
        }
    }

    public static boolean installFocusManager() {
        return Settings.getInstance().getBoolProperty("workbench.gui.install.focusmgr", true);
    }

    public static int getTabHistorySize() {
        return Settings.getInstance().getIntProperty("workbench.gui.recenttabs.size", 25);
    }

    public static boolean showMenuIcons() {
        return Settings.getInstance().getBoolProperty("workbench.gui.menu.showicons", true);
    }

    public static void setShowMenuIcons(boolean bl) {
        Settings.getInstance().setProperty("workbench.gui.menu.showicons", bl);
    }

    public static boolean cleanupClipboardContent() {
        return Settings.getInstance().getBoolProperty("workbench.gui.editor.cleanup.clipboard", true);
    }

    public static boolean autoDetectFileEncoding() {
        return Settings.getInstance().getBoolProperty("workbench.editor.file.open.detect.encoding", false);
    }

    public static void setAutoDetectFileEncoding(boolean bl) {
        Settings.getInstance().setProperty("workbench.editor.file.open.detect.encoding", bl);
    }

    public static boolean copyToClipboardFormattedTextWithResultName() {
        return Settings.getInstance().getBoolProperty("workbench.copy.clipboard.formatted.text.include.name", false);
    }

    public static boolean useHTMLRedirectForAnchor() {
        return Settings.getInstance().getBoolProperty("workbench.gui.help.use.redirect.for.anchor", true);
    }

    public static boolean getIncludeJDBCUrlInProfileSearch() {
        return Settings.getInstance().getBoolProperty("workbench.gui.profile.filter.include.url", false);
    }

    public static boolean getIncludeUsernameInProfileSearch() {
        return Settings.getInstance().getBoolProperty("workbench.gui.profile.filter.include.username", false);
    }

    public static boolean showStatusbarReadyMessage() {
        return Settings.getInstance().getBoolProperty("workbench.gui.statusbar.show.ready", false);
    }

    public static Color getEditorTabHighlightColor() {
        return Settings.getInstance().getColor("workbench.editor.tab.highlight.color");
    }

    public static int getEditorTabHighlightWidth() {
        return Settings.getInstance().getIntProperty("workbench.editor.tab.highlight.width", 2);
    }

    public static GuiPosition getEditorTabHighlightLocation() {
        String string = Settings.getInstance().getProperty("workbench.editor.tab.highlight.location", "bottom");
        try {
            return GuiPosition.valueOf(string);
        }
        catch (Throwable throwable) {
            return GuiPosition.bottom;
        }
    }

    public static boolean useTabIndexForConnectionId() {
        return Settings.getInstance().getBoolProperty("workbench.gui.connection.id.use.tabindex", true);
    }

    public static boolean showCloseButtonForDetachedResults() {
        return Settings.getInstance().getBoolProperty("workbench.gui.detached.result.show.closebutton", false);
    }

    public static boolean checkExtDir() {
        return Settings.getInstance().getBoolProperty("workbench.gui.extdir.check.libs", true);
    }

    public static int getFontZoomPercentage() {
        return Settings.getInstance().getIntProperty("workbench.gui.font.zoom.percent", 10);
    }

    public static boolean enableMultiColumnDelete() {
        return Settings.getInstance().getBoolProperty("workbench.gui.table.delete.multi.column", true);
    }

    public static int getCaretWidth() {
        return Settings.getInstance().getIntProperty("workbench.gui.editor.caret.width", 1);
    }

    public static boolean useContrastColor() {
        return Settings.getInstance().getBoolProperty("workbench.gui.infocolor.use.contrast", true);
    }

    public static int getConstrastColorFormula() {
        return Settings.getInstance().getIntProperty("workbench.gui.infocolor.contrast.type", 1);
    }

    public static boolean useBoldFontForConnectionInfo() {
        return Settings.getInstance().getBoolProperty("workbench.gui.infocolor.use.bold", false);
    }
}

