/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import workbench.db.DBID;
import workbench.db.DbMetadata;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.CommandRegistry;
import workbench.sql.SqlCommand;
import workbench.sql.commands.AlterSessionCommand;
import workbench.sql.commands.DdlCommand;
import workbench.sql.commands.IgnoredCommand;
import workbench.sql.commands.SelectCommand;
import workbench.sql.commands.SetCommand;
import workbench.sql.commands.TransactionEndCommand;
import workbench.sql.commands.TransactionStartCommand;
import workbench.sql.commands.UpdatingCommand;
import workbench.sql.commands.UseCommand;
import workbench.sql.wbcommands.MySQLShow;
import workbench.sql.wbcommands.PgCopyCommand;
import workbench.sql.wbcommands.WbCall;
import workbench.sql.wbcommands.WbConfirm;
import workbench.sql.wbcommands.WbConnInfo;
import workbench.sql.wbcommands.WbConnect;
import workbench.sql.wbcommands.WbCopy;
import workbench.sql.wbcommands.WbDataDiff;
import workbench.sql.wbcommands.WbDefinePk;
import workbench.sql.wbcommands.WbDefineVar;
import workbench.sql.wbcommands.WbDescribeObject;
import workbench.sql.wbcommands.WbDisableOraOutput;
import workbench.sql.wbcommands.WbEcho;
import workbench.sql.wbcommands.WbEnableOraOutput;
import workbench.sql.wbcommands.WbEndBatch;
import workbench.sql.wbcommands.WbExport;
import workbench.sql.wbcommands.WbFeedback;
import workbench.sql.wbcommands.WbFetchSize;
import workbench.sql.wbcommands.WbGenDelete;
import workbench.sql.wbcommands.WbGenDrop;
import workbench.sql.wbcommands.WbGenImpTable;
import workbench.sql.wbcommands.WbGenInsert;
import workbench.sql.wbcommands.WbGenerateFKScript;
import workbench.sql.wbcommands.WbGenerateScript;
import workbench.sql.wbcommands.WbGrepData;
import workbench.sql.wbcommands.WbGrepSource;
import workbench.sql.wbcommands.WbHelp;
import workbench.sql.wbcommands.WbHideWarnings;
import workbench.sql.wbcommands.WbHistory;
import workbench.sql.wbcommands.WbImport;
import workbench.sql.wbcommands.WbInclude;
import workbench.sql.wbcommands.WbIsolationLevel;
import workbench.sql.wbcommands.WbList;
import workbench.sql.wbcommands.WbListCatalogs;
import workbench.sql.wbcommands.WbListDependencies;
import workbench.sql.wbcommands.WbListIndexes;
import workbench.sql.wbcommands.WbListPkDef;
import workbench.sql.wbcommands.WbListProcedures;
import workbench.sql.wbcommands.WbListSchemas;
import workbench.sql.wbcommands.WbListTriggers;
import workbench.sql.wbcommands.WbListVars;
import workbench.sql.wbcommands.WbLoadPkMapping;
import workbench.sql.wbcommands.WbMessage;
import workbench.sql.wbcommands.WbMode;
import workbench.sql.wbcommands.WbObjectGrants;
import workbench.sql.wbcommands.WbOraShow;
import workbench.sql.wbcommands.WbProcSource;
import workbench.sql.wbcommands.WbRemoveVar;
import workbench.sql.wbcommands.WbRestoreConnection;
import workbench.sql.wbcommands.WbRowCount;
import workbench.sql.wbcommands.WbRunLB;
import workbench.sql.wbcommands.WbRunResult;
import workbench.sql.wbcommands.WbSavePkMapping;
import workbench.sql.wbcommands.WbSchemaDiff;
import workbench.sql.wbcommands.WbSchemaReport;
import workbench.sql.wbcommands.WbSelectBlob;
import workbench.sql.wbcommands.WbSetProp;
import workbench.sql.wbcommands.WbSetSchema;
import workbench.sql.wbcommands.WbShowEncoding;
import workbench.sql.wbcommands.WbShowProps;
import workbench.sql.wbcommands.WbStartBatch;
import workbench.sql.wbcommands.WbSwitchDB;
import workbench.sql.wbcommands.WbSysExec;
import workbench.sql.wbcommands.WbSysOpen;
import workbench.sql.wbcommands.WbTableSource;
import workbench.sql.wbcommands.WbTriggerSource;
import workbench.sql.wbcommands.WbViewSource;
import workbench.sql.wbcommands.WbXslt;
import workbench.sql.wbcommands.console.WbAbout;
import workbench.sql.wbcommands.console.WbCreateProfile;
import workbench.sql.wbcommands.console.WbDefineDriver;
import workbench.sql.wbcommands.console.WbDefineMacro;
import workbench.sql.wbcommands.console.WbDeleteMacro;
import workbench.sql.wbcommands.console.WbDeleteProfile;
import workbench.sql.wbcommands.console.WbDisconnect;
import workbench.sql.wbcommands.console.WbDisplay;
import workbench.sql.wbcommands.console.WbListDrivers;
import workbench.sql.wbcommands.console.WbListMacros;
import workbench.sql.wbcommands.console.WbListProfiles;
import workbench.sql.wbcommands.console.WbRemoveMasterPwd;
import workbench.sql.wbcommands.console.WbRun;
import workbench.sql.wbcommands.console.WbSaveProfiles;
import workbench.sql.wbcommands.console.WbSetDisplaySize;
import workbench.sql.wbcommands.console.WbSetMasterPwd;
import workbench.sql.wbcommands.console.WbStoreProfile;
import workbench.sql.wbcommands.console.WbToggleDisplay;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.SqlParsingUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class CommandMapper {
    private final Map<String, SqlCommand> cmdDispatch;
    private final List<String> dbSpecificCommands;
    private final Set<String> passThrough = CollectionUtil.caseInsensitiveSet();
    private boolean supportsSelectInto;
    private DbMetadata metaData;
    private final boolean allowAbbreviated;

    public CommandMapper() {
        this(Settings.getInstance().getBoolProperty("workbench.sql.allow.abbreviation", false));
    }

    public CommandMapper(boolean bl) {
        this.cmdDispatch = new TreeMap<String, SqlCommand>(CaseInsensitiveComparator.INSTANCE);
        this.cmdDispatch.put("*", new SqlCommand());
        this.addCommand(new WbList());
        this.addCommand(new WbListProcedures());
        this.addCommand(new WbDefineVar());
        this.addCommand(new WbEnableOraOutput());
        this.addCommand(new WbDisableOraOutput());
        this.addCommand(new WbStartBatch());
        this.addCommand(new WbEndBatch());
        this.addCommand(new WbXslt());
        this.addCommand(new WbRemoveVar());
        this.addCommand(new WbListVars());
        this.addCommand(new WbExport());
        this.addCommand(new WbImport());
        this.addCommand(new WbCopy());
        this.addCommand(new WbSchemaReport());
        this.addCommand(new WbSchemaDiff());
        this.addCommand(new WbDataDiff());
        this.addCommand(new WbFeedback());
        this.addCommand(new WbDefinePk());
        this.addCommand(new WbListPkDef());
        this.addCommand(new WbLoadPkMapping());
        this.addCommand(new WbSavePkMapping());
        this.addCommand(new WbConfirm());
        this.addCommand(new WbMessage());
        this.addCommand(new WbCall());
        this.addCommand(new WbConnect());
        this.addCommand(new WbRestoreConnection());
        this.addCommand(new WbInclude());
        this.addCommand(new WbListCatalogs());
        this.addCommand(new WbListSchemas());
        this.addCommand(new WbHelp());
        this.addCommand(new WbSelectBlob());
        this.addCommand(new WbHideWarnings());
        this.addCommand(new WbProcSource());
        this.addCommand(new WbListTriggers());
        this.addCommand(new WbListIndexes());
        this.addCommand(new WbTriggerSource());
        this.addCommand(new WbViewSource());
        this.addCommand(new WbTableSource());
        this.addCommand(new WbDescribeObject());
        this.addCommand(new WbGrepSource());
        this.addCommand(new WbGrepData());
        this.addCommand(new WbMode());
        this.addCommand(new WbFetchSize());
        this.addCommand(new WbAbout());
        this.addCommand(new WbRunLB());
        this.addCommand(new WbIsolationLevel());
        this.addCommand(new WbConnInfo());
        this.addCommand(new WbSysExec());
        this.addCommand(new WbSysOpen());
        this.addCommand(new WbShowProps());
        WbSetProp wbSetProp = new WbSetProp();
        this.addCommand(wbSetProp);
        this.cmdDispatch.put("WbSetDbConfig", wbSetProp);
        this.addCommand(new WbGenDrop());
        this.addCommand(new WbGenerateScript());
        this.addCommand(new WbGenerateFKScript());
        this.addCommand(new WbGenDelete());
        this.addCommand(new WbGenInsert());
        this.addCommand(new WbRunResult());
        this.addCommand(new WbGenImpTable());
        this.addCommand(new WbObjectGrants());
        this.addCommand(new WbEcho());
        this.addCommand(new WbShowEncoding());
        this.addCommand(new WbRowCount());
        this.addCommand(new WbDisconnect());
        this.addCommand(new WbDisplay());
        this.addCommand(new WbToggleDisplay());
        this.addCommand(new WbSetDisplaySize());
        this.addCommand(new WbRun());
        this.addCommand(new WbHistory());
        this.addCommand(new WbListMacros());
        this.addCommand(new WbDefineMacro());
        this.addCommand(new WbDeleteMacro());
        this.addCommand(new WbStoreProfile());
        this.addCommand(new WbSaveProfiles());
        this.addCommand(new WbDeleteProfile());
        this.addCommand(new WbCreateProfile());
        this.addCommand(new WbDefineDriver());
        this.addCommand(new WbListProfiles());
        this.addCommand(new WbListDrivers());
        this.addCommand(new WbListDependencies());
        this.addCommand(TransactionEndCommand.getCommit());
        this.addCommand(TransactionEndCommand.getRollback());
        this.addCommand(UpdatingCommand.getDeleteCommand());
        this.addCommand(UpdatingCommand.getInsertCommand());
        this.addCommand(UpdatingCommand.getUpdateCommand());
        this.addCommand(UpdatingCommand.getTruncateCommand());
        this.addCommand(UpdatingCommand.getMergeCommand());
        this.addCommand(new WbSwitchDB());
        this.addCommand(new SetCommand());
        this.addCommand(new SelectCommand());
        this.addCommand(new WbSetSchema());
        this.addCommand(new WbSetMasterPwd());
        this.addCommand(new WbRemoveMasterPwd());
        for (DdlCommand ddlCommand : DdlCommand.getDdlCommands()) {
            this.addCommand(ddlCommand);
        }
        this.cmdDispatch.put("CREATE OR REPLACE", DdlCommand.getCreateCommand());
        this.dbSpecificCommands = new ArrayList<String>();
        this.allowAbbreviated = bl;
        this.registerExtensions();
    }

    private void registerExtensions() {
        List<SqlCommand> list = CommandRegistry.getInstance().getCommands();
        for (SqlCommand sqlCommand : list) {
            this.addCommand(sqlCommand);
        }
    }

    public Collection<String> getAllWbCommands() {
        Collection<SqlCommand> collection = this.cmdDispatch.values();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (SqlCommand sqlCommand : collection) {
            if (!sqlCommand.isWbCommand()) continue;
            treeSet.addAll(sqlCommand.getAllVerbs());
        }
        return treeSet;
    }

    public final void addCommand(SqlCommand sqlCommand) {
        for (String string : sqlCommand.getAllVerbs()) {
            this.cmdDispatch.put(string, sqlCommand);
        }
    }

    private void addDBMSCommand(String string, SqlCommand sqlCommand) {
        this.cmdDispatch.put(string, sqlCommand);
        this.dbSpecificCommands.add(string);
    }

    public void setConnection(WbConnection wbConnection) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.cmdDispatch.keySet().removeAll(this.dbSpecificCommands);
        this.dbSpecificCommands.clear();
        this.supportsSelectInto = false;
        if (wbConnection == null) {
            return;
        }
        this.metaData = wbConnection.getMetadata();
        if (this.metaData == null) {
            LogMgr.logError(new CallerInfo(){}, "Received connection without metaData!", null);
            return;
        }
        if (this.metaData.isOracle()) {
            object5 = this.cmdDispatch.get("WbCall");
            this.addDBMSCommand("EXECUTE", (SqlCommand)object5);
            this.addDBMSCommand("EXEC", (SqlCommand)object5);
            object4 = new AlterSessionCommand();
            this.addDBMSCommand(((AlterSessionCommand)object4).getVerb(), (SqlCommand)object4);
            this.addDBMSCommand("SHOW", new WbOraShow());
            object3 = new WbFeedback("ECHO");
            this.addDBMSCommand(((WbFeedback)object3).getVerb(), (SqlCommand)object3);
            object2 = this.cmdDispatch.get("WbEcho");
            this.addDBMSCommand("prompt", (SqlCommand)object2);
            object = this.cmdDispatch.get("WbConfirm");
            this.addDBMSCommand("pause", (SqlCommand)object);
        }
        if (this.metaData.isSqlServer() || this.metaData.isMySql()) {
            object5 = new UseCommand();
            this.addDBMSCommand(((UseCommand)object5).getVerb(), (SqlCommand)object5);
        }
        if (this.metaData.isFirebird()) {
            object5 = DdlCommand.getRecreateCommand();
            this.addDBMSCommand(((DdlCommand)object5).getVerb(), (SqlCommand)object5);
        }
        if (this.metaData.isPostgres()) {
            object5 = new PgCopyCommand();
            this.cmdDispatch.put(((PgCopyCommand)object5).getVerb(), (SqlCommand)object5);
            this.dbSpecificCommands.add(((PgCopyCommand)object5).getVerb());
        }
        if (this.metaData.isPostgres() || DBID.Greenplum.isDB(this.metaData.getDbId()) || DBID.Redshift.isDB(this.metaData.getDbId())) {
            this.addDBMSCommand(TransactionStartCommand.BEGIN.getVerb(), TransactionStartCommand.BEGIN);
            this.addDBMSCommand(TransactionStartCommand.START_TRANSACTION.getVerb(), TransactionStartCommand.START_TRANSACTION);
            this.addDBMSCommand(TransactionStartCommand.BEGIN_TRANSACTION.getVerb(), TransactionStartCommand.BEGIN_TRANSACTION);
            this.addDBMSCommand(TransactionStartCommand.BEGIN_WORK.getVerb(), TransactionStartCommand.BEGIN_WORK);
        }
        if (this.metaData.isSqlServer()) {
            this.addDBMSCommand(TransactionStartCommand.BEGIN_TRANSACTION.getVerb(), TransactionStartCommand.BEGIN_TRANSACTION);
            this.addDBMSCommand(TransactionStartCommand.BEGIN_TRAN.getVerb(), TransactionStartCommand.BEGIN_TRAN);
        }
        if (this.metaData.isVertica()) {
            this.addDBMSCommand(TransactionStartCommand.BEGIN_TRANSACTION.getVerb(), TransactionStartCommand.BEGIN_TRANSACTION);
            this.addDBMSCommand(TransactionStartCommand.BEGIN_WORK.getVerb(), TransactionStartCommand.BEGIN_WORK);
            this.addDBMSCommand(TransactionStartCommand.START_TRANSACTION.getVerb(), TransactionStartCommand.START_TRANSACTION);
        }
        if (this.metaData.isMySql()) {
            object5 = new MySQLShow();
            this.addDBMSCommand(((MySQLShow)object5).getVerb(), (SqlCommand)object5);
        }
        object5 = wbConnection.getDbSettings().getListProperty("start_transaction");
        object4 = object5.iterator();
        while (object4.hasNext()) {
            object3 = (String)object4.next();
            if (this.cmdDispatch.containsKey(object3 = SqlUtil.makeCleanSql((String)object3, false, false))) {
                LogMgr.logInfo(new CallerInfo(){}, "Configured command " + ((String)object3).toUpperCase() + " is already registered as a transaction start command");
                continue;
            }
            LogMgr.logInfo(new CallerInfo(){}, "Adding " + ((String)object3).toUpperCase() + " as a transaction start command");
            object2 = TransactionStartCommand.fromVerb((String)object3);
            this.addDBMSCommand(((TransactionStartCommand)object2).getVerb(), (SqlCommand)object2);
        }
        if (this.metaData.getDbSettings().useWbProcedureCall()) {
            object4 = this.cmdDispatch.get("WbCall");
            this.addDBMSCommand("CALL", (SqlCommand)object4);
        }
        object4 = wbConnection.getDbSettings().getListProperty("ignore");
        object3 = object4.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            if (object2 == null) continue;
            object = new IgnoredCommand((String)object2);
            this.addDBMSCommand((String)object2, (SqlCommand)object);
        }
        object3 = wbConnection.getDbSettings().getListProperty("passthrough");
        this.passThrough.clear();
        if (object3 != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this.passThrough.add((String)object);
            }
        }
        this.supportsSelectInto = this.metaData.supportsSelectIntoNewTable();
    }

    public SqlCommand getCommandToUse(String string) {
        WbConnection wbConnection = this.metaData == null ? null : this.metaData.getWbConnection();
        String string2 = SqlParsingUtil.getInstance(wbConnection).getSqlVerb(string);
        if (this.supportsSelectInto && "SELECT".equals(string2) && this.metaData != null && this.metaData.isSelectIntoNewTable(string)) {
            LogMgr.logDebug(new CallerInfo(){}, "Found 'SELECT ... INTO new_table'");
            return this.cmdDispatch.get("*");
        }
        return this.getCommandFromVerb(string2);
    }

    public SqlCommand getCommandFromVerb(String string) {
        SqlCommand sqlCommand = null;
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        sqlCommand = this.passThrough.size() > 0 && this.passThrough.contains(string) ? this.cmdDispatch.get("*") : this.cmdDispatch.get(string);
        if (sqlCommand == null && this.allowAbbreviated) {
            Set<String> set = this.cmdDispatch.keySet();
            int n = 0;
            String string2 = null;
            String string3 = string.toLowerCase();
            for (String string4 : set) {
                if (!this.cmdDispatch.get(string4).isWbCommand() || !string4.toLowerCase().startsWith(string3)) continue;
                string2 = string4;
                ++n;
            }
            if (n == 1) {
                LogMgr.logDebug(new CallerInfo(){}, "Found workbench command " + string2 + " for abbreviation " + string);
                sqlCommand = this.cmdDispatch.get(string2);
            }
        }
        if (sqlCommand == null) {
            sqlCommand = this.cmdDispatch.get("*");
        }
        return sqlCommand;
    }
}

