/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import java.sql.SQLException;
import workbench.util.DdlObjectInfo;
import workbench.util.ExceptionUtil;
import workbench.util.WbFile;

public class ErrorDescriptor {
    private int errorPosition = -1;
    private int errorLine = -1;
    private int errorColumn = -1;
    private DdlObjectInfo object;
    private String errorMessage;
    private String errorCode;
    private boolean messageIncludesPosition;
    private int inStatementOffset = 0;
    private String originalStatement;
    private WbFile scriptFile;

    public ErrorDescriptor() {
    }

    public ErrorDescriptor(String string) {
        this.errorMessage = string;
    }

    public ErrorDescriptor(Throwable throwable) {
        this.errorMessage = ExceptionUtil.getDisplay(throwable);
        this.setErrorCode(throwable);
    }

    public WbFile getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(WbFile wbFile) {
        this.scriptFile = wbFile;
    }

    public String getOriginalStatement() {
        return this.originalStatement;
    }

    public void setOriginalStatement(String string) {
        this.originalStatement = string;
    }

    public boolean getMessageIncludesPosition() {
        return this.messageIncludesPosition;
    }

    public void setMessageIncludesPosition(boolean bl) {
        this.messageIncludesPosition = bl;
    }

    public void setErrorPosition(int n, int n2) {
        this.errorLine = n;
        this.errorColumn = n2;
    }

    public int getErrorLine() {
        return this.errorLine;
    }

    public int getErrorColumn() {
        return this.errorColumn;
    }

    public int getErrorPosition() {
        return this.errorPosition + this.inStatementOffset;
    }

    public void setInStatementOffset(int n) {
        this.inStatementOffset = n;
    }

    public void setErrorOffset(int n) {
        this.errorPosition = n;
    }

    public void setObjectInfo(DdlObjectInfo ddlObjectInfo) {
        this.object = ddlObjectInfo != null && ddlObjectInfo.isValid() ? ddlObjectInfo : null;
    }

    public DdlObjectInfo getObjectInfo() {
        return this.object;
    }

    public String getErrorCode(boolean bl) {
        if (this.errorCode != null && bl) {
            return this.errorCode.toUpperCase();
        }
        return this.errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Throwable throwable) {
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            String string = sQLException.getSQLState();
            if (n != 0) {
                this.errorCode = String.valueOf(n);
            } else if (string != null) {
                this.errorCode = string;
            }
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public boolean hasError() {
        return this.errorPosition > -1 || this.errorLine > -1 && this.errorColumn > -1;
    }

    public String toString() {
        String string;
        String string2 = string = this.errorMessage != null ? this.errorMessage : "";
        if (this.errorPosition > -1) {
            return string + "\n\nat position " + this.errorPosition;
        }
        if (this.errorLine > -1 && this.errorColumn > -1) {
            return string + "\n\nat line: " + this.errorLine + ", column: " + this.errorColumn;
        }
        return this.errorMessage != null ? this.errorMessage : "no error";
    }
}

