/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import workbench.db.IdentifierCase;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class NameUtil {
    private static final String INVALID_CHARS = "- .:\\/\"'!%&()=?+*";

    public static String camelCaseToSnakeUpper(String string) {
        return NameUtil.camelCaseToSnake(string, IdentifierCase.upper);
    }

    public static String camelCaseToSnakeLower(String string) {
        return NameUtil.camelCaseToSnake(string, IdentifierCase.lower);
    }

    public static String camelCaseToSnake(String string) {
        return NameUtil.camelCaseToSnake(string, IdentifierCase.mixed);
    }

    public static String camelCaseToSnake(String string, IdentifierCase identifierCase) {
        if (string == null) {
            return "";
        }
        string = SqlUtil.removeObjectQuotes(string);
        StringBuilder stringBuilder = new StringBuilder(string.length() + 5);
        char c = '\u0000';
        char c2 = '\u0000';
        block4: for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (Character.isUpperCase(c) && (Character.isLowerCase(c2) || Character.isWhitespace(c2)) && c2 != '_') {
                stringBuilder.append('_');
            }
            if (c == '-' || Character.isWhitespace(c) || !Character.isDigit(c) && !Character.isLetter(c) || INVALID_CHARS.indexOf(c) > -1) {
                c = '_';
            }
            c2 = c;
            switch (identifierCase) {
                case lower: {
                    stringBuilder.append(Character.toLowerCase(c));
                    continue block4;
                }
                case upper: {
                    stringBuilder.append(Character.toUpperCase(c));
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return SqlUtil.quoteObjectname(stringBuilder.toString(), false, true, '\"');
    }

    public static String cleanupIdentifier(String string, String string2) {
        if (string == null) {
            return "";
        }
        boolean bl = StringUtil.stringToBool(string2);
        string = SqlUtil.removeObjectQuotes(string);
        if (bl) {
            string = string.toLowerCase();
        }
        return SqlUtil.cleanupIdentifier(string);
    }

    public static String quoteIfNeeded(String string) {
        return SqlUtil.quoteObjectname(string, false, true, '\"');
    }

    public static String preserveCase(String string) {
        if (StringUtil.isMixedCase(string)) {
            return '\"' + string + '\"';
        }
        return SqlUtil.quoteObjectname(string, false, true, '\"');
    }

    public static String preserveLowercase(String string) {
        if (StringUtil.isMixedCase(string) || StringUtil.isLowerCase(string)) {
            return '\"' + string + '\"';
        }
        return SqlUtil.quoteObjectname(string, false, true, '\"');
    }

    public static String preserveUppercase(String string) {
        if (StringUtil.isMixedCase(string) || StringUtil.isUpperCase(string)) {
            return '\"' + string + '\"';
        }
        return SqlUtil.quoteObjectname(string, false, true, '\"');
    }

    public static String toLowerCase(String string) {
        if (string == null) {
            return "";
        }
        return string.toLowerCase();
    }

    public static String toUpperCase(String string) {
        if (string == null) {
            return "";
        }
        return string.toUpperCase();
    }
}

