/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.interfaces.JobErrorHandler;
import workbench.resource.ResourceMgr;
import workbench.sql.VariablePool;
import workbench.storage.DataStore;
import workbench.storage.DmlStatement;
import workbench.storage.RowData;

public class VariablesDataStore
extends DataStore {
    private static final String[] cols = new String[]{ResourceMgr.getString("LblVariableName"), ResourceMgr.getString("LblVariableValue")};
    private static final int[] types = new int[]{12, 12};
    private static final int[] sizes = new int[]{20, 50};
    private static final TableIdentifier TABLE_ID = new TableIdentifier("WB$VARIABLE_DEFINITION");

    public VariablesDataStore() {
        super(cols, types, sizes);
        this.setUpdateTable(TABLE_ID);
    }

    @Override
    public List<DmlStatement> getUpdateStatements(WbConnection wbConnection) {
        return Collections.emptyList();
    }

    @Override
    public boolean hasPkColumns() {
        return true;
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    @Override
    public boolean hasUpdateableColumns() {
        return true;
    }

    @Override
    public boolean checkUpdateTable() {
        return true;
    }

    @Override
    public boolean checkUpdateTable(WbConnection wbConnection) {
        return true;
    }

    @Override
    public int updateDb(WbConnection wbConnection, JobErrorHandler jobErrorHandler) throws SQLException, IllegalArgumentException {
        String string;
        int n = this.getRowCount();
        this.resetUpdateRowCounters();
        VariablePool variablePool = VariablePool.getInstance();
        for (int i = 0; i < n; ++i) {
            String string2;
            string = this.getValueAsString(i, 0);
            String string3 = (String)this.getOriginalValue(i, 0);
            if (string3 != null && !string.equals(string3)) {
                variablePool.removeVariable(string3);
            }
            variablePool.setParameterValue(string, (string2 = this.getValueAsString(i, 1)) == null ? "" : string2);
        }
        RowData rowData = this.getNextDeletedRow();
        while (rowData != null) {
            string = (String)rowData.getValue(0);
            variablePool.removeVariable(string);
            rowData = this.getNextDeletedRow();
        }
        this.resetStatus();
        return n;
    }
}

