/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.commands;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import workbench.db.JdbcUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.LowMemoryException;

public class SelectCommand
extends SqlCommand {
    public static final String VERB = "SELECT";

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        this.isCancelled = false;
        StatementRunnerResult statementRunnerResult = this.createResult(string);
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            boolean bl = false;
            if (this.runner.useSavepointForDML()) {
                this.runner.setSavepoint();
            }
            if (Settings.getInstance().getCheckPreparedStatements() && this.currentConnection.getPreparedStatementPool().isRegistered(string)) {
                this.currentStatement = this.currentConnection.getPreparedStatementPool().prepareStatement(string);
                if (this.currentStatement != null) {
                    bl = true;
                }
            }
            if (this.currentStatement == null) {
                this.currentStatement = this.currentConnection.createStatementForQuery();
            }
            if (this.currentStatement == null) {
                LogMgr.logError(new CallerInfo(){}, "Connection.createStatement() did not return a statement instance", null);
                throw new SQLException("No statement created! This is most probably a bug in the JDBC driver.");
            }
            try {
                if (this.queryTimeout > 0 && this.currentConnection.supportsQueryTimeout()) {
                    LogMgr.logTrace(callerInfo, "Setting query timeout to: " + this.queryTimeout);
                    this.currentStatement.setQueryTimeout(this.queryTimeout);
                }
            }
            catch (Exception exception) {
                LogMgr.logWarning(callerInfo, "Error when setting query timeout: " + exception.getMessage(), null);
            }
            this.setMaxRowsForStatement(this.currentStatement);
            ResultSet resultSet = null;
            boolean bl2 = true;
            string = this.getSqlToExecute(string);
            if (bl) {
                resultSet = ((PreparedStatement)this.currentStatement).executeQuery();
            } else if (this.currentConnection.getDbSettings().getUseGenericExecuteForSelect()) {
                LogMgr.logDebug(callerInfo, "Using execute() instead of executeQuery()");
                bl2 = this.currentStatement.execute(string);
            } else {
                resultSet = this.currentStatement.executeQuery(string);
            }
            if (this.isCancelled) {
                statementRunnerResult.addMessageByKey("MsgStatementCancelled");
                statementRunnerResult.setFailure();
            } else {
                this.processResults(statementRunnerResult, bl2, resultSet);
                if (this.isCancelled) {
                    statementRunnerResult.addMessageByKey("MsgStatementCancelled");
                } else {
                    this.appendSuccessMessage(statementRunnerResult);
                }
                statementRunnerResult.setSuccess();
            }
            this.runner.releaseSavepoint();
        }
        catch (LowMemoryException lowMemoryException) {
            statementRunnerResult.clear();
            statementRunnerResult.setFailure();
            this.runner.rollbackSavepoint();
            throw lowMemoryException;
        }
        catch (Exception exception) {
            this.addErrorInfo(statementRunnerResult, string, exception);
            if (this.currentConnection.getDbSettings().addWarningsOnError()) {
                this.appendWarnings(statementRunnerResult, true);
            } else {
                JdbcUtils.clearWarnings(this.currentConnection, this.currentStatement);
            }
            LogMgr.logUserSqlError(callerInfo, string, exception);
            this.runner.rollbackSavepoint();
        }
        return statementRunnerResult;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public void setMaxRows(int n) {
        this.maxRows = n >= 0 ? n : 0;
    }
}

