/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.fksupport;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import workbench.db.WbConnection;
import workbench.gui.completion.BaseAnalyzer;
import workbench.gui.completion.StatementContext;
import workbench.resource.GeneratedIdentifierCase;
import workbench.resource.Settings;
import workbench.sql.fksupport.JoinColumnsDetector;
import workbench.sql.fksupport.JoinCondition;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.syntax.SqlKeywordHelper;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.TableAlias;

public class JoinCreator {
    private String sql;
    private WbConnection connection;
    private int cursorPos;
    private Map<Integer, TableAlias> tablePositions;
    private Set<String> keywords;
    private boolean preferUsingOperator;
    private boolean alwaysUseParenthesis;
    private GeneratedIdentifierCase keywordCase;
    private GeneratedIdentifierCase identifierCase;

    public JoinCreator(String string, int n, WbConnection wbConnection) {
        this.connection = wbConnection;
        String string2 = this.connection != null ? this.connection.getDbId() : null;
        SqlKeywordHelper sqlKeywordHelper = new SqlKeywordHelper(string2);
        this.keywords = sqlKeywordHelper.getKeywords();
        int n2 = this.setSql(string, n);
        this.setCursorPosition(n2);
        this.preferUsingOperator = Settings.getInstance().getJoinCompletionPreferUSING();
        this.alwaysUseParenthesis = Settings.getInstance().getJoinCompletionUseParens();
        this.identifierCase = Settings.getInstance().getFormatterIdentifierCase();
        this.keywordCase = Settings.getInstance().getFormatterKeywordsCase();
    }

    public WbConnection getConnection() {
        return this.connection;
    }

    public void setKeywordCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.keywordCase = generatedIdentifierCase;
    }

    public void setIdentifierCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.identifierCase = generatedIdentifierCase;
    }

    public void setAlwaysUseParenthesis(boolean bl) {
        this.alwaysUseParenthesis = bl;
    }

    public void setPreferUsingOperator(boolean bl) {
        this.preferUsingOperator = bl;
    }

    public final void setCursorPosition(int n) {
        this.cursorPos = n;
        this.retrieveTablePositions();
    }

    private int setSql(String string, int n) {
        StatementContext statementContext = new StatementContext(this.connection, string, n, false);
        BaseAnalyzer baseAnalyzer = statementContext.getAnalyzer();
        if (baseAnalyzer == null) {
            this.sql = string;
            return n;
        }
        this.sql = baseAnalyzer.getAnalyzedSql();
        return baseAnalyzer.getCursorPosition();
    }

    public List<JoinCondition> getJoinConditions() throws SQLException {
        TableAlias tableAlias = this.getJoinTable();
        return this.getJoinConditions(tableAlias);
    }

    public List<JoinCondition> getJoinConditions(TableAlias tableAlias) throws SQLException {
        TableAlias tableAlias2 = this.getJoinedTable();
        if (tableAlias == null || tableAlias2 == null) {
            return Collections.emptyList();
        }
        JoinColumnsDetector joinColumnsDetector = new JoinColumnsDetector(this.connection, tableAlias, tableAlias2);
        joinColumnsDetector.setPreferUsingOperator(this.preferUsingOperator);
        joinColumnsDetector.setKeywordCase(this.keywordCase);
        joinColumnsDetector.setIdentifierCase(this.identifierCase);
        joinColumnsDetector.setAlwaysUseParentheses(this.alwaysUseParenthesis);
        return joinColumnsDetector.getJoinConditions();
    }

    public String getJoinCondition(JoinCondition joinCondition) throws SQLException {
        String string = StringUtil.findWordLeftOfCursor(this.sql, this.cursorPos);
        boolean bl = this.isWhitespaceAtCursor();
        boolean bl2 = true;
        if ("ON".equalsIgnoreCase(string) || "USING".equalsIgnoreCase(string)) {
            bl2 = false;
        }
        joinCondition.setPreferUsingOperator(this.preferUsingOperator);
        joinCondition.setUseParentheses(this.alwaysUseParenthesis);
        String string2 = joinCondition.getJoinCondition(bl2, this.connection.getMetadata());
        if (!bl) {
            string2 = " " + string2;
        }
        return string2;
    }

    private boolean isWhitespaceAtCursor() {
        if (this.cursorPos > 0) {
            char c = this.sql.charAt(this.cursorPos - 1);
            return Character.isWhitespace(c);
        }
        return false;
    }

    public List<TableAlias> getPossibleJoinTables() {
        Integer n = this.getTableIndexBeforeCursor();
        if (n == null) {
            return Collections.emptyList();
        }
        int n2 = n;
        TableAlias tableAlias = this.getJoinTable();
        ArrayList<TableAlias> arrayList = new ArrayList<TableAlias>(this.tablePositions.size());
        for (Map.Entry<Integer, TableAlias> entry : this.tablePositions.entrySet()) {
            int n3 = entry.getKey();
            if (n3 >= n2 || entry.getValue().equals(tableAlias)) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public TableAlias getJoinTable() {
        Integer n = this.getTableIndexBeforeCursor();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.tablePositions.keySet());
        int n2 = arrayList.indexOf(n);
        if (n2 > 0) {
            Integer n3 = (Integer)arrayList.get(n2 - 1);
            return this.tablePositions.get(n3);
        }
        return null;
    }

    public TableAlias getJoinedTable() {
        Integer n = this.getTableIndexBeforeCursor();
        return this.tablePositions.get(n);
    }

    private Integer getTableIndexBeforeCursor() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.tablePositions.keySet());
        for (int i = 0; i < arrayList.size(); ++i) {
            if ((Integer)arrayList.get(i) <= this.cursorPos || i <= 0) continue;
            return (Integer)arrayList.get(i - 1);
        }
        return (Integer)arrayList.get(arrayList.size() - 1);
    }

    private void retrieveTablePositions() {
        this.tablePositions = new TreeMap<Integer, TableAlias>();
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.connection, this.sql);
        int n = 0;
        boolean bl = false;
        Set<String> set = SqlUtil.getJoinKeyWords();
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        while (sQLToken != null) {
            String string = sQLToken.getContents();
            if ("(".equals(string)) {
                ++n;
            } else if (")".equals(string)) {
                --n;
            } else if (n == 0) {
                if (bl) {
                    TableAlias tableAlias = null;
                    SQLToken sQLToken2 = sQLLexer.getNextToken(false, false);
                    boolean bl2 = false;
                    if (sQLToken2 != null) {
                        if (sQLToken2.getText().equalsIgnoreCase("AS")) {
                            sQLToken2 = sQLLexer.getNextToken(false, false);
                        }
                        if (!this.keywords.contains(sQLToken2.getText())) {
                            tableAlias = new TableAlias(string + " " + sQLToken2.getContents());
                        }
                    }
                    if (tableAlias == null) {
                        tableAlias = new TableAlias(string);
                        bl2 = true;
                    }
                    this.tablePositions.put(sQLToken.getCharBegin(), tableAlias);
                    bl = false;
                    if (bl2) {
                        sQLToken = sQLToken2;
                        continue;
                    }
                } else {
                    bl = string.equals("FROM") ? true : set.contains(string);
                }
            }
            sQLToken = sQLLexer.getNextToken(false, false);
        }
    }
}

