/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.generator;

import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.sql.generator.DefaultInsertGenerator;
import workbench.sql.generator.InsertType;
import workbench.util.CollectionUtil;

public class FirebirdInsertGenerator
extends DefaultInsertGenerator {
    public FirebirdInsertGenerator(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        super(tableIdentifier, list);
    }

    public FirebirdInsertGenerator(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, WbConnection wbConnection) {
        super(tableIdentifier, list, wbConnection);
    }

    @Override
    public boolean supportsType(InsertType insertType) {
        return insertType == InsertType.Insert || insertType == InsertType.Upsert || insertType == InsertType.Merge;
    }

    @Override
    protected String getInsertSQLStart() {
        if (this.getInsertType() == InsertType.Upsert) {
            return "UPDATE OR INSERT INTO ";
        }
        return super.getInsertSQLStart();
    }

    @Override
    protected CharSequence buildFinalPart() {
        if (this.getInsertType() == InsertType.Upsert) {
            return this.getMatchingClause();
        }
        return super.buildFinalPart();
    }

    private CharSequence getMatchingClause() {
        List<ColumnIdentifier> list = this.getKeyColumns();
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(list.size() * 20);
        stringBuilder.append("\nMATCHING (");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            String string = list.get(i).getDisplayName();
            stringBuilder.append(this.quoteHandler.quoteObjectname(string));
        }
        stringBuilder.append(')');
        return stringBuilder;
    }
}

