/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.macros;

import java.awt.Component;
import java.io.File;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ExtensionFileFilter;
import workbench.gui.components.WbFileChooser;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.macros.MacroManager;
import workbench.util.WbFile;

public class MacroFileSelector {
    public static final String LAST_DIR_PROPERTY = "workbench.macros.lastdir";

    public boolean canLoadMacros(int n) {
        if (!MacroManager.getInstance().getMacros(n).isModified()) {
            return true;
        }
        int n2 = WbSwingUtilities.getYesNoCancel(WbManager.getInstance().getCurrentWindow(), ResourceMgr.getString("MsgConfirmUnsavedMacros"));
        if (n2 == 2) {
            return false;
        }
        if (n2 == 0) {
            MacroManager.getInstance().save();
        }
        return true;
    }

    public WbFile selectMacroFile(Component component) {
        return this.selectStorageFile(component, false, null);
    }

    public WbFile selectStorageForLoad(Component component, int n) {
        if (!this.canLoadMacros(n)) {
            return null;
        }
        return this.selectStorageFile(component, false, null);
    }

    public WbFile selectStorageForSave(Component component, int n) {
        return this.selectStorageFile(component, true, MacroManager.getInstance().getMacros(n).getCurrentFile());
    }

    private WbFile selectStorageFile(Component component, boolean bl, File file) {
        String string = Settings.getInstance().getProperty(LAST_DIR_PROPERTY, Settings.getInstance().getConfigDir().getAbsolutePath());
        WbFileChooser wbFileChooser = new WbFileChooser(string);
        wbFileChooser.addChoosableFileFilter(ExtensionFileFilter.getXmlFileFilter());
        wbFileChooser.setFileFilter(ExtensionFileFilter.getXmlFileFilter());
        int n = 1;
        if (bl) {
            if (file != null) {
                wbFileChooser.setSelectedFile(file);
            }
            n = wbFileChooser.showSaveDialog(component);
        } else {
            n = wbFileChooser.showOpenDialog(component);
        }
        File file2 = null;
        if (n == 0) {
            WbFile wbFile;
            String string2;
            file2 = wbFileChooser.getSelectedFile();
            if (bl && !(string2 = (wbFile = new WbFile(file2)).getExtension()).equalsIgnoreCase("xml")) {
                String string3 = wbFile.getFullPath();
                string3 = string3 + ".xml";
                file2 = new File(string3);
            }
            string = wbFileChooser.getCurrentDirectory().getAbsolutePath();
            Settings.getInstance().setProperty(LAST_DIR_PROPERTY, string);
        }
        if (file2 == null) {
            return null;
        }
        return new WbFile(file2);
    }
}

