/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.parser;

import workbench.sql.DelimiterDefinition;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.OracleDelimiterTester;
import workbench.sql.parser.ParserType;
import workbench.sql.parser.PostgresDelimiterTester;
import workbench.sql.parser.ShortIncludeDelimiterTester;

public interface DelimiterTester {
    public void setAlternateDelimiter(DelimiterDefinition var1);

    public void setDelimiter(DelimiterDefinition var1);

    public void currentToken(SQLToken var1, boolean var2);

    public DelimiterDefinition getCurrentDelimiter();

    public void statementFinished();

    public boolean supportsMixedDelimiters();

    public boolean supportsSingleLineStatements();

    public boolean isSingleLineStatement(SQLToken var1, boolean var2);

    public void lineEnd();

    public static DelimiterTester createInstance(ParserType parserType) {
        switch (parserType) {
            case Oracle: {
                return new OracleDelimiterTester();
            }
            case Postgres: {
                return new PostgresDelimiterTester();
            }
            case Standard: {
                return new ShortIncludeDelimiterTester();
            }
        }
        return null;
    }
}

