/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.parser;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Pattern;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.DelimiterDefinition;
import workbench.sql.ScriptCommandDefinition;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.DelimiterTester;
import workbench.sql.parser.ParserType;
import workbench.sql.parser.ScriptIterator;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class LexerBasedParser
implements ScriptIterator {
    private File originalFile;
    protected String fileEncoding;
    protected SQLLexer lexer;
    protected Reader input;
    protected DelimiterDefinition delimiter = DelimiterDefinition.STANDARD_DELIMITER;
    protected DelimiterDefinition alternateDelimiter = null;
    protected int currentStatementIndex;
    protected boolean checkEscapedQuotes;
    protected boolean storeStatementText = true;
    protected boolean returnLeadingWhitespace;
    protected boolean emptyLineIsDelimiter;
    protected int scriptLength;
    protected int realScriptLength;
    protected boolean calledOnce;
    protected boolean checkPgQuoting;
    protected boolean lastStatementUsedTerminator;
    protected final ParserType parserType;
    protected Pattern MULTI_LINE_PATTERN = Pattern.compile("(([ \t\f]*\n[ \t\f]*){2,})|(([ \t\f]*\r\n[ \t\f]*){2,})");
    protected Pattern SIMPLE_LINE_BREAK = Pattern.compile("(([ \t\f]*\n[ \t\f]*)+)|(([ \t\f]*\r\n[ \t\f]*)+)");
    protected DelimiterTester delimiterTester;

    public LexerBasedParser() {
        this(ParserType.Standard);
    }

    public LexerBasedParser(ParserType parserType) {
        this.parserType = parserType;
        this.setCheckPgQuoting(this.parserType == ParserType.Postgres);
        this.delimiterTester = DelimiterTester.createInstance(parserType);
    }

    public LexerBasedParser(String string) throws IOException {
        this.parserType = ParserType.Standard;
        this.setScript(string);
    }

    public LexerBasedParser(File file, String string) throws IOException {
        this.parserType = ParserType.Standard;
        this.setFile(file, string);
    }

    public ParserType getParserType() {
        return this.parserType;
    }

    @Override
    public boolean supportsMixedDelimiter() {
        if (this.delimiterTester == null) {
            return false;
        }
        return this.delimiterTester.supportsMixedDelimiters();
    }

    @Override
    public void setAlternateDelimiter(DelimiterDefinition delimiterDefinition) {
        if (delimiterDefinition == null) {
            this.alternateDelimiter = null;
        } else {
            this.alternateDelimiter = delimiterDefinition.createCopy();
            if (this.delimiterTester != null) {
                this.delimiterTester.setAlternateDelimiter(this.alternateDelimiter);
            }
        }
    }

    @Override
    public void setDelimiter(DelimiterDefinition delimiterDefinition) {
        this.delimiter = delimiterDefinition.createCopy();
        if (this.delimiterTester != null) {
            this.delimiterTester.setDelimiter(this.delimiter);
        }
    }

    @Override
    public void setEmptyLineIsDelimiter(boolean bl) {
        this.emptyLineIsDelimiter = bl;
    }

    public void setCheckPgQuoting(boolean bl) {
        this.checkPgQuoting = bl;
    }

    @Override
    public void setStoreStatementText(boolean bl) {
        this.storeStatementText = bl;
    }

    @Override
    public void done() {
        this.cleanup();
        FileUtil.closeQuietely(this.input);
    }

    protected DelimiterDefinition getCurrentDelimiter() {
        if (this.delimiterTester != null) {
            return this.delimiterTester.getCurrentDelimiter();
        }
        return this.delimiter;
    }

    @Override
    public ScriptCommandDefinition getNextCommand() {
        Object object;
        this.calledOnce = true;
        DelimiterDefinition delimiterDefinition = this.getCurrentDelimiter();
        SQLToken sQLToken = null;
        sQLToken = this.lastStatementUsedTerminator && this.emptyLineIsDelimiter ? this.skipEmptyLines() : this.lexer.getNextToken(true, true);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        int n = -1;
        int n2 = sQLToken != null ? sQLToken.getCharBegin() : 0;
        int n3 = -1;
        String string = "";
        String string2 = null;
        StringBuilder stringBuilder = null;
        if (this.storeStatementText || !this.returnLeadingWhitespace) {
            stringBuilder = new StringBuilder(250);
        }
        this.lastStatementUsedTerminator = false;
        Object object2 = null;
        while (sQLToken != null) {
            String string3 = sQLToken.getText();
            boolean bl7 = bl6 = !sQLToken.isComment() && this.isLineBreak(string3);
            if (!bl6) {
                if (string.isEmpty()) {
                    n3 = sQLToken.getCharBegin();
                }
                string = string + string3;
            }
            if (this.delimiterTester != null) {
                this.delimiterTester.currentToken(sQLToken, bl5);
                delimiterDefinition = this.delimiterTester.getCurrentDelimiter();
            }
            if (this.checkPgQuoting && this.isDollarQuote(string3)) {
                if (bl3 && string3.equals(string2)) {
                    bl3 = false;
                    string2 = null;
                } else if (!bl3) {
                    bl3 = true;
                    string2 = string3;
                }
            } else if (sQLToken.isUnclosedString()) {
                bl2 = true;
            } else if (bl2) {
                if (string3.charAt(0) == '\'') {
                    bl2 = false;
                }
            } else if (!bl3) {
                if (bl5 && this.delimiterTester != null && !sQLToken.isWhiteSpace() && !sQLToken.isComment()) {
                    bl = this.delimiterTester.isSingleLineStatement(sQLToken, bl5);
                }
                if (!delimiterDefinition.isSingleLine() && string3.equals(delimiterDefinition.getDelimiter())) {
                    this.lastStatementUsedTerminator = true;
                    object2 = delimiterDefinition;
                    if (n != -1) break;
                    n = sQLToken.getCharBegin();
                    break;
                }
                if (bl6 || sQLToken.isWhiteSpace() && this.isMultiLine(string3)) {
                    if (this.delimiterTester != null) {
                        this.delimiterTester.lineEnd();
                    }
                    object = null;
                    if (!bl) {
                        object = this.matchesLineDelimiter(string, delimiterDefinition);
                    }
                    if (object != null) {
                        this.lastStatementUsedTerminator = true;
                        object2 = object;
                        break;
                    }
                    if (bl || this.emptyLineIsDelimiter && !bl5 && this.isMultiLine(string3) && delimiterDefinition.equals(this.delimiter)) {
                        this.lastStatementUsedTerminator = false;
                        break;
                    }
                    bl = false;
                    string = "";
                }
            }
            if (bl5 && !sQLToken.isWhiteSpace() && !sQLToken.isComment()) {
                bl5 = false;
            }
            n = sQLToken.getCharEnd();
            sQLToken = this.lexer.getNextToken(true, true);
            if (stringBuilder == null) continue;
            stringBuilder.append(string3);
        }
        boolean bl8 = false;
        if (n3 > -1 && (object = this.matchesLineDelimiter(string, delimiterDefinition)) != null) {
            this.trimStatement(stringBuilder, n3, n);
            n = n3;
            object2 = object;
            bl8 = true;
        }
        if (n >= 0) {
            if (sQLToken == null && !bl4 && !bl8) {
                n = this.realScriptLength;
            }
            object = this.createCommandDef(stringBuilder, n2, n);
            ((ScriptCommandDefinition)object).setIndexInScript(this.currentStatementIndex);
            ((ScriptCommandDefinition)object).setDelimiterUsed((DelimiterDefinition)object2);
            ((ScriptCommandDefinition)object).setDelimiterNeeded(!bl);
            ++this.currentStatementIndex;
            if (this.delimiterTester != null) {
                this.delimiterTester.statementFinished();
            }
            return object;
        }
        return null;
    }

    private DelimiterDefinition matchesLineDelimiter(String string, DelimiterDefinition delimiterDefinition) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        if (delimiterDefinition != null && delimiterDefinition.isSingleLine() && string.equalsIgnoreCase(delimiterDefinition.getDelimiter())) {
            return delimiterDefinition;
        }
        if (this.alternateDelimiter != null && this.alternateDelimiter.isSingleLine() && string.equalsIgnoreCase(this.alternateDelimiter.getDelimiter())) {
            return this.alternateDelimiter;
        }
        return null;
    }

    private void trimStatement(StringBuilder stringBuilder, int n, int n2) {
        if (stringBuilder == null) {
            return;
        }
        if (n < n2) {
            int n3 = n2 - n;
            stringBuilder.delete(stringBuilder.length() - n3, stringBuilder.length());
        }
    }

    protected SQLToken skipEmptyLines() {
        SQLToken sQLToken = this.lexer.getNextToken(true, true);
        if (sQLToken == null) {
            return null;
        }
        String string = sQLToken.getText();
        while (sQLToken != null && (this.isLineBreak(string) || this.isMultiLine(string))) {
            sQLToken = this.lexer.getNextToken(true, true);
            if (sQLToken == null) continue;
            string = sQLToken.getText();
        }
        return sQLToken;
    }

    boolean isLineBreak(String string) {
        return this.SIMPLE_LINE_BREAK.matcher(string).matches();
    }

    boolean isMultiLine(String string) {
        return this.MULTI_LINE_PATTERN.matcher(string).matches();
    }

    protected ScriptCommandDefinition createCommandDef(StringBuilder stringBuilder, int n, int n2) {
        if (this.returnLeadingWhitespace || StringUtil.isEmptyString(stringBuilder) || !Character.isWhitespace(stringBuilder.charAt(0))) {
            String string = this.storeStatementText ? stringBuilder.toString() : null;
            return new ScriptCommandDefinition(string, n, n2);
        }
        int n3 = StringUtil.findFirstNonWhitespace(stringBuilder);
        if (n3 < 0) {
            n3 = 0;
        }
        String string = null;
        if (this.storeStatementText) {
            string = stringBuilder.substring(n3);
        }
        ScriptCommandDefinition scriptCommandDefinition = new ScriptCommandDefinition(string, n + n3, n2);
        scriptCommandDefinition.setWhitespaceStart(n);
        return scriptCommandDefinition;
    }

    @Override
    public int getScriptLength() {
        return this.scriptLength;
    }

    @Override
    public void setCheckEscapedQuotes(boolean bl) {
        this.checkEscapedQuotes = bl;
    }

    private void createLexer() {
        this.lexer = this.checkEscapedQuotes ? SQLLexerFactory.createNonStandardLexer(this.parserType, this.input) : SQLLexerFactory.createLexer(this.parserType, this.input);
    }

    @Override
    public final void setFile(File file, String string) throws IOException {
        this.cleanup();
        this.scriptLength = (int)FileUtil.getCharacterLength(file, string);
        this.input = EncodingUtil.createBufferedReader(file, string);
        this.createLexer();
        this.fileEncoding = string;
        this.originalFile = file;
    }

    @Override
    public void setReturnStartingWhitespace(boolean bl) {
        this.returnLeadingWhitespace = bl;
    }

    @Override
    public final void setScript(String string) {
        this.cleanup();
        String string2 = StringUtil.rtrim(string);
        this.input = new StringReader(string2);
        this.createLexer();
        this.scriptLength = string2.length();
        this.realScriptLength = string.length();
    }

    private void cleanup() {
        this.lexer = null;
        this.calledOnce = false;
        this.currentStatementIndex = 0;
        this.scriptLength = 0;
        this.realScriptLength = 0;
        this.lastStatementUsedTerminator = false;
        if (this.delimiterTester != null) {
            this.delimiterTester.statementFinished();
        }
    }

    @Override
    public void reset() {
        if (!this.calledOnce) {
            return;
        }
        try {
            if (this.originalFile != null) {
                FileUtil.closeQuietely(this.input);
                this.input = EncodingUtil.createBufferedReader(this.originalFile, this.fileEncoding);
            } else {
                this.input.reset();
            }
            this.cleanup();
            this.createLexer();
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Cannot re-open input stream", iOException);
        }
    }

    @Override
    public boolean supportsSingleLineCommands() {
        if (this.delimiterTester == null) {
            return false;
        }
        return this.delimiterTester.supportsSingleLineStatements();
    }

    protected boolean isDollarQuote(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        if (string.charAt(0) != '$') {
            return false;
        }
        if (string.equals("$wb_skip$")) {
            return false;
        }
        return string.endsWith("$");
    }
}

