/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.WbConnection;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.sql.ScriptCommandDefinition;
import workbench.sql.parser.LexerBasedParser;
import workbench.sql.parser.ParserType;
import workbench.sql.parser.ScriptIterator;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ScriptParser {
    private String originalScript;
    private List<ScriptCommandDefinition> commands;
    private DelimiterDefinition delimiter = DelimiterDefinition.STANDARD_DELIMITER;
    private DelimiterDefinition alternateDelimiter;
    private int currentIteratorIndex = -42;
    private boolean checkEscapedQuotes;
    private ScriptIterator scriptIterator;
    private boolean emptyLineIsSeparator;
    private boolean returnLeadingWhitespace;
    private boolean useAlternateDelimiter;
    private ParserType parserType = ParserType.Standard;
    private File source;

    public ScriptParser() {
        this(ParserType.Standard);
    }

    public ScriptParser(ParserType parserType) {
        this.parserType = parserType;
    }

    public ScriptParser(String string, ParserType parserType) {
        this(parserType);
        this.setScript(string);
    }

    public ScriptParser(String string) {
        this.setScript(string);
    }

    public void setParserType(ParserType parserType) {
        this.parserType = parserType;
        this.commands = null;
        if (this.scriptIterator != null) {
            this.scriptIterator = this.getParserInstance();
        }
    }

    private boolean doLoadFile(File file) {
        return file.length() <= (long)Settings.getInstance().getInMemoryScriptSizeThreshold();
    }

    public void setFile(File file) throws IOException {
        this.setFile(file, null, this.doLoadFile(file));
    }

    public final void setFile(File file, String string) throws IOException {
        this.setFile(file, string, this.doLoadFile(file));
    }

    public final void setFile(File file, String string, boolean bl) throws IOException {
        String string2;
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName() + " not found");
        }
        if (this.parserType != ParserType.Oracle && bl && (string2 = FileUtil.readFile(file, string)) != null) {
            this.setScript(string2);
            this.source = file;
            return;
        }
        this.useAlternateDelimiter = this.alternateDelimiter != null;
        this.scriptIterator = this.getParserInstance();
        this.scriptIterator.setFile(file, string);
        this.source = file;
    }

    public WbFile getScriptFile() {
        if (this.source == null) {
            return null;
        }
        return new WbFile(this.source);
    }

    public int getScriptLength() {
        if (this.scriptIterator != null) {
            return this.scriptIterator.getScriptLength();
        }
        if (this.originalScript != null) {
            return this.originalScript.length();
        }
        return 0;
    }

    public void readScriptFromFile(File file, String string) throws IOException {
        String string2 = FileUtil.readFile(file, string);
        this.setScript(string2 == null ? "" : string2);
    }

    public void setEmptyLineIsDelimiter(boolean bl) {
        this.emptyLineIsSeparator = bl;
    }

    public void setReturnStartingWhitespace(boolean bl) {
        this.returnLeadingWhitespace = bl;
    }

    public final void setScript(String string) {
        if (string == null) {
            throw new NullPointerException("SQL script may not be null");
        }
        if (string.equals(this.originalScript)) {
            return;
        }
        this.originalScript = string;
        this.commands = null;
        this.scriptIterator = null;
        this.source = null;
        this.currentIteratorIndex = 0;
    }

    public void setDelimiter(DelimiterDefinition delimiterDefinition) {
        this.setDelimiters(delimiterDefinition, null);
    }

    public void setAlternateDelimiter(DelimiterDefinition delimiterDefinition) {
        this.setDelimiters(DelimiterDefinition.STANDARD_DELIMITER, delimiterDefinition);
    }

    public void setDelimiters(DelimiterDefinition delimiterDefinition, DelimiterDefinition delimiterDefinition2) {
        this.delimiter = delimiterDefinition;
        if (this.alternateDelimiterChanged(delimiterDefinition2)) {
            this.commands = null;
            this.scriptIterator = null;
        }
        this.alternateDelimiter = delimiterDefinition2;
    }

    private boolean alternateDelimiterChanged(DelimiterDefinition delimiterDefinition) {
        if (this.alternateDelimiter == null && delimiterDefinition == null) {
            return false;
        }
        if (this.alternateDelimiter == null && delimiterDefinition != null) {
            return true;
        }
        if (this.alternateDelimiter != null && delimiterDefinition == null) {
            return true;
        }
        return !this.alternateDelimiter.equals(delimiterDefinition);
    }

    private void findDelimiterToUse() {
        if (this.alternateDelimiter == null) {
            return;
        }
        if (this.originalScript == null) {
            return;
        }
        this.useAlternateDelimiter = this.alternateDelimiter.terminatesScript(this.originalScript, this.parserType == ParserType.MySQL, '\"');
        this.commands = null;
    }

    public int getIndexInCommand(int n, int n2) {
        int n3;
        int n4;
        if (n < 0) {
            return -1;
        }
        if (this.commands == null) {
            this.parseCommands();
        }
        if (n >= this.commands.size()) {
            return -1;
        }
        ScriptCommandDefinition scriptCommandDefinition = this.commands.get(n);
        int n5 = scriptCommandDefinition.getStartPositionInScript();
        int n6 = n2 - n5;
        if (n6 > (n4 = (n3 = scriptCommandDefinition.getEndPositionInScript()) - n5)) {
            n6 = n4;
        }
        return n6;
    }

    public int getCommandIndexAtCursorPos(int n) {
        int n2;
        if (n < 0) {
            return -1;
        }
        if (this.commands == null) {
            this.parseCommands();
        }
        if ((n2 = this.commands.size()) == 1) {
            return 0;
        }
        if (n2 == 0) {
            return -1;
        }
        for (int i = 0; i < n2 - 1; ++i) {
            ScriptCommandDefinition scriptCommandDefinition = this.commands.get(i);
            ScriptCommandDefinition scriptCommandDefinition2 = this.commands.get(i + 1);
            if (n >= scriptCommandDefinition.getWhitespaceStart() && n < scriptCommandDefinition2.getStartPositionInScript()) {
                return i;
            }
            if (n > scriptCommandDefinition.getEndPositionInScript() && n < scriptCommandDefinition2.getEndPositionInScript()) {
                return i + 1;
            }
            if (scriptCommandDefinition.getEndPositionInScript() <= n || scriptCommandDefinition2.getWhitespaceStart() > n) continue;
            return i + 1;
        }
        ScriptCommandDefinition scriptCommandDefinition = this.commands.get(n2 - 1);
        if (scriptCommandDefinition.getWhitespaceStart() <= n && scriptCommandDefinition.getEndPositionInScript() >= n) {
            return n2 - 1;
        }
        return -1;
    }

    public int getStartPosForCommand(int n) {
        if (n < 0) {
            return -1;
        }
        if (this.commands == null) {
            this.parseCommands();
        }
        if (n >= this.commands.size()) {
            return -1;
        }
        ScriptCommandDefinition scriptCommandDefinition = this.commands.get(n);
        int n2 = scriptCommandDefinition.getStartPositionInScript();
        return n2;
    }

    public int getEndPosForCommand(int n) {
        if (n < 0) {
            return -1;
        }
        if (this.commands == null) {
            this.parseCommands();
        }
        if (n >= this.commands.size()) {
            return -1;
        }
        ScriptCommandDefinition scriptCommandDefinition = this.commands.get(n);
        return scriptCommandDefinition.getEndPositionInScript();
    }

    public int findNextLineStart(int n) {
        if (this.originalScript == null) {
            return -1;
        }
        if (n < 0) {
            return n;
        }
        int n2 = this.originalScript.length();
        if (n >= n2) {
            return n;
        }
        char c = this.originalScript.charAt(n);
        while (n < n2 && (c == '\n' || c == '\r')) {
            c = this.originalScript.charAt(++n);
        }
        return n;
    }

    public String getCommand(int n) {
        return this.getCommand(n, true);
    }

    public DelimiterDefinition getDelimiterUsed(int n) {
        ScriptCommandDefinition scriptCommandDefinition = this.getCommandDefinition(n);
        if (scriptCommandDefinition != null) {
            return scriptCommandDefinition.getDelimiterUsed();
        }
        return this.getDelimiter();
    }

    public String getCommand(int n, boolean bl) {
        ScriptCommandDefinition scriptCommandDefinition = this.getCommandDefinition(n);
        if (scriptCommandDefinition == null) {
            return null;
        }
        if (scriptCommandDefinition.getSQL() != null) {
            return scriptCommandDefinition.getSQL();
        }
        String string = this.originalScript.substring(scriptCommandDefinition.getStartPositionInScript(), scriptCommandDefinition.getEndPositionInScript());
        if (bl) {
            return StringUtil.rtrim(string);
        }
        return string;
    }

    public ScriptCommandDefinition getCommandDefinition(int n) {
        if (n < 0) {
            return null;
        }
        if (this.commands == null) {
            this.parseCommands();
        }
        if (n >= this.commands.size()) {
            return null;
        }
        return this.commands.get(n);
    }

    public int getSize() {
        if (this.commands == null) {
            this.parseCommands();
        }
        return this.commands.size();
    }

    public boolean isFullyLoaded() {
        return this.commands != null;
    }

    public void startIterator() {
        this.currentIteratorIndex = 0;
        if (this.scriptIterator == null && this.commands == null) {
            this.parseCommands();
        } else if (this.scriptIterator != null) {
            this.scriptIterator.reset();
        }
    }

    public void done() {
        if (this.scriptIterator != null) {
            this.scriptIterator.done();
        }
    }

    public void setCheckEscapedQuotes(boolean bl) {
        this.checkEscapedQuotes = bl;
    }

    public DelimiterDefinition getDelimiter() {
        if (this.useAlternateDelimiter) {
            return this.alternateDelimiter;
        }
        return this.delimiter;
    }

    public boolean supportsMixedDelimiter() {
        ScriptIterator scriptIterator = this.getParserInstance();
        return scriptIterator.supportsMixedDelimiter();
    }

    private ScriptIterator getParserInstance() {
        LexerBasedParser lexerBasedParser = new LexerBasedParser(this.parserType);
        lexerBasedParser.setCheckEscapedQuotes(this.checkEscapedQuotes);
        if (lexerBasedParser.supportsMixedDelimiter()) {
            lexerBasedParser.setDelimiter(this.delimiter);
            lexerBasedParser.setAlternateDelimiter(this.alternateDelimiter);
            lexerBasedParser.setEmptyLineIsDelimiter(this.emptyLineIsSeparator);
        } else {
            this.findDelimiterToUse();
            lexerBasedParser.setAlternateDelimiter(null);
            if (this.useAlternateDelimiter) {
                lexerBasedParser.setDelimiter(this.alternateDelimiter);
                lexerBasedParser.setEmptyLineIsDelimiter(false);
            } else {
                lexerBasedParser.setDelimiter(this.delimiter);
                lexerBasedParser.setEmptyLineIsDelimiter(this.emptyLineIsSeparator);
            }
        }
        lexerBasedParser.setReturnStartingWhitespace(this.returnLeadingWhitespace);
        return lexerBasedParser;
    }

    private void parseCommands() {
        ScriptIterator scriptIterator = null;
        boolean bl = false;
        if (this.scriptIterator == null) {
            scriptIterator = this.getParserInstance();
            scriptIterator.setScript(this.originalScript);
            scriptIterator.setStoreStatementText(false);
        } else {
            scriptIterator = this.scriptIterator;
            scriptIterator.setStoreStatementText(true);
            bl = true;
        }
        this.commands = new ArrayList<ScriptCommandDefinition>();
        ScriptCommandDefinition scriptCommandDefinition = null;
        int n = 0;
        while ((scriptCommandDefinition = scriptIterator.getNextCommand()) != null) {
            if (bl ? StringUtil.isBlank(scriptCommandDefinition.getSQL()) : this.isEmpty(scriptCommandDefinition.getStartPositionInScript(), scriptCommandDefinition.getEndPositionInScript())) continue;
            scriptCommandDefinition.setIndexInScript(n);
            ++n;
            this.commands.add(scriptCommandDefinition);
        }
        this.currentIteratorIndex = 0;
        if (this.scriptIterator != null) {
            this.scriptIterator.done();
        }
    }

    private boolean isEmpty(int n, int n2) {
        if (n < 0) {
            return true;
        }
        if (n2 < 0 || n2 < n) {
            return true;
        }
        if (this.originalScript == null) {
            return true;
        }
        for (int i = n; i < n2; ++i) {
            char c = this.originalScript.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public int getStatementCount() {
        if (this.scriptIterator != null) {
            return -1;
        }
        if (this.commands == null) {
            this.parseCommands();
        }
        return this.commands.size();
    }

    public String getNextCommand() {
        ScriptCommandDefinition scriptCommandDefinition = this.getNextCommandDefinition();
        String string = null;
        if (scriptCommandDefinition == null) {
            return null;
        }
        string = this.scriptIterator != null ? scriptCommandDefinition.getSQL() : this.originalScript.substring(scriptCommandDefinition.getStartPositionInScript(), scriptCommandDefinition.getEndPositionInScript());
        return string;
    }

    public int getLastCommandIndex() {
        if (this.scriptIterator == null) {
            return this.currentIteratorIndex - 1;
        }
        return -1;
    }

    public ScriptCommandDefinition getNextCommandDefinition() {
        ScriptCommandDefinition scriptCommandDefinition = null;
        if (this.scriptIterator != null) {
            scriptCommandDefinition = this.scriptIterator.getNextCommand();
        } else {
            if (this.commands == null) {
                this.parseCommands();
            }
            if (this.currentIteratorIndex < this.commands.size()) {
                scriptCommandDefinition = this.commands.get(this.currentIteratorIndex);
                ++this.currentIteratorIndex;
            }
        }
        return scriptCommandDefinition;
    }

    public static ScriptParser createScriptParser(WbConnection wbConnection) {
        ScriptParser scriptParser = new ScriptParser(ParserType.getTypeFromConnection(wbConnection));
        scriptParser.setAlternateDelimiter(Settings.getInstance().getAlternateDelimiter(wbConnection, null));
        scriptParser.setCheckEscapedQuotes(Settings.getInstance().useNonStandardQuoteEscaping(wbConnection));
        scriptParser.setEmptyLineIsDelimiter(Settings.getInstance().getEmptyLineIsDelimiter());
        return scriptParser;
    }
}

