/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.parser;

import java.util.ArrayList;
import java.util.Set;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLToken;
import workbench.util.CollectionUtil;

public class SelectExtractor {
    private final String originalSQL;
    private final int cursorPos;
    private int startPos = -1;
    private int endPos = -1;
    private SQLLexer lexer;

    public SelectExtractor(SQLLexer sQLLexer, String string, int n) {
        this.originalSQL = string;
        this.cursorPos = n;
        this.lexer = sQLLexer;
        this.parseSQL();
    }

    private void parseSQL() {
        Set<String> set = CollectionUtil.caseInsensitiveSet("UNION", "UNION ALL", "MINUS", "INTERSECT", "EXCEPT", "EXCEPT ALL");
        this.startPos = -1;
        this.endPos = -1;
        try {
            boolean bl;
            this.lexer.setInput(this.originalSQL);
            SQLToken sQLToken = this.lexer.getNextToken(false, false);
            if (sQLToken == null) {
                return;
            }
            SQLToken sQLToken2 = null;
            int n = 0;
            int n2 = 0;
            String string = sQLToken.getContents();
            ArrayList<SQLToken> arrayList = new ArrayList<SQLToken>();
            int n3 = 0;
            boolean bl2 = false;
            boolean bl3 = bl = string.equals("INSERT") || string.equals("CREATE") || string.equals("CREATE OR REPLACE");
            while (sQLToken != null) {
                String string2 = sQLToken.getContents();
                if ("(".equals(string2)) {
                    if (++n3 == 1) {
                        n = sQLToken.getCharBegin();
                    }
                } else if (")".equals(string2)) {
                    if (bl2 && --n3 == 0) {
                        n2 = sQLToken.getCharBegin();
                        if (n <= this.cursorPos && this.cursorPos <= n2) {
                            this.startPos = n + 1;
                            this.endPos = n2;
                            return;
                        }
                    }
                    if (n3 == 0) {
                        bl2 = false;
                        n = 0;
                        n2 = 0;
                    }
                } else if (n3 == 0 && bl && string2.equals("SELECT")) {
                    if (this.cursorPos >= sQLToken.getCharBegin()) {
                        this.startPos = sQLToken.getCharBegin();
                        return;
                    }
                } else if (n3 == 0 && set.contains(string2)) {
                    arrayList.add(sQLToken);
                }
                if (n3 == 1 && sQLToken2 != null && sQLToken2.getContents().equals("(") && string2.equals("SELECT")) {
                    bl2 = true;
                }
                sQLToken2 = sQLToken;
                sQLToken = this.lexer.getNextToken(false, false);
            }
            if (arrayList.size() > 0) {
                int n4;
                int n5 = 0;
                for (int i = 0; i < arrayList.size(); ++i) {
                    n4 = ((SQLToken)arrayList.get(i)).getCharBegin();
                    if (n5 <= this.cursorPos && this.cursorPos <= n4) {
                        this.endPos = n2;
                        this.startPos = n + 1;
                        return;
                    }
                    n5 = this.startPos;
                }
                n4 = ((SQLToken)arrayList.get(arrayList.size() - 1)).getCharEnd();
                if (this.cursorPos >= n4) {
                    this.startPos = n4;
                    this.endPos = -1;
                }
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when checking sub-select", exception);
        }
    }

    public int getRealSelectStart() {
        return this.startPos;
    }

    public int getRealSelectEnd() {
        return this.endPos;
    }

    public int getRelativeCursorPosition() {
        if (this.startPos > -1) {
            return this.cursorPos - this.startPos - 1;
        }
        return this.cursorPos;
    }

    public String getRealQuery() {
        if (this.startPos > -1 && this.endPos > -1) {
            return this.originalSQL.substring(this.startPos, this.endPos);
        }
        if (this.startPos > -1) {
            return this.originalSQL.substring(this.startPos);
        }
        return this.originalSQL;
    }
}

