/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.resource.ResourceMgr;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommandLineConnectionHandler;
import workbench.sql.wbcommands.CommonArgs;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.storage.RowActionMonitor;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class CommonDiffParameters {
    public static final String PARAM_SOURCEPROFILE = "referenceProfile";
    public static final String PARAM_SOURCEPROFILE_GROUP = "referenceGroup";
    public static final String PARAM_SOURCE_CONN = "referenceConnection";
    public static final String PARAM_TARGETPROFILE = "targetProfile";
    public static final String PARAM_TARGETPROFILE_GROUP = "targetGroup";
    public static final String PARAM_TARGET_CONN = "targetConnection";
    public static final String PARAM_REFERENCETABLES = "referenceTables";
    public static final String PARAM_TARGETTABLES = "targetTables";
    public static final String PARAM_REFERENCESCHEMA = "referenceSchema";
    public static final String PARAM_TARGETSCHEMA = "targetSchema";
    public static final String PARAM_EXCLUDE_TABLES = "excludeTables";
    public static final String PARAM_INCLUDE_TABLES = "includeTables";
    private RowActionMonitor monitor;
    private ArgumentParser cmdLine;
    private List<String> missingRefTables = new ArrayList<String>();
    private List<String> missingTargetTables = new ArrayList<String>();
    private String baseDir;
    private boolean ignoreMissing;

    public CommonDiffParameters(ArgumentParser argumentParser) {
        this(argumentParser, null);
    }

    public CommonDiffParameters(ArgumentParser argumentParser, String string) {
        this.cmdLine = argumentParser;
        this.baseDir = string;
        this.cmdLine.addArgument(PARAM_SOURCEPROFILE, ArgumentType.ProfileArgument);
        this.cmdLine.addArgument(PARAM_SOURCEPROFILE_GROUP);
        this.cmdLine.addArgument(PARAM_SOURCE_CONN);
        this.cmdLine.addArgument(PARAM_TARGETPROFILE, ArgumentType.ProfileArgument);
        this.cmdLine.addArgument(PARAM_TARGETPROFILE_GROUP);
        this.cmdLine.addArgument(PARAM_TARGET_CONN);
        this.cmdLine.addArgument("file");
        CommonArgs.addEncodingParameter(this.cmdLine);
        this.cmdLine.addArgument(PARAM_REFERENCETABLES, ArgumentType.TableArgument);
        this.cmdLine.addArgument(PARAM_TARGETTABLES, ArgumentType.TableArgument);
        this.cmdLine.addArgument(PARAM_REFERENCESCHEMA);
        this.cmdLine.addArgument(PARAM_TARGETSCHEMA);
        this.cmdLine.addArgument(PARAM_EXCLUDE_TABLES);
        this.cmdLine.addArgument(PARAM_INCLUDE_TABLES);
    }

    public void setIgnoreMissing(boolean bl) {
        this.ignoreMissing = bl;
    }

    public void setMonitor(RowActionMonitor rowActionMonitor) {
        this.monitor = rowActionMonitor;
    }

    public WbConnection getTargetConnection(WbConnection wbConnection, StatementRunnerResult statementRunnerResult) {
        return this.getConnection(PARAM_TARGETPROFILE, PARAM_TARGETPROFILE_GROUP, PARAM_TARGET_CONN, wbConnection, "Target", statementRunnerResult);
    }

    public WbConnection getSourceConnection(WbConnection wbConnection, StatementRunnerResult statementRunnerResult) {
        return this.getConnection(PARAM_SOURCEPROFILE, PARAM_SOURCEPROFILE_GROUP, PARAM_SOURCE_CONN, wbConnection, "Source", statementRunnerResult);
    }

    protected WbConnection getConnection(String string, String string2, String string3, WbConnection wbConnection, String string4, StatementRunnerResult statementRunnerResult) {
        CommandLineConnectionHandler commandLineConnectionHandler = new CommandLineConnectionHandler(this.cmdLine, string, string2, string3);
        WbConnection wbConnection2 = null;
        try {
            if (this.monitor != null) {
                this.monitor.setCurrentObject(ResourceMgr.getString("MsgDiffConnecting" + string4), -1L, -1L);
            }
            wbConnection2 = commandLineConnectionHandler.getConnection(statementRunnerResult, wbConnection, this.baseDir, "Wb-Diff-" + string4);
        }
        catch (Exception exception) {
            statementRunnerResult.addErrorMessage(ResourceMgr.getString("ErrDiffCouldNotConnect" + string4));
        }
        return wbConnection2;
    }

    public TableMapping getTables(WbConnection wbConnection, WbConnection wbConnection2) throws SQLException {
        boolean bl;
        TableMapping tableMapping = new TableMapping();
        List<TableIdentifier> list = null;
        List<TableIdentifier> list2 = null;
        this.missingRefTables.clear();
        this.missingTargetTables.clear();
        String string = this.cmdLine.getValue(PARAM_EXCLUDE_TABLES);
        String string2 = this.cmdLine.getValue(PARAM_INCLUDE_TABLES);
        String string3 = this.cmdLine.getValue(PARAM_REFERENCETABLES);
        String string4 = this.cmdLine.getValue(PARAM_TARGETTABLES);
        String string5 = this.cmdLine.getValue(PARAM_REFERENCESCHEMA);
        String string6 = this.cmdLine.getValue(PARAM_TARGETSCHEMA);
        if (StringUtil.isEmptyString(string3) && StringUtil.isEmptyString(string5)) {
            string5 = wbConnection.getCurrentSchema();
        } else if (StringUtil.isNonEmpty(string5)) {
            string5 = wbConnection.getMetadata().adjustSchemaNameCase(string5);
        }
        String[] stringArray = wbConnection.getMetadata().getTableTypesArray();
        SourceTableArgument sourceTableArgument = new SourceTableArgument(string3, string, string5, stringArray, wbConnection);
        list = sourceTableArgument.getTables();
        this.missingRefTables.addAll(sourceTableArgument.getMissingTables());
        if (StringUtil.isNonBlank(string2)) {
            SourceTableArgument sourceTableArgument2 = new SourceTableArgument(string2, null, string5, stringArray, wbConnection);
            list.addAll(sourceTableArgument2.getTables());
        }
        boolean bl2 = bl = this.getSchemas(list).size() > 1 || this.getCatalogs(list2).size() > 1;
        if (bl && StringUtil.isEmptyString(string4) && StringUtil.isEmptyString(string6)) {
            string4 = string3;
            string6 = null;
        } else if (StringUtil.isEmptyString(string4) && StringUtil.isEmptyString(string6)) {
            string6 = wbConnection2.getDbSettings().supportsSchemas() ? wbConnection2.getCurrentSchema() : wbConnection2.getCurrentCatalog();
        } else if (StringUtil.isNonEmpty(string6)) {
            string6 = wbConnection2.getMetadata().adjustSchemaNameCase(string6);
        }
        if (StringUtil.isEmptyString(string6) && StringUtil.isEmptyString(string4)) {
            string4 = string3;
        }
        stringArray = wbConnection2.getMetadata().getTableTypesArray();
        SourceTableArgument sourceTableArgument3 = new SourceTableArgument(string4, null, string6, stringArray, wbConnection2);
        list2 = sourceTableArgument3.getTables();
        this.missingTargetTables.addAll(sourceTableArgument3.getMissingTables());
        boolean bl3 = true;
        if (StringUtil.isNonEmpty(string3) && StringUtil.isNonEmpty(string4) && !sourceTableArgument.wasWildcardArgument()) {
            bl3 = false;
        }
        int n = 0;
        for (TableIdentifier tableIdentifier : list) {
            if (bl3) {
                TableIdentifier tableIdentifier2 = null;
                tableIdentifier2 = bl ? TableIdentifier.findTableByNameAndSchema(list2, tableIdentifier) : TableIdentifier.findTableByName(list2, tableIdentifier);
                if (tableIdentifier2 == null && !this.ignoreMissing) continue;
                tableMapping.referenceTables.add(tableIdentifier);
                tableMapping.targetTables.add(tableIdentifier2);
                continue;
            }
            if (n >= list2.size()) continue;
            tableMapping.referenceTables.add(tableIdentifier);
            tableMapping.targetTables.add(list2.get(n));
            ++n;
        }
        return tableMapping;
    }

    private Set<String> getCatalogs(List<TableIdentifier> list) {
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        if (CollectionUtil.isEmpty(list)) {
            return set;
        }
        for (TableIdentifier tableIdentifier : list) {
            if (tableIdentifier.getCatalog() == null) continue;
            set.add(tableIdentifier.getCatalog());
        }
        return set;
    }

    public Set<String> getSchemas(List<TableIdentifier> list) {
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        if (CollectionUtil.isEmpty(list)) {
            return set;
        }
        for (TableIdentifier tableIdentifier : list) {
            if (tableIdentifier == null || tableIdentifier.getSchema() == null) continue;
            set.add(tableIdentifier.getSchema());
        }
        return set;
    }

    public List<String> getMissingReferenceTables() {
        return this.missingRefTables;
    }

    public List<String> getMissingTargetTables() {
        return this.missingTargetTables;
    }

    public static class TableMapping {
        public final List<TableIdentifier> referenceTables = new ArrayList<TableIdentifier>();
        public final List<TableIdentifier> targetTables = new ArrayList<TableIdentifier>();

        public String toString() {
            return "reference: " + this.referenceTables.toString() + "\ntarget: " + this.targetTables.toString();
        }
    }
}

