/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.importer.modifier.ImportValueModifier;
import workbench.db.importer.modifier.RegexModifier;
import workbench.db.importer.modifier.SubstringModifier;
import workbench.db.importer.modifier.ValueFilter;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.StringUtil;

public class ModifierArguments {
    public static final String ARG_SUBSTRING = "colSubstring";
    public static final String ARG_REGEX = "colReplacement";
    public static final String ARG_MAXLENGTH = "maxLength";
    private SubstringModifier substring = new SubstringModifier();
    private RegexModifier regex = new RegexModifier();

    public static void addArguments(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_REGEX);
        argumentParser.addArgument(ARG_SUBSTRING, ArgumentType.Repeatable);
        argumentParser.addArgument(ARG_MAXLENGTH);
    }

    public ModifierArguments(ArgumentParser argumentParser) throws NumberFormatException {
        String string = argumentParser.getValue(ARG_MAXLENGTH);
        this.parseSubstring(string);
        string = argumentParser.getValue(ARG_SUBSTRING);
        this.parseSubstring(string);
        string = argumentParser.getValue(ARG_REGEX);
        this.parseRegex(string);
    }

    private void parseRegex(String string) {
        if (string == null) {
            return;
        }
        List<String> list = StringUtil.stringToList(string, ",", true, true, false);
        if (list.isEmpty()) {
            return;
        }
        for (String string2 : list) {
            String[] stringArray = string2.split("=");
            if (stringArray.length != 2 || stringArray[0] == null || stringArray[1] == null) continue;
            ColumnIdentifier columnIdentifier = new ColumnIdentifier(stringArray[0]);
            String[] stringArray2 = stringArray[1].split(":");
            String string3 = null;
            String string4 = "";
            if (stringArray2.length == 1) {
                string3 = stringArray2[0].trim();
            } else if (stringArray2.length == 2) {
                string3 = stringArray2[0].trim();
                string4 = stringArray2[1].trim();
            }
            this.regex.addDefinition(columnIdentifier, string3, string4);
        }
    }

    private void parseSubstring(String string) throws NumberFormatException {
        if (string == null) {
            return;
        }
        List<String> list = StringUtil.stringToList(string, ",", true, true, false);
        if (list.isEmpty()) {
            return;
        }
        for (String string2 : list) {
            String[] stringArray = string2.split("=");
            if (stringArray.length != 2 || stringArray[0] == null || stringArray[1] == null) continue;
            ColumnIdentifier columnIdentifier = new ColumnIdentifier(stringArray[0]);
            String[] stringArray2 = stringArray[1].split(":");
            int n = 0;
            int n2 = 0;
            if (stringArray2.length == 1) {
                n2 = Integer.parseInt(stringArray2[0].trim());
            } else if (stringArray2.length == 2) {
                n = Integer.parseInt(stringArray2[0].trim());
                n2 = Integer.parseInt(stringArray2[1].trim());
            }
            this.substring.addDefinition(columnIdentifier, n, n2);
        }
    }

    SubstringModifier getSubstringModifier() {
        return this.substring;
    }

    RegexModifier getRegexModifier() {
        return this.regex;
    }

    public ImportValueModifier getModifier() {
        ValueFilter valueFilter = new ValueFilter();
        if (this.substring.getSize() > 0) {
            valueFilter.addColumnModifier(this.substring);
        }
        if (this.regex.getSize() > 0) {
            valueFilter.addColumnModifier(this.regex);
        }
        if (valueFilter.getSize() > 0) {
            return valueFilter;
        }
        return null;
    }
}

