/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.List;
import workbench.db.DbObject;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.storage.DataStore;

public class ObjectResultListDataStore
extends DataStore {
    public static final int COL_IDX_OBJECT_NAME = 0;
    public static final int COL_IDX_OBJECT_TYPE = 1;
    public static final int COL_IDX_SOURCE = 2;
    private static final String[] colnames = new String[]{"NAME", "TYPE", "SOURCE"};
    private static final int[] colTypes = new int[]{12, 12, 2005};
    private static final int[] colSizes = new int[]{30, 30, 50};

    public ObjectResultListDataStore() {
        super(colnames, colTypes, colSizes);
    }

    public ObjectResultListDataStore(WbConnection wbConnection, List<DbObject> list, boolean bl) throws SQLException {
        super(colnames, colTypes, colSizes);
        this.setResultList(wbConnection, list, bl);
    }

    public final void setResultList(WbConnection wbConnection, List<DbObject> list, boolean bl) throws SQLException {
        if (list == null) {
            return;
        }
        for (DbObject dbObject : list) {
            ProcedureDefinition procedureDefinition;
            int n = this.addRow();
            String string = null;
            String string2 = dbObject.getObjectType();
            string = bl ? dbObject.getFullyQualifiedName(wbConnection) : dbObject.getObjectName();
            if (dbObject instanceof ProcedureDefinition && (procedureDefinition = (ProcedureDefinition)dbObject).isPackageProcedure()) {
                string = procedureDefinition.getPackageName();
                string2 = "PACKAGE";
            }
            this.setValue(n, 0, (Object)string);
            this.setValue(n, 1, (Object)string2);
            this.setValue(n, 2, (Object)dbObject.getSource(wbConnection));
        }
        this.resetStatus();
    }
}

