/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.WbManager;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.WbConnection;
import workbench.gui.profiles.ProfileKey;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.BatchRunner;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.ExceptionUtil;
import workbench.util.GlobalPasswordManager;
import workbench.util.StringUtil;

public class WbConnect
extends SqlCommand {
    private static int connectionId;
    private boolean persistentChange = false;
    public static final String VERB = "WbConnect";

    public WbConnect() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("profile", ArgumentType.ProfileArgument);
        this.cmdLine.addArgument("profilegroup");
        this.cmdLine.addArgument("url");
        this.cmdLine.addArgument("driver");
        this.cmdLine.addArgument("driverclass");
        this.cmdLine.addArgument("driverjar");
        this.cmdLine.addArgument("username");
        this.cmdLine.addArgument("password");
        this.cmdLine.addArgument("fetchSize");
        this.cmdLine.addArgument("autocommit", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("rollbackOnDisconnect", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("trimCharData", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("ignoreDropErrors", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("connection");
        this.cmdLine.addArgument("altDelimiter");
        this.cmdLine.addArgument("restore", ArgumentType.BoolSwitch);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    public void setPersistentChange(boolean bl) {
        this.persistentChange = bl;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        Object object;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        statementRunnerResult.setFailure();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        ConnectionProfile connectionProfile = null;
        String string3 = null;
        if (this.cmdLine.isArgPresent("restore")) {
            this.runner.restoreMainConnection();
            statementRunnerResult.addMessageByKey("MsgConnectedTo", this.runner.getConnection().getDisplayString());
            statementRunnerResult.setSuccess();
            return statementRunnerResult;
        }
        string3 = this.cmdLine.getArgumentCount() == 0 ? StringUtil.trimQuotes(string2) : this.cmdLine.getValue("profile");
        if (StringUtil.isEmptyString(string3)) {
            connectionProfile = BatchRunner.createCmdLineProfile(this.cmdLine, this.currentConnection, this.getBaseDir());
        } else {
            object = this.cmdLine.getValue("profilegroup");
            connectionProfile = ConnectionMgr.getInstance().getProfile(new ProfileKey(string3, (String)object));
        }
        if (connectionProfile == null) {
            statementRunnerResult.addMessageByKey("ErrConnNoArgs");
            return statementRunnerResult;
        }
        if (!GlobalPasswordManager.getInstance().showPasswordPromptIfNeeded()) {
            statementRunnerResult.setFailure();
            return statementRunnerResult;
        }
        BatchRunner.loginPrompt(connectionProfile, this.runner.getExecutionController());
        object = null;
        try {
            String string4;
            String string5 = null;
            string5 = WbManager.getInstance().isConsoleMode() ? "Console-" + connectionId : "batch-connect-" + ++connectionId;
            WbConnection wbConnection = null;
            if (this.persistentChange) {
                wbConnection = this.runner.getConnection();
            }
            object = ConnectionMgr.getInstance().getConnection(connectionProfile, string5);
            LogMgr.logInfo(new CallerInfo(){}, "Connected to: " + ((WbConnection)object).getDisplayString());
            if (this.persistentChange) {
                if (wbConnection != null && wbConnection != object) {
                    wbConnection.disconnect();
                }
                this.runner.setConnection((WbConnection)object);
            } else {
                this.runner.changeConnection((WbConnection)object);
            }
            statementRunnerResult.addMessageByKey("MsgBatchConnectOk", ((WbConnection)object).getDisplayString());
            String string6 = string4 = object != null ? ((WbConnection)object).getWarnings() : null;
            if (string4 != null) {
                statementRunnerResult.addMessage(string4);
            }
            statementRunnerResult.setSuccess();
        }
        catch (Exception exception) {
            String string7 = ExceptionUtil.getDisplay(exception);
            statementRunnerResult.addErrorMessage(string7);
        }
        finally {
            if (!connectionProfile.getStorePassword()) {
                connectionProfile.setInputPassword(null);
            }
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

