/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.VariablePool;
import workbench.sql.wbcommands.CommonArgs;
import workbench.sql.wbcommands.ConditionCheck;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.EncodingUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;
import workbench.util.WbStringTokenizer;

public class WbDefineVar
extends SqlCommand {
    public static final String VERB = "WbVarDef";
    public static final String ALTERNATE_VERB = "WbDefineVar";
    public static final String ARG_LOOKUP_VALUES = "values";
    public static final String ARG_REMOVE_UNDEFINED = "removeUndefined";
    public static final String ARG_REPLACE_VARS = "replaceVars";
    public static final String ARG_VAR_NAME = "variable";
    public static final String ARG_VAR_VALUE = "value";
    public static final String ARG_CONTENT_FILE = "contentFile";
    public static final String ARG_CLEANUP_VALUE = "cleanupValue";
    public static final String ARG_SILENT = "silent";
    public static final String ARG_QUERY = "query";
    public static final String ARG_NULL_HANDLING = "nullHandling";

    public WbDefineVar() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("file", ArgumentType.Filename);
        this.cmdLine.addArgument(ARG_CONTENT_FILE, ArgumentType.StringArgument);
        this.cmdLine.addArgument(ARG_VAR_NAME);
        this.cmdLine.addArgument(ARG_VAR_VALUE);
        this.cmdLine.addArgument(ARG_REPLACE_VARS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_REMOVE_UNDEFINED, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_CLEANUP_VALUE, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_SILENT, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_LOOKUP_VALUES);
        this.cmdLine.addArgument(ARG_QUERY);
        this.cmdLine.addArgument(ARG_NULL_HANDLING, NullVarHandling.class);
        CommonArgs.addEncodingParameter(this.cmdLine);
        ConditionCheck.addParameters(this.cmdLine);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public String getAlternateVerb() {
        return ALTERNATE_VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        List<String> list;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        if (!this.checkConditions(statementRunnerResult)) {
            return statementRunnerResult;
        }
        WbFile wbFile = this.evaluateFileArgument(this.cmdLine.getValue("file"));
        WbFile wbFile2 = this.evaluateFileArgument(this.cmdLine.getValue(ARG_CONTENT_FILE));
        boolean bl = this.cmdLine.getBoolean(ARG_SILENT);
        boolean bl2 = this.cmdLine.getBoolean(ARG_REMOVE_UNDEFINED);
        String string3 = this.cmdLine.hasArguments() ? this.cmdLine.getNonArguments() : string2;
        if (wbFile != null && wbFile2 != null) {
            statementRunnerResult.addErrorMessageByKey("ErrVarFileWrong");
            return statementRunnerResult;
        }
        if (wbFile != null) {
            this.initFromFile(statementRunnerResult, wbFile);
            return statementRunnerResult;
        }
        if (wbFile2 != null) {
            this.readFileContents(statementRunnerResult, wbFile2, bl);
            return statementRunnerResult;
        }
        String string4 = null;
        List<String> list2 = null;
        String string5 = null;
        boolean bl3 = false;
        if (this.cmdLine.isArgPresent(ARG_VAR_NAME)) {
            string5 = this.cmdLine.getValue(ARG_VAR_NAME);
            list2 = StringUtil.stringToList(string5, ",", true, true);
        }
        if (this.cmdLine.isArgPresent(ARG_VAR_NAME) && this.cmdLine.isArgPresent(ARG_LOOKUP_VALUES)) {
            list = this.cmdLine.getListValue(ARG_LOOKUP_VALUES);
            if (CollectionUtil.isNonEmpty(list) && StringUtil.isNonEmpty(string5)) {
                LogMgr.logDebug(new CallerInfo(){}, "Lookup values for variable " + string5 + ": " + list);
                VariablePool.getInstance().setLookupValues(string5, list);
            }
            bl3 = true;
        }
        if (this.cmdLine.isArgPresent(ARG_VAR_VALUE)) {
            string4 = this.cmdLine.getValue(ARG_VAR_VALUE);
        } else if (!this.cmdLine.isArgPresent(ARG_VAR_NAME)) {
            list = new WbStringTokenizer("=", true, "\"'", false);
            ((WbStringTokenizer)((Object)list)).setSourceString(string3);
            ((WbStringTokenizer)((Object)list)).setKeepQuotes(true);
            if (((WbStringTokenizer)((Object)list)).hasMoreTokens()) {
                string5 = ((WbStringTokenizer)((Object)list)).nextToken();
            }
            list2 = StringUtil.stringToList(string5, ",", true, true);
            if (((WbStringTokenizer)((Object)list)).hasMoreTokens()) {
                string4 = ((WbStringTokenizer)((Object)list)).nextToken();
            }
        }
        if (CollectionUtil.isEmpty(list2)) {
            statementRunnerResult.addErrorMessageByKey("ErrVarDefWrongParameter");
            return statementRunnerResult;
        }
        if (bl3 && string4 == null) {
            string4 = "";
        }
        if (string4 != null) {
            string4 = StringUtil.trimQuotes(string4.trim());
        }
        statementRunnerResult.setSuccess();
        list = StringUtil.trimToNull(StringUtil.trimQuotes(this.cmdLine.getValue(ARG_QUERY)));
        if (list == null) {
            list = this.getQueryFromValue(string4);
        }
        NullVarHandling nullVarHandling = this.cmdLine.getEnumValue(ARG_NULL_HANDLING, this.getNullVarHandling());
        if (string4 == null && list == null) {
            for (String string6 : list2) {
                VariablePool.getInstance().removeVariable(string6);
                String string7 = ResourceMgr.getFormattedString("MsgVarRemoved", string6);
                statementRunnerResult.addMessage(string7);
            }
        } else if (list != null) {
            this.readValuesFromDatabase(statementRunnerResult, list2, (String)((Object)list), bl, nullVarHandling);
        } else {
            boolean bl4 = this.cmdLine.getBoolean(ARG_CLEANUP_VALUE, Settings.getInstance().getCleanupVariableValues());
            if (bl4) {
                string4 = SqlUtil.makeCleanSql(string4, false, false, true, this.currentConnection);
            }
            if (bl2) {
                string4 = VariablePool.getInstance().removeVariables(string4);
            }
            if (list2.size() > 1) {
                LogMgr.logWarning(new CallerInfo(){}, "Multiple variables not supported when assigning constant values. Statement was: " + string2);
            }
            string5 = list2.get(0).trim();
            this.setVariable(statementRunnerResult, string5, string4, bl, nullVarHandling);
            if (statementRunnerResult.isSuccess() && !bl) {
                String string8 = ResourceMgr.getString("MsgVarDefVariableDefined");
                string8 = StringUtil.replace(string8, "%var%", string5);
                string8 = StringUtil.replace(string8, "%value%", string4);
                string8 = StringUtil.replace(string8, "%varname%", VariablePool.getInstance().buildVarName(string5, false));
                statementRunnerResult.addMessage(string8);
            }
        }
        return statementRunnerResult;
    }

    private String getQueryFromValue(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).startsWith("@")) {
            return StringUtil.trimQuotes(string.substring(1));
        }
        return null;
    }

    private void readValuesFromDatabase(StatementRunnerResult statementRunnerResult, List<String> list, String string, boolean bl, NullVarHandling nullVarHandling) {
        try {
            List<String> list2 = this.evaluateSql(this.currentConnection, string, statementRunnerResult);
            int n = Math.min(list2.size(), list.size());
            if (list2.size() != list.size()) {
                LogMgr.logWarning(new CallerInfo(){}, "The number of variables does not match the number of columns returned. Using only the first " + n + " variables");
            }
            for (int i = 0; i < n; ++i) {
                this.setVariable(statementRunnerResult, list.get(i), list2.get(i), bl, nullVarHandling);
                if (bl || !statementRunnerResult.isSuccess()) continue;
                String string2 = ResourceMgr.getString("MsgVarDefVariableDefined");
                string2 = StringUtil.replace(string2, "%var%", list.get(i));
                string2 = StringUtil.replace(string2, "%value%", list2.get(i));
                string2 = StringUtil.replace(string2, "%varname%", VariablePool.getInstance().buildVarName(list.get(i), false));
                statementRunnerResult.addMessage(string2);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving variable value using SQL: " + string, exception);
            String string3 = ResourceMgr.getString("ErrReadingVarSql");
            string3 = StringUtil.replace(string3, "%sql%", string);
            string3 = string3 + "\n\n" + ExceptionUtil.getDisplay(exception);
            statementRunnerResult.addErrorMessage(string3);
        }
    }

    private void initFromFile(StatementRunnerResult statementRunnerResult, WbFile wbFile) {
        String string = this.cmdLine.getValue("encoding");
        try {
            if (wbFile.exists()) {
                VariablePool.getInstance().readFromFile(wbFile.getFullPath(), string, false);
                String string2 = ResourceMgr.getFormattedString("MsgVarDefFileLoaded", wbFile.getFullPath());
                statementRunnerResult.addMessage(string2);
                statementRunnerResult.setSuccess();
            } else {
                String string3 = ResourceMgr.getFormattedString("ErrFileNotFound", wbFile.getFullPath());
                statementRunnerResult.addErrorMessage(string3);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error reading definition file: " + wbFile.getFullPath(), exception);
            String string4 = ResourceMgr.getString("ErrReadingVarDefFile");
            string4 = StringUtil.replace(string4, "%file%", wbFile.getAbsolutePath());
            string4 = string4 + " " + ExceptionUtil.getDisplay(exception);
            statementRunnerResult.addErrorMessage(string4);
        }
    }

    private void setVariable(StatementRunnerResult statementRunnerResult, String string, String string2, boolean bl, NullVarHandling nullVarHandling) {
        try {
            if (string2 == null) {
                switch (nullVarHandling) {
                    case empty: {
                        VariablePool.getInstance().setParameterValue(string, "");
                        break;
                    }
                    case remove: {
                        VariablePool.getInstance().removeVariable(string);
                        if (bl) break;
                        statementRunnerResult.addMessage(ResourceMgr.getFormattedString("MsgVarRemoved", string));
                    }
                }
            } else {
                VariablePool.getInstance().setParameterValue(string, string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            statementRunnerResult.addErrorMessageByKey("ErrVarDefWrongName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> evaluateSql(WbConnection wbConnection, String string, StatementRunnerResult statementRunnerResult) throws SQLException {
        ResultSet resultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        if (wbConnection == null) {
            throw new SQLException("Cannot evaluate SQL based variable without a connection");
        }
        try {
            this.currentStatement = wbConnection.createStatement();
            if (string.endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
            resultSet = this.currentStatement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            if (resultSet.next()) {
                for (int i = 1; i <= n; ++i) {
                    Object object = resultSet.getObject(i);
                    arrayList.add(object == null ? null : object.toString());
                }
            }
            if (resultSet.next()) {
                statementRunnerResult.addWarningByKey("ErrVarDefRows");
            }
            if (statementRunnerResult.hasWarning()) {
                statementRunnerResult.addMessageNewLine();
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResult(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResult(resultSet);
        return arrayList;
    }

    private void readFileContents(StatementRunnerResult statementRunnerResult, WbFile wbFile, boolean bl) {
        String string = this.cmdLine.getValue(ARG_VAR_NAME);
        if (StringUtil.isBlank(string)) {
            statementRunnerResult.addMessageByKey("ErrVarNoName");
            statementRunnerResult.setFailure();
            return;
        }
        boolean bl2 = this.cmdLine.getBoolean(ARG_REPLACE_VARS, true);
        String string2 = this.cmdLine.getValue("encoding");
        if (string2 == null) {
            string2 = EncodingUtil.getDefaultEncoding();
        }
        try {
            String string3 = FileUtil.readFile(wbFile, string2);
            if (bl2) {
                string3 = VariablePool.getInstance().replaceAllParameters(string3);
            }
            this.setVariable(statementRunnerResult, string, string3, bl, this.getNullVarHandling());
            String string4 = ResourceMgr.getFormattedString("MsgVarReadFile", string, wbFile.getFullPath());
            statementRunnerResult.addMessage(string4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogMgr.logError(new CallerInfo(){}, "Content file " + wbFile.getFullPath() + " not found!", fileNotFoundException);
            statementRunnerResult.addErrorMessageByKey("ErrFileNotFound", wbFile.getFullPath());
        }
        catch (IOException iOException) {
            statementRunnerResult.addErrorMessage(ExceptionUtil.getDisplay(iOException));
        }
    }

    private NullVarHandling getNullVarHandling() {
        String string = Settings.getInstance().getProperty("workbench.sql.parameter.values.nullhandling", "empty");
        try {
            return NullVarHandling.valueOf(string.toLowerCase());
        }
        catch (Throwable throwable) {
            return NullVarHandling.empty;
        }
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }

    private static enum NullVarHandling {
        ignore,
        remove,
        empty;

    }
}

