/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.WbManager;
import workbench.db.importer.detector.SpreadSheetTableDetector;
import workbench.db.importer.detector.TableDetector;
import workbench.db.importer.detector.TextFileTableDetector;
import workbench.gui.dbobjects.RunScriptPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.BatchRunner;
import workbench.sql.ErrorReportLevel;
import workbench.sql.ExecutionStatus;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommonArgs;
import workbench.sql.wbcommands.StringResultLogger;
import workbench.sql.wbcommands.WbImport;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.QuoteEscapeType;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbGenImpTable
extends SqlCommand {
    public static final String VERB = "WbGenerateImpTable";
    public static final String VERB_SHORT = "WbGenImpTable";
    public static final String ARG_SAMPLE_SIZE = "lines";
    public static final String ARG_RUN_SCRIPT = "runScript";
    public static final String ARG_DO_PROMPT = "prompt";
    public static final String ARG_CLIPBOARD = "clipboard";
    public static final String ARG_ALL_VARCHAR = "useVarchar";
    private List<String> supportedTypes = new ArrayList<String>(4);

    public WbGenImpTable() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.supportedTypes = CollectionUtil.arrayList("text");
        this.supportedTypes.addAll(WbImport.getSupportedSpreadSheetTypes());
        this.cmdLine.addArgument("file", ArgumentType.Filename);
        this.cmdLine.addArgument("type", this.supportedTypes);
        this.cmdLine.addArgument("quotechar");
        this.cmdLine.addArgument("delimiter");
        this.cmdLine.addArgument("header", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_ALL_VARCHAR, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument("sheetNumber");
        CommonArgs.addDelimiterParameter(this.cmdLine);
        CommonArgs.addEncodingParameter(this.cmdLine);
        this.cmdLine.addArgument("dateFormat");
        this.cmdLine.addArgument("timestampFormat");
        this.cmdLine.addArgument("table");
        this.cmdLine.addArgument("decimal");
        this.cmdLine.addArgument(ARG_SAMPLE_SIZE);
        this.cmdLine.addArgument(ARG_RUN_SCRIPT, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_DO_PROMPT, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_CLIPBOARD, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument("multiLine", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("outputFile", ArgumentType.Filename);
        CommonArgs.addQuoteEscaping(this.cmdLine);
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        statementRunnerResult.setFailure();
        this.cmdLine.parse(this.getCommandLine(string));
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        String string2 = this.cmdLine.getValue("file");
        if (StringUtil.isBlank(string2)) {
            statementRunnerResult.addErrorMessageByKey("ErrInputFileRqd");
            return statementRunnerResult;
        }
        List<WbFile> list = this.evaluateWildcardFileArgs(string2);
        if (list.isEmpty()) {
            statementRunnerResult.addErrorMessageByKey("ErrFileNotFound", this.cmdLine.getValue("file"));
            return statementRunnerResult;
        }
        String string3 = "";
        try {
            Object object;
            Object object2;
            statementRunnerResult.setSuccess();
            int n = 0;
            for (WbFile wbFile : list) {
                object2 = this.processOneFile(wbFile, statementRunnerResult);
                if (object2 == null) continue;
                if (n > 0) {
                    string3 = string3 + "\n\n";
                }
                string3 = string3 + (String)object2;
                ++n;
            }
            boolean bl = this.cmdLine.getBoolean(ARG_RUN_SCRIPT, false);
            boolean bl2 = true;
            object2 = this.evaluateFileArgument(this.cmdLine.getValue("outputFile"));
            if (object2 != null) {
                try {
                    FileUtil.writeString((File)object2, string3, false);
                    object = ResourceMgr.getFormattedString("MsgScriptWritten", ((WbFile)object2).getFullPath());
                    statementRunnerResult.addMessage((CharSequence)object);
                    statementRunnerResult.setSuccess();
                    bl2 = false;
                }
                catch (IOException iOException) {
                    statementRunnerResult.setFailure();
                    statementRunnerResult.addErrorMessageByKey("ErrFileCreate", ExceptionUtil.getDisplay(iOException));
                }
            }
            object = null;
            if (bl && this.isModificationAllowed(this.currentConnection, VERB)) {
                boolean bl3 = this.cmdLine.getBoolean(ARG_DO_PROMPT, true);
                if (WbManager.getInstance().isGUIMode() && bl3) {
                    object = this.runDDLWithPrompt(string3);
                    bl2 = ((StatementRunnerResult)object).promptingWasCancelled();
                } else {
                    object = this.runDDL(string3);
                }
                if (!((StatementRunnerResult)object).isSuccess()) {
                    statementRunnerResult.setFailure();
                    statementRunnerResult.setFailure(((StatementRunnerResult)object).getErrorDescriptor());
                }
            }
            if (bl2) {
                statementRunnerResult.addMessage(string3);
            }
            if (object != null) {
                statementRunnerResult.addMessageNewLine();
                statementRunnerResult.addMessage(((StatementRunnerResult)object).getMessageBuffer());
                ((StatementRunnerResult)object).clear();
            }
            if (this.cmdLine.getBoolean(ARG_CLIPBOARD, false)) {
                this.putToClipboard(string3);
            }
        }
        catch (Exception exception) {
            statementRunnerResult.addErrorMessage(exception.getMessage());
        }
        return statementRunnerResult;
    }

    private String processOneFile(WbFile wbFile, StatementRunnerResult statementRunnerResult) {
        boolean bl = this.cmdLine.getBoolean("header", WbImport.getHeaderDefault());
        String string = WbImport.findTypeFromFilename(wbFile.getFullPath());
        String string2 = this.cmdLine.getValue("type", string);
        TableDetector tableDetector = null;
        if (string2.equals("text")) {
            String string3 = this.cmdLine.getEscapedString("delimiter", "\t");
            String string4 = this.cmdLine.getEscapedString("quotechar");
            String string5 = this.cmdLine.getValue("encoding");
            String string6 = this.cmdLine.getValue("timestampFormat");
            String string7 = this.cmdLine.getValue("dateFormat");
            QuoteEscapeType quoteEscapeType = CommonArgs.getQuoteEscaping(this.cmdLine);
            TextFileTableDetector textFileTableDetector = new TextFileTableDetector(wbFile, string3, string4, string7, string6, bl, string5);
            boolean bl2 = this.cmdLine.getBoolean("multiLine", WbImport.getMultiDefault());
            textFileTableDetector.setEnableMultiline(bl2);
            textFileTableDetector.setQuoteEscape(quoteEscapeType);
            String string8 = this.cmdLine.getValue("decimal");
            if (string8 != null) {
                textFileTableDetector.setDecimalChar(string8.charAt(0));
            }
            tableDetector = textFileTableDetector;
        } else {
            String string9 = this.cmdLine.getValue("sheetNumber", null);
            int n = 1;
            n = "*".equals(string9) ? 0 : this.cmdLine.getIntValue("sheetNumber", 1);
            tableDetector = new SpreadSheetTableDetector(wbFile, bl, n - 1);
        }
        tableDetector.setAlwaysUseVarchar(this.cmdLine.getBoolean(ARG_ALL_VARCHAR, false));
        tableDetector.setSampleSize(this.cmdLine.getIntValue(ARG_SAMPLE_SIZE, 1000));
        tableDetector.setTableName(this.cmdLine.getValue("table"));
        try {
            tableDetector.analyzeFile();
            if (tableDetector.hasMessages()) {
                statementRunnerResult.addMessage(tableDetector.getMessages());
            }
            return ((TableDetector)tableDetector).getCreateTable(this.currentConnection);
        }
        catch (Exception exception) {
            statementRunnerResult.addErrorMessage(string2);
            return null;
        }
    }

    private void putToClipboard(String string) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, stringSelection);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not copy SQL to clipboard", throwable);
        }
    }

    private StatementRunnerResult runDDL(String string) {
        BatchRunner batchRunner = new BatchRunner();
        batchRunner.setAbortOnError(true);
        batchRunner.setStoreErrors(false);
        batchRunner.setPrintStatements(false);
        batchRunner.setShowProgress(false);
        batchRunner.setShowTiming(false);
        batchRunner.setStoreErrors(false);
        batchRunner.setShowStatementWithResult(false);
        batchRunner.setShowStatementSummary(false);
        batchRunner.setErrorStatementLogging(ErrorReportLevel.none);
        batchRunner.setRowMonitor(this.rowMonitor);
        StringResultLogger stringResultLogger = new StringResultLogger();
        batchRunner.setMessageLogger(stringResultLogger);
        batchRunner.setConnection(this.currentConnection);
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        statementRunnerResult.setSuccess();
        try {
            ExecutionStatus executionStatus = batchRunner.runScript(string);
            statementRunnerResult.addMessage(stringResultLogger.getMessages());
            if (executionStatus == ExecutionStatus.Error) {
                statementRunnerResult.setFailure(batchRunner.getLastError());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return statementRunnerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatementRunnerResult runDDLWithPrompt(String string) {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        statementRunnerResult.setSuccess();
        try {
            this.currentConnection.setBusy(false);
            RunScriptPanel runScriptPanel = new RunScriptPanel(this.currentConnection, string);
            runScriptPanel.openWindow(WbManager.getInstance().getCurrentWindow(), ResourceMgr.getString("TxtWindowTitleGeneratedScript"), null);
            if (!runScriptPanel.wasRun()) {
                statementRunnerResult.setPromptingWasCancelled();
            } else if (!runScriptPanel.isSuccess()) {
                statementRunnerResult.setFailure(runScriptPanel.getError());
            }
        }
        finally {
            this.currentConnection.setBusy(true);
        }
        return statementRunnerResult;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public String getAlternateVerb() {
        return VERB_SHORT;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }
}

