/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.DbMetadata;
import workbench.db.IndexDefinition;
import workbench.db.IndexReader;
import workbench.db.TableIdentifier;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.storage.DataStore;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.StringUtil;

public class WbListIndexes
extends SqlCommand {
    public static final String VERB = "WbListIndexes";
    public static final String ARG_TABLE_NAME = "tableName";
    public static final String ARG_INDEX_NAME = "indexName";

    public WbListIndexes() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("schema", ArgumentType.SchemaArgument);
        this.cmdLine.addArgument("catalog", ArgumentType.CatalogArgument);
        this.cmdLine.addArgument(ARG_TABLE_NAME, ArgumentType.TableArgument);
        this.cmdLine.addArgument(ARG_INDEX_NAME);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Object object;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        DbMetadata dbMetadata = this.currentConnection.getMetadata();
        IndexReader indexReader = dbMetadata.getIndexReader();
        String string3 = null;
        String string4 = null;
        if (this.cmdLine.hasUnknownArguments()) {
            statementRunnerResult.addMessageByKey("ErrListIdxWrongArgs");
            statementRunnerResult.setFailure();
            return statementRunnerResult;
        }
        if (this.cmdLine.hasArguments()) {
            string3 = this.cmdLine.getValue("schema");
            string4 = this.cmdLine.getValue("catalog");
        }
        String string5 = this.currentConnection.getMetadata().getCurrentSchema();
        String string6 = this.currentConnection.getMetadata().getCurrentCatalog();
        String string7 = this.cmdLine.getValue(ARG_INDEX_NAME);
        ArrayList<IndexDefinition> arrayList = null;
        if (this.cmdLine.isArgPresent(ARG_TABLE_NAME)) {
            object = new SourceTableArgument(this.cmdLine.getValue(ARG_TABLE_NAME), null, StringUtil.coalesce(string3, string5), this.currentConnection);
            List<TableIdentifier> list = ((SourceTableArgument)object).getTables();
            arrayList = new ArrayList();
            for (TableIdentifier tableIdentifier : list) {
                List<IndexDefinition> list2 = indexReader.getTableIndexList(tableIdentifier, false);
                arrayList.addAll(list2);
            }
        } else {
            if (!indexReader.supportsIndexList()) {
                statementRunnerResult.addMessageByKey("ErrIdxListNotSupported", dbMetadata.getProductName());
                statementRunnerResult.setFailure();
                return statementRunnerResult;
            }
            arrayList = indexReader.getIndexes(StringUtil.coalesce(string4, string6), StringUtil.coalesce(string3, string5), null, string7);
        }
        object = indexReader.fillDataStore(arrayList, true);
        ((DataStore)object).setResultName(ResourceMgr.getString("TxtDbExplorerIndexes"));
        statementRunnerResult.addDataStore((DataStore)object);
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

