/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import workbench.db.BlobAccessType;
import workbench.db.JdbcUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbSelectBlob
extends SqlCommand {
    public static final String VERB = "WbSelectBlob";

    public WbSelectBlob() {
        this.isUpdatingCommand = false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.currentConnection, string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        WbFile wbFile = null;
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        if (sQLToken == null) {
            statementRunnerResult.addErrorMessageByKey("ErrSelectBlobSyntax");
            return statementRunnerResult;
        }
        if (!sQLToken.getContents().equals("WBSELECTBLOB")) {
            statementRunnerResult.addMessageByKey("ErrSelectBlobSyntax");
            statementRunnerResult.setFailure();
            return statementRunnerResult;
        }
        stringBuilder.append("SELECT ");
        while (sQLToken != null && (sQLToken = sQLLexer.getNextToken(false, true)) != null && !sQLToken.getContents().equals("INTO")) {
            stringBuilder.append(sQLToken.getContents());
        }
        if (sQLToken != null && !sQLToken.getContents().equals("INTO")) {
            statementRunnerResult.addMessageByKey("ErrSelectBlobSyntax");
            statementRunnerResult.setFailure();
            return statementRunnerResult;
        }
        sQLToken = sQLLexer.getNextToken(false, false);
        Object object = sQLToken.getContents();
        wbFile = new WbFile(StringUtil.trimQuotes((String)object));
        stringBuilder.append(' ');
        stringBuilder.append(string.substring(sQLToken.getCharEnd() + 1));
        LogMgr.logDebug(new CallerInfo(){}, "Using SQL=" + stringBuilder + " for file: " + wbFile.getFullPath());
        object = null;
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        long l = 0L;
        File file = wbFile.getParentFile();
        String string2 = wbFile.getFileName();
        String string3 = wbFile.getExtension();
        string3 = StringUtil.isEmptyString(string3) ? "" : "." + string3;
        try {
            this.currentStatement = this.currentConnection.createStatementForQuery();
            object = this.currentStatement.executeQuery(stringBuilder.toString());
            int n = 0;
            while (object.next()) {
                Object object2;
                WbFile wbFile2 = null;
                BlobAccessType blobAccessType = this.currentConnection.getDbSettings().getBlobReadMethod();
                switch (blobAccessType) {
                    case byteArray: {
                        object2 = object.getBytes(1);
                        inputStream = new ByteArrayInputStream((byte[])object2);
                        break;
                    }
                    case jdbcBlob: {
                        Blob blob = object.getBlob(1);
                        inputStream = blob.getBinaryStream();
                    }
                    default: {
                        inputStream = object.getBinaryStream(1);
                    }
                }
                if (inputStream == null) {
                    object2 = ResourceMgr.getString("ErrSelectBlobNoStream");
                    statementRunnerResult.addWarning(StringUtil.replace((String)object2, "%row%", Integer.toString(n)));
                    continue;
                }
                wbFile2 = n == 0 ? wbFile : new WbFile(file, string2 + "_" + Integer.toString(n) + string3);
                fileOutputStream = new FileOutputStream(wbFile2);
                l = FileUtil.copy(inputStream, fileOutputStream);
                object2 = ResourceMgr.getString("MsgBlobSaved");
                object2 = ((String)object2).replace("%filename%", wbFile2.getFullPath());
                object2 = ((String)object2).replace("%filesize%", Long.toString(l));
                statementRunnerResult.addMessage((CharSequence)object2);
                statementRunnerResult.setSuccess();
                ++n;
            }
            this.appendSuccessMessage(statementRunnerResult);
        }
        catch (IOException iOException) {
            String string4 = StringUtil.replace(ResourceMgr.getString("ErrSelectBlobFileError"), "%filename%", wbFile.getFullPath());
            statementRunnerResult.addMessage(string4);
            statementRunnerResult.setFailure();
            StatementRunnerResult statementRunnerResult2 = statementRunnerResult;
            return statementRunnerResult2;
        }
        catch (SQLException sQLException) {
            String string5 = StringUtil.replace(ResourceMgr.getString("ErrSelectBlobSqlError"), "%filename%", wbFile.getFullPath());
            statementRunnerResult.addMessage(string5);
            statementRunnerResult.addMessage(ExceptionUtil.getDisplay(sQLException));
            statementRunnerResult.setFailure();
            StatementRunnerResult statementRunnerResult3 = statementRunnerResult;
            return statementRunnerResult3;
        }
        finally {
            JdbcUtils.closeAll((ResultSet)object, this.currentStatement);
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }

    @Override
    public boolean shouldEndTransaction() {
        return true;
    }
}

