/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.WbShowProps;
import workbench.storage.DataStore;
import workbench.util.ArgumentParser;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class WbSetProp
extends SqlCommand {
    public static final String VERB = "WbSetProp";
    public static final String ALTERNATE_VERB = "WbSetConfig";
    public static final String SET_DB_CONFIG_VERB = "WbSetDbConfig";
    public static final String ARG_TYPE = "type";
    public static final String ARG_PROP = "property";
    public static final String ARG_VALUE = "value";
    private final Map<String, String> configMap = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);

    public WbSetProp() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(ARG_TYPE, CollectionUtil.arrayList("temp", "default"));
        this.cmdLine.addArgument(ARG_PROP);
        this.cmdLine.addArgument(ARG_VALUE);
        this.configMap.put("nulldisplay", "workbench.console.nullstring");
        this.configMap.put("nullstring", "workbench.console.nullstring");
        this.configMap.put("varsuffix", "workbench.sql.parameter.suffix");
        this.configMap.put("varprefix", "workbench.sql.parameter.prefix");
        this.configMap.put("debugmeta", "workbench.dbmetadata.debugmetasql");
        this.configMap.put("date_format", "workbench.gui.display.dateformat");
        this.configMap.put("ts_format", "workbench.gui.display.datetimeformat");
        this.configMap.put("time_format", "workbench.gui.display.timeformat");
        this.configMap.put("digits", "workbench.gui.display.maxfractiondigits");
        this.configMap.put("dec_separator", "workbench.gui.display.decimal.separator");
        this.configMap.put("dec_sep", "workbench.gui.display.decimal.separator");
        this.configMap.put("showscriptfinish", "workbench.gui.sql.script.showtime");
        this.configMap.put("showendtime", "workbench.gui.sql.script.showtime");
        this.configMap.put("showfinishtime", "workbench.gui.sql.script.showtime");
        this.configMap.put("clearonrefresh", "workbench.console.refresh.clear.screen");
        this.configMap.put("logfileviewer", "workbench.logfile.viewer.program");
        this.configMap.put("displaysize", "workbench.console.dataprinter.max.colwidth");
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        String string2 = this.getParsingUtil().getSqlVerb(string);
        boolean bl = string2.equalsIgnoreCase(ALTERNATE_VERB);
        boolean bl2 = string2.equalsIgnoreCase(SET_DB_CONFIG_VERB);
        if (bl2) {
            bl = true;
        }
        String string3 = this.getCommandLine(string);
        this.cmdLine.parse(string3);
        if (this.cmdLine.hasArguments()) {
            int n;
            String string4 = this.cmdLine.getValue(ARG_TYPE, "temp");
            String string5 = this.cmdLine.getValue(ARG_PROP);
            String string6 = null;
            int n2 = n = string5 != null ? string5.indexOf(58) : -1;
            if (n < 0) {
                string6 = this.cmdLine.getValue(ARG_VALUE);
            } else if (string5 != null) {
                string6 = string5.substring(n + 1);
                string5 = string5.substring(0, n);
            }
            if (string5 == null) {
                statementRunnerResult.setFailure();
                statementRunnerResult.addMessage("Property name required!");
            } else if (string6 == null && this.cmdLine.isArgNotPresent(ARG_VALUE)) {
                String string7 = Settings.getInstance().getProperty(string5, "");
                statementRunnerResult.addMessage(string5 + "=" + string7);
            } else if ("default".equals(string4) && string5.startsWith("workbench")) {
                Settings.getInstance().setProperty(string5, string6);
                statementRunnerResult.addMessage(string5 + " permanently set to " + string6);
            } else {
                Settings.getInstance().setTemporaryProperty(string5, string6);
                statementRunnerResult.addMessage(string5 + " set to " + string6);
            }
        } else if (string3.indexOf(61) > -1) {
            String[] stringArray = string3.split("=");
            if (stringArray.length == 2) {
                String string8 = this.getPropertyName(stringArray[0]);
                String string9 = StringUtil.trimQuotes(stringArray[1]);
                if (bl2 && !string8.startsWith("workbench") && this.currentConnection != null) {
                    string8 = "workbench.db." + this.currentConnection.getDbId() + "." + string8;
                }
                if (bl && string8.startsWith("workbench")) {
                    Settings.getInstance().setProperty(string8, string9);
                    statementRunnerResult.addMessage(string8 + " permanently set to \"" + string9 + "\"");
                    LogMgr.logInfo(new CallerInfo(){}, "Changed configuration property: " + string8 + "=" + string9);
                    Settings.getInstance().setCreatBackupOnSave(true);
                } else {
                    Settings.getInstance().setTemporaryProperty(string8, string9);
                    statementRunnerResult.addMessage(string8 + " set to \"" + string9 + "\"");
                }
            } else if (stringArray.length == 1) {
                String string10 = this.getPropertyName(stringArray[0]);
                Settings.getInstance().removeProperty(string10);
                statementRunnerResult.addMessage(string10 + " removed");
            }
        } else {
            DataStore dataStore = WbShowProps.getWbProperties(string3);
            if (dataStore.getRowCount() > 0) {
                statementRunnerResult.addDataStore(dataStore);
            }
        }
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    private String getPropertyName(String string) {
        String string2 = this.configMap.get(string);
        if (string2 == null) {
            string2 = string;
        }
        if (this.currentConnection != null) {
            return string2.replace("[dbid]", this.currentConnection.getDbId());
        }
        return string2;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public String getAlternateVerb() {
        return ALTERNATE_VERB;
    }

    @Override
    public Collection<String> getAllVerbs() {
        return CollectionUtil.arrayList(VERB, ALTERNATE_VERB, SET_DB_CONFIG_VERB);
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

