/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.sql.SQLException;
import java.util.List;
import workbench.WbManager;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroGroup;
import workbench.sql.macros.MacroManager;
import workbench.sql.macros.MacroStorage;
import workbench.storage.DataStore;
import workbench.storage.SortDefinition;

public class WbListMacros
extends SqlCommand {
    public static final String VERB = "WbListMacros";

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        DataStore dataStore;
        boolean bl;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        MacroStorage macroStorage = MacroManager.getInstance().getMacros(this.getMacroClientId());
        List<MacroGroup> list = macroStorage.getGroups();
        String string2 = ResourceMgr.getString("LblMacroName");
        String string3 = ResourceMgr.getString("LblMacroGrpName");
        String string4 = ResourceMgr.getString("LblMacroDef");
        if (WbManager.getInstance().isGUIMode()) {
            bl = true;
            dataStore = new DataStore(new String[]{string3, string2, string4}, new int[]{12, 12, 2005});
        } else {
            bl = false;
            dataStore = new DataStore(new String[]{string2, string4}, new int[]{12, 2005});
        }
        for (MacroGroup macroGroup : list) {
            List<MacroDefinition> list2 = macroGroup.getMacros();
            for (MacroDefinition macroDefinition : list2) {
                String string5 = macroDefinition.getName();
                if (macroDefinition.getExpandWhileTyping()) {
                    string5 = string5 + "(+)";
                }
                int n = dataStore.addRow();
                int n2 = 0;
                if (bl) {
                    dataStore.setValue(n, n2++, (Object)macroGroup.getName());
                }
                dataStore.setValue(n, n2++, (Object)string5);
                dataStore.setValue(n, n2++, (Object)macroDefinition.getText());
            }
        }
        if (!bl) {
            SortDefinition sortDefinition = new SortDefinition(0, true);
            sortDefinition.setIgnoreCase(true);
            dataStore.sort(sortDefinition);
        }
        dataStore.resetStatus();
        dataStore.setGeneratingSql(VERB);
        statementRunnerResult.addDataStore(dataStore);
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

