/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.sql.SQLException;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DbDriver;
import workbench.gui.profiles.ProfileKey;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.StringUtil;

public class WbStoreProfile
extends SqlCommand {
    public static final String VERB = "WbStoreProfile";
    public static final String ARG_PROFILE_NAME = "name";
    public static final String ARG_SAVE_PASSWORD = "savePassword";

    public WbStoreProfile() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(ARG_PROFILE_NAME);
        this.cmdLine.addArgument(ARG_SAVE_PASSWORD, ArgumentType.BoolArgument);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        String string3 = null;
        boolean bl = false;
        if (this.cmdLine.hasArguments()) {
            string3 = this.cmdLine.getValue(ARG_PROFILE_NAME);
            bl = this.cmdLine.getBoolean(ARG_SAVE_PASSWORD, false);
        } else {
            string3 = string2;
        }
        if (this.currentConnection == null) {
            statementRunnerResult.addErrorMessageByKey("TxtNotConnected");
            return statementRunnerResult;
        }
        if (StringUtil.isBlank(string3)) {
            statementRunnerResult.addErrorMessageByKey("ErrNoProfile");
            return statementRunnerResult;
        }
        ProfileKey profileKey = new ProfileKey(string3);
        ConnectionProfile connectionProfile = this.currentConnection.getProfile().createCopy();
        connectionProfile.setName(profileKey.getName());
        connectionProfile.setGroup(profileKey.getGroup());
        if (bl) {
            connectionProfile.setStorePassword(true);
        } else {
            connectionProfile.setPassword(null);
            connectionProfile.setStorePassword(false);
        }
        connectionProfile.setWorkspaceFile(null);
        ConnectionMgr.getInstance().addProfile(connectionProfile);
        ConnectionMgr.getInstance().saveProfiles();
        statementRunnerResult.addMessageByKey("MsgProfileAdded", profileKey.toString());
        DbDriver dbDriver = ConnectionMgr.getInstance().findDriver(connectionProfile.getDriverclass());
        if (dbDriver.isTemporaryDriver()) {
            DbDriver dbDriver2 = dbDriver.createCopy();
            String string4 = this.currentConnection.getSqlConnection().getMetaData().getDriverName();
            dbDriver2.setName(string4);
            dbDriver2.setSampleUrl(connectionProfile.getUrl());
            connectionProfile.setDriverName(string4);
            ConnectionMgr.getInstance().getDrivers().add(dbDriver2);
            ConnectionMgr.getInstance().saveDrivers();
            statementRunnerResult.addMessageByKey("MsgDriverAdded", string4);
        }
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

