/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.exporter.TextRowDataConverter;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.CharacterRange;
import workbench.util.StringUtil;

public class DataPrinter {
    private final DataStore data;
    private TextRowDataConverter converter;
    private int[] columnMap;

    public DataPrinter(DataStore dataStore) {
        this.data = dataStore;
        this.initConverter("\t", StringUtil.LINE_TERMINATOR, null, true);
    }

    public DataPrinter(DataStore dataStore, boolean bl) {
        this.data = dataStore;
        this.initConverter("\t", StringUtil.LINE_TERMINATOR, null, bl);
    }

    public DataPrinter(DataStore dataStore, String string, String string2, List<ColumnIdentifier> list, boolean bl) {
        this.data = dataStore;
        this.initConverter(string, string2, list, bl);
    }

    public void setEscapeRange(CharacterRange characterRange) {
        if (this.converter != null) {
            this.converter.setEscapeRange(characterRange);
        }
    }

    private void initConverter(String string, String string2, List<ColumnIdentifier> list, boolean bl) {
        this.converter = new TextRowDataConverter();
        this.converter.setResultInfo(this.data.getResultInfo());
        this.converter.setWriteBlobToFile(false);
        this.converter.setWriteHeader(bl);
        this.converter.setLineEnding(string2);
        this.converter.setDelimiter(string);
        this.converter.setColumnsToExport(list);
        this.converter.setEscapeRange(CharacterRange.RANGE_NONE);
        this.converter.setDefaultNumberFormatter(Settings.getInstance().createDefaultDecimalFormatter());
        this.converter.setDefaultIntegerFormatter(Settings.getInstance().createDefaultIntegerFormatter());
    }

    public void setNullString(String string) {
        this.converter.setNullString(string);
    }

    public void setColumnMapping(int[] nArray) {
        this.columnMap = nArray;
    }

    public void writeDataString(Writer writer, int[] nArray) throws IOException {
        StringBuilder stringBuilder = this.converter.getStart(this.columnMap);
        if (stringBuilder != null) {
            writer.write(stringBuilder.toString());
            writer.flush();
        }
        int n = nArray == null ? this.data.getRowCount() : nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray == null ? i : nArray[i];
            StringBuilder stringBuilder2 = this.converter.convertRowData(this.data.getRow(n2), n2, this.columnMap);
            writer.write(stringBuilder2.toString());
            writer.flush();
        }
    }
}

