/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.util.Alias;
import workbench.util.CollectionUtil;
import workbench.util.NumberStringCache;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DatastoreTransposer {
    private DataStore source;
    private boolean useTableNameForResultName;
    private final Set<String> excludeColumns = CollectionUtil.caseInsensitiveSet();

    public DatastoreTransposer(DataStore dataStore) {
        this.source = dataStore;
    }

    public void setColumnsToExclude(Collection<String> collection) {
        this.excludeColumns.clear();
        for (String string : collection) {
            if (this.source.getColumnIndex(string) <= -1) continue;
            this.excludeColumns.add(string);
        }
    }

    public void setUseTableNameForResult(boolean bl) {
        this.useTableNameForResultName = bl;
    }

    private String getSourceResultName() {
        String string;
        List<Alias> list;
        if (this.source == null) {
            return "";
        }
        String string2 = this.source.getResultName();
        if (string2 == null && this.useTableNameForResultName && (list = SqlUtil.getTables(string = this.source.getGeneratingSql(), false, this.source.getOriginalConnection())).size() == 1) {
            string2 = list.get(0).getObjectName();
        }
        return string2;
    }

    public DataStore transposeRows(int[] nArray) {
        return this.transposeWithLabel(null, null, nArray);
    }

    public DataStore transposeWithLabel(String string, String string2, int[] nArray) {
        int n;
        int n2;
        int n3 = this.source.getColumnIndex(string);
        int n4 = nArray == null ? this.source.getRowCount() : nArray.length;
        int n5 = n4 + 1;
        String[] stringArray = new String[n5];
        int[] nArray2 = new int[n5];
        nArray2[0] = 12;
        stringArray[0] = n3 > -1 ? "" : ResourceMgr.getString("TxtColumnName");
        if (string2 == null) {
            string2 = "";
        }
        for (int i = 0; i < n4; ++i) {
            n2 = nArray == null ? i : nArray[i];
            stringArray[i + 1] = n3 > -1 ? string2 + StringUtil.coalesce(this.source.getValueAsString(n2, n3), "") : ResourceMgr.getString("TxtRow") + " " + NumberStringCache.getNumberString(n2 + 1);
            nArray2[i + 1] = 12;
        }
        DataStore dataStore = new DataStore(stringArray, nArray2);
        n2 = this.source.getColumnCount() - this.excludeColumns.size();
        if (n3 > -1) {
            --n2;
        }
        for (n = 0; n < n2; ++n) {
            dataStore.addRow();
        }
        for (n = 0; n < n4; ++n) {
            int n6 = 0;
            int n7 = n + 1;
            for (int i = 0; i < this.source.getColumnCount(); ++i) {
                String string3;
                if (i == n3 || this.excludeColumns.contains(string3 = this.source.getColumnName(i))) continue;
                String string4 = this.source.getValueAsString(n, i);
                dataStore.setValue(n6, 0, (Object)string3);
                dataStore.setValue(n6, n7, (Object)string4);
                ++n6;
            }
        }
        dataStore.setResultName(this.getSourceResultName());
        dataStore.resetStatus();
        return dataStore;
    }
}

