/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Base64;
import workbench.storage.BlobLiteralFormatter;
import workbench.storage.BlobLiteralType;
import workbench.util.FileUtil;
import workbench.util.NumberStringCache;
import workbench.util.StringUtil;

public class DefaultBlobFormatter
implements BlobLiteralFormatter {
    private String prefix;
    private String suffix;
    private boolean upperCase = false;
    private BlobLiteralType literalType = BlobLiteralType.hex;

    public void setLiteralType(BlobLiteralType blobLiteralType) {
        this.literalType = blobLiteralType == null ? BlobLiteralType.hex : blobLiteralType;
    }

    public void setUseUpperCase(boolean bl) {
        this.upperCase = bl;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }

    @Override
    public String getBlobLiteral(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        int n = this.prefix != null ? this.prefix.length() : 0;
        n += this.suffix != null ? this.suffix.length() : 0;
        StringBuilder stringBuilder = null;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            stringBuilder = this.convertBytes(byArray);
        } else if (object instanceof Blob) {
            Blob blob = (Blob)object;
            int n2 = (int)blob.length();
            stringBuilder = new StringBuilder(n2 * 2 + n);
            if (this.prefix != null) {
                stringBuilder.append(this.prefix);
            }
            for (int i = 0; i < n2; ++i) {
                byte[] byArray = blob.getBytes(i, 1);
                this.appendArray(stringBuilder, byArray);
            }
        } else if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            try {
                byte[] byArray = FileUtil.readBytes(inputStream);
                stringBuilder = this.convertBytes(byArray);
            }
            catch (IOException iOException) {
                throw new SQLException("Could not read BLOB data", iOException);
            }
        } else {
            String string = object.toString();
            stringBuilder = new StringBuilder(string.length() + n);
            if (this.prefix != null) {
                stringBuilder.append(this.prefix);
            }
            stringBuilder.append(string);
        }
        if (this.suffix != null) {
            stringBuilder.append(this.suffix);
        }
        return stringBuilder.toString();
    }

    private StringBuilder convertBytes(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        if (this.prefix != null) {
            stringBuilder.append(this.prefix);
        }
        this.appendArray(stringBuilder, byArray);
        return stringBuilder;
    }

    private void appendArray(StringBuilder stringBuilder, byte[] byArray) {
        switch (this.literalType) {
            case base64: {
                Base64.Encoder encoder = Base64.getEncoder();
                stringBuilder.append(encoder.encodeToString(byArray));
                break;
            }
            case uuid: {
                this.appendUUID(stringBuilder, byArray);
                break;
            }
            case octal: {
                for (int i = 0; i < byArray.length; ++i) {
                    int n = byArray[i] & 0xFF;
                    stringBuilder.append("\\");
                    CharSequence charSequence = StringUtil.getOctalString(n);
                    if (this.upperCase) {
                        stringBuilder.append(charSequence.toString().toUpperCase());
                        continue;
                    }
                    stringBuilder.append(charSequence);
                }
                break;
            }
            default: {
                this.appendHexArray(stringBuilder, byArray);
            }
        }
    }

    private void appendUUID(StringBuilder stringBuilder, byte[] byArray) {
        char[] cArray = this.upperCase ? NumberStringCache.HEX_ARRAY_UPPER : NumberStringCache.HEX_ARRAY_LOWER;
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            stringBuilder.append(cArray[n >>> 4]);
            stringBuilder.append(cArray[n & 0xF]);
            if (i != 3 && i != 5 && i != 7 && i != 9) continue;
            stringBuilder.append('-');
        }
    }

    private void appendHexArray(StringBuilder stringBuilder, byte[] byArray) {
        char[] cArray = this.upperCase ? NumberStringCache.HEX_ARRAY_UPPER : NumberStringCache.HEX_ARRAY_LOWER;
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            stringBuilder.append(cArray[n >>> 4]);
            stringBuilder.append(cArray[n & 0xF]);
        }
    }

    @Override
    public BlobLiteralType getType() {
        return this.literalType;
    }
}

