/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.util.List;
import workbench.db.QuoteHandler;
import workbench.storage.DataStore;
import workbench.storage.SortDefinition;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class NamedSortDefinition {
    private String[] sortColumns;
    private boolean[] sortAscending;
    private boolean ignoreCase;
    private boolean naturalSort;

    public NamedSortDefinition(String[] stringArray, boolean[] blArray) {
        this.sortColumns = stringArray;
        this.sortAscending = blArray;
    }

    public NamedSortDefinition(DataStore dataStore, SortDefinition sortDefinition) {
        if (sortDefinition != null && sortDefinition.hasColumns()) {
            this.sortColumns = new String[sortDefinition.getColumnCount()];
            this.sortAscending = new boolean[sortDefinition.getColumnCount()];
            int n = dataStore.getColumnCount();
            for (int i = 0; i < sortDefinition.getColumnCount(); ++i) {
                int n2 = sortDefinition.getSortColumnByIndex(i);
                if (n2 <= -1 || n2 >= n) {
                    this.sortColumns = null;
                    this.sortAscending = null;
                    break;
                }
                this.sortColumns[i] = dataStore.getColumnName(n2);
                this.sortAscending[i] = sortDefinition.isSortAscending(n2);
            }
            this.ignoreCase = sortDefinition.getIgnoreCase();
            this.naturalSort = sortDefinition.useNaturalSort();
        }
    }

    public int getColumnCount() {
        if (this.sortColumns == null) {
            return 0;
        }
        return this.sortColumns.length;
    }

    public void setUseNaturalSort(boolean bl) {
        this.naturalSort = bl;
    }

    public boolean useNaturalSort() {
        return this.naturalSort;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public SortDefinition getSortDefinition(DataStore dataStore) {
        if (this.sortColumns == null) {
            return new SortDefinition();
        }
        int[] nArray = new int[this.sortColumns.length];
        for (int i = 0; i < this.sortColumns.length; ++i) {
            int n = dataStore.getColumnIndex(this.sortColumns[i]);
            if (n < 0) {
                return new SortDefinition();
            }
            nArray[i] = n;
        }
        SortDefinition sortDefinition = new SortDefinition(nArray, this.sortAscending);
        sortDefinition.setIgnoreCase(this.ignoreCase);
        sortDefinition.setUseNaturalSort(this.naturalSort);
        return sortDefinition;
    }

    public String getSqlExpression(QuoteHandler quoteHandler) {
        if (this.sortColumns == null || this.sortColumns.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.sortColumns.length * 20);
        for (int i = 0; i < this.sortColumns.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(quoteHandler.quoteObjectname(this.sortColumns[i]));
            if (this.sortAscending[i]) {
                stringBuilder.append(" ASC");
                continue;
            }
            stringBuilder.append(" DESC");
        }
        return stringBuilder.toString();
    }

    public String getDefinitionString() {
        if (this.sortColumns == null || this.sortColumns.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.sortColumns.length * 10 + 16);
        stringBuilder.append("ignoreCase:" + this.ignoreCase + ",");
        for (int i = 0; i < this.sortColumns.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"');
            stringBuilder.append(this.sortColumns[i]);
            stringBuilder.append(';');
            stringBuilder.append(this.sortAscending[i] ? (char)'a' : 'd');
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    public static NamedSortDefinition parseDefinitionString(String string) {
        List<String> list;
        if (StringUtil.isBlank(string)) {
            return null;
        }
        boolean bl = false;
        if (string.startsWith("ignoreCase:")) {
            bl = string.startsWith("ignoreCase:true");
            string = string.replaceFirst("ignoreCase\\:(true|false),", "");
        }
        if (CollectionUtil.isEmpty(list = StringUtil.stringToList(string, ",", true, true, false))) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        boolean[] blArray = new boolean[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string2 = StringUtil.trimQuotes(list.get(i));
            int n = string2.indexOf(59);
            if (n == -1) {
                n = string2.indexOf(58);
            }
            if (n > -1) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                stringArray[i] = string3;
                blArray[i] = string4.toLowerCase().startsWith("a");
                continue;
            }
            stringArray[i] = string2;
            blArray[i] = true;
        }
        NamedSortDefinition namedSortDefinition = new NamedSortDefinition(stringArray, blArray);
        namedSortDefinition.setIgnoreCase(bl);
        return namedSortDefinition;
    }
}

