/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage.reader;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import workbench.db.ConnectionMgr;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.reader.TimestampTZHandler;

public class OracleTZHandler
implements TimestampTZHandler {
    private Connection sqlConnection;
    private boolean useDefaultClassLoader;
    private Class tzClass;
    private Constructor tzConstructor;

    public OracleTZHandler(WbConnection wbConnection, boolean bl) {
        this.useDefaultClassLoader = bl;
        this.sqlConnection = wbConnection.getSqlConnection();
        try {
            this.tzClass = this.loadClass(wbConnection, "oracle.sql.TIMESTAMPTZ");
            this.tzConstructor = this.tzClass.getConstructor(Connection.class, Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Class oracle.sql.TIMESTAMPTZ not available!");
        }
    }

    @Override
    public Object convertTimestampTZ(Object object) {
        try {
            if (object instanceof ZonedDateTime) {
                ZonedDateTime zonedDateTime = (ZonedDateTime)object;
                TimeZone timeZone = TimeZone.getTimeZone(zonedDateTime.getZone());
                Calendar calendar = Calendar.getInstance(timeZone);
                Timestamp timestamp = Timestamp.valueOf(zonedDateTime.toLocalDateTime());
                Object t = this.tzConstructor.newInstance(this.sqlConnection, timestamp, calendar);
                return t;
            }
            if (object instanceof OffsetDateTime) {
                OffsetDateTime offsetDateTime = (OffsetDateTime)object;
                TimeZone timeZone = TimeZone.getTimeZone(offsetDateTime.getOffset().normalized());
                Calendar calendar = Calendar.getInstance(timeZone);
                Timestamp timestamp = Timestamp.valueOf(offsetDateTime.toLocalDateTime());
                Object t = this.tzConstructor.newInstance(this.sqlConnection, timestamp, calendar);
                return t;
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error converting input to TIMESTAMPTZ", throwable);
        }
        return object;
    }

    private Class loadClass(WbConnection wbConnection, String string) throws ClassNotFoundException {
        if (this.useDefaultClassLoader) {
            return Class.forName(string);
        }
        return ConnectionMgr.getInstance().loadClassFromDriverLib(wbConnection.getProfile(), string);
    }
}

