/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage.reader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.TimeZone;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.ResultInfo;
import workbench.storage.reader.ResultHolder;
import workbench.storage.reader.RowDataReader;
import workbench.storage.reader.TimestampTZHandler;

class PostgresRowDataReader
extends RowDataReader {
    private static final int NO_ADJUST = 0;
    private static final int ADJUST_OFFSET = 1;
    private static final int PARSE_STRING = 2;
    private final boolean useJava8Time;
    private int timeTzStrategy = 2;
    private final DateTimeFormatter timeParser = new DateTimeFormatterBuilder().parseLenient().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendOffset("+HHmm", "Z").toFormatter();
    private long tzOffset;
    private ZoneId sessionTimeZone;
    private WbConnection dbConnection;

    PostgresRowDataReader(ResultInfo resultInfo, WbConnection wbConnection) {
        super(resultInfo, wbConnection);
        this.dbConnection = wbConnection;
        this.timeTzStrategy = this.getTimeTZStrategy(wbConnection);
        if (this.timeTzStrategy != 0) {
            LogMgr.logInfo(new CallerInfo(){}, "Adjusting timetz values to LocalTime by " + (this.timeTzStrategy == 2 ? "parsing the string value" : "adjusting the time zone offset"));
        }
        this.useJava8Time = TimestampTZHandler.Factory.supportsJava8Time(wbConnection);
        if (this.useJava8Time) {
            this.useGetObjectForTimestamps = true;
            this.useGetObjectForTimestampTZ = true;
            this.useGetObjectForDates = true;
            LogMgr.logInfo(new CallerInfo(){}, "Using ZonedDateTime to read TIMESTAMP WITH TIME ZONE columns");
        }
    }

    private int getTimeTZStrategy(WbConnection wbConnection) {
        if (wbConnection == null) {
            return 0;
        }
        String string = wbConnection.getDbSettings().getProperty("timetz.adjustment", "parse_string");
        if (string == null) {
            return 0;
        }
        if ("parse_string".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("adjust_offset".equalsIgnoreCase(string)) {
            return 1;
        }
        return 0;
    }

    @Override
    protected Object readTimeTZValue(ResultHolder resultHolder, int n) throws SQLException {
        Object object;
        if (this.timeTzStrategy == 2) {
            object = resultHolder.getString(n);
            if (object == null) {
                return null;
            }
            try {
                TemporalAccessor temporalAccessor = this.timeParser.parse((CharSequence)object);
                return LocalTime.from(temporalAccessor);
            }
            catch (Throwable throwable) {
                LogMgr.logDebug(new CallerInfo(){}, "Could not parse time string: " + (String)object, throwable);
                this.timeTzStrategy = 1;
            }
        }
        if ((object = resultHolder.getTime(n)) == null) {
            return null;
        }
        if (this.timeTzStrategy == 1) {
            try {
                this.initTimeZone();
                return ((Time)object).toLocalTime().plus(this.tzOffset, ChronoUnit.MILLIS);
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Could not adjust java.sql.Time to LocalTime", throwable);
                this.timeTzStrategy = 0;
            }
        }
        return object;
    }

    @Override
    protected Object readTimestampTZValue(ResultHolder resultHolder, int n) throws SQLException {
        if (this.useJava8Time) {
            return this.readZonedDateTime(resultHolder, n);
        }
        return super.readTimestampTZValue(resultHolder, n);
    }

    private ZonedDateTime readZonedDateTime(ResultHolder resultHolder, int n) throws SQLException {
        this.initTimeZone();
        OffsetDateTime offsetDateTime = resultHolder.getObject(n, OffsetDateTime.class);
        if (offsetDateTime == null) {
            return null;
        }
        if (offsetDateTime.equals(OffsetDateTime.MAX) || offsetDateTime.equals(OffsetDateTime.MIN)) {
            return offsetDateTime.atZoneSimilarLocal(ZoneId.of("+0"));
        }
        return offsetDateTime.atZoneSameInstant(this.sessionTimeZone);
    }

    private void initTimeZone() {
        if (this.sessionTimeZone != null) {
            return;
        }
        this.sessionTimeZone = this.getSessionTimezone(this.dbConnection);
        TimeZone timeZone = TimeZone.getTimeZone(this.sessionTimeZone);
        this.tzOffset = timeZone.getRawOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZoneId getSessionTimezone(WbConnection wbConnection) {
        ResultSet resultSet;
        Statement statement;
        block8: {
            ZoneId zoneId;
            if (wbConnection == null) {
                return ZoneId.systemDefault();
            }
            statement = null;
            resultSet = null;
            try {
                statement = wbConnection.createStatement();
                resultSet = statement.executeQuery("show time zone");
                if (!resultSet.next()) break block8;
                String string = resultSet.getString(1);
                if (string.contains("-")) {
                    string = string.replace('-', '+');
                } else if (string.contains("+")) {
                    string = string.replace('+', '-');
                }
                ZoneId zoneId2 = ZoneId.of(string);
                LogMgr.logDebug(new CallerInfo(){}, "Using session time zone: " + zoneId2);
                zoneId = zoneId2;
            }
            catch (Throwable throwable) {
                try {
                    LogMgr.logError(new CallerInfo(){}, "Could not retrieve session time zone, using system default", throwable);
                }
                catch (Throwable throwable2) {
                    JdbcUtils.close(resultSet, statement);
                    throw throwable2;
                }
                JdbcUtils.close(resultSet, statement);
            }
            JdbcUtils.close(resultSet, statement);
            return zoneId;
        }
        JdbcUtils.close(resultSet, statement);
        return ZoneId.systemDefault();
    }
}

