/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import workbench.db.BlobAccessType;
import workbench.db.ClobAccessType;
import workbench.db.DBID;
import workbench.db.DbMetadata;
import workbench.db.DbSettings;
import workbench.db.WbConnection;
import workbench.db.mssql.SqlServerDataConverter;
import workbench.db.oracle.OracleDataConverter;
import workbench.db.postgres.PostgresDataConverter;
import workbench.db.ucanaccess.UCanAccessDataConverter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.ArrayConverter;
import workbench.storage.DataConverter;
import workbench.storage.RefCursorConsumer;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.StructConverter;
import workbench.storage.reader.ResultHolder;
import workbench.storage.reader.ResultSetHolder;
import workbench.util.FileUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class RowDataReader {
    private final List<Closeable> streams;
    protected DataConverter converter;
    protected boolean ignoreReadErrors;
    protected boolean useStreamsForBlobs;
    protected boolean useStreamsForClobs;
    protected boolean longVarcharAsClob;
    protected BlobAccessType blobMethod = BlobAccessType.binaryStream;
    protected ClobAccessType clobMethod = ClobAccessType.string;
    protected boolean useGetStringForBit;
    protected boolean useGetObjectForDates;
    protected boolean useGetObjectForTimestamps;
    protected boolean useGetObjectForTimestampTZ;
    protected boolean useGetObjectForTime;
    protected boolean useGetXML;
    protected boolean adjustArrayDisplay;
    protected boolean showArrayType;
    protected boolean fixStupidMySQLZeroDate;
    protected boolean isOracle;
    protected ResultInfo resultInfo;
    protected RefCursorConsumer refCursorConsumer;

    public RowDataReader(ResultInfo resultInfo, WbConnection wbConnection) {
        DbSettings dbSettings;
        this.ignoreReadErrors = Settings.getInstance().getBoolProperty("workbench.db.ignore.readerror", false);
        this.converter = RowDataReader.getConverterInstance(wbConnection);
        this.isOracle = wbConnection == null ? false : wbConnection.getMetadata().isOracle();
        this.resultInfo = resultInfo;
        DbSettings dbSettings2 = dbSettings = wbConnection == null ? null : wbConnection.getDbSettings();
        if (dbSettings != null) {
            this.longVarcharAsClob = dbSettings.longVarcharIsClob();
            this.blobMethod = dbSettings.getBlobReadMethod();
            this.clobMethod = dbSettings.getClobReadMethod();
            this.useGetStringForBit = dbSettings.useGetStringForBit();
            this.useGetObjectForDates = dbSettings.useGetObjectForDates();
            this.useGetObjectForTimestamps = dbSettings.useGetObjectForTimestamps();
            this.useGetObjectForTimestampTZ = dbSettings.useGetObjectForTimestampTZ();
            this.useGetObjectForTime = dbSettings.useLocalTimeForTime();
            this.showArrayType = dbSettings.showArrayType();
            this.adjustArrayDisplay = dbSettings.handleArrayDisplay();
            this.useGetXML = dbSettings.useGetXML();
            this.fixStupidMySQLZeroDate = dbSettings.fixStupidMySQLZeroDate();
        }
        this.streams = new ArrayList<Closeable>(this.countLobColumns());
    }

    public void setRefCursorConsumer(RefCursorConsumer refCursorConsumer) {
        this.refCursorConsumer = refCursorConsumer;
    }

    private int countLobColumns() {
        if (this.resultInfo == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.resultInfo.getColumnCount(); ++i) {
            int n2 = this.resultInfo.getColumnType(i);
            if (!SqlUtil.isBlobType(n2) && !SqlUtil.isClobType(n2)) continue;
            ++n;
        }
        return n;
    }

    public void setConverter(DataConverter dataConverter) {
        this.converter = dataConverter;
    }

    public void setUseStreamsForBlobs(boolean bl) {
        this.useStreamsForBlobs = bl;
    }

    public void setUseStreamsForClobs(boolean bl) {
        this.useStreamsForClobs = bl;
    }

    public RowData read(ResultSet resultSet) throws SQLException {
        return this.read(resultSet, true);
    }

    public RowData read(ResultSet resultSet, boolean bl) throws SQLException {
        return this.read(new ResultSetHolder(resultSet), bl);
    }

    public RowData read(ResultHolder resultHolder, boolean bl) throws SQLException {
        int n = this.resultInfo.getColumnCount();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            String string;
            int n2 = this.resultInfo.getColumnType(i);
            if (this.converter != null && this.converter.convertsType(n2, string = this.resultInfo.getDbmsTypeName(i))) {
                Object object = resultHolder.getObject(i + 1);
                objectArray[i] = this.converter.convertValue(n2, string, object);
                continue;
            }
            objectArray[i] = this.readColumnData(resultHolder, n2, i + 1, bl);
        }
        return new RowData(objectArray);
    }

    public Object readColumnData(ResultHolder resultHolder, int n, int n2, boolean bl) throws SQLException {
        Object object = null;
        try {
            if (n == 12 || n == -9) {
                object = resultHolder.getString(n2);
            } else if (n == 93) {
                object = this.readTimestampValue(resultHolder, n2);
            } else if (n == 2014) {
                object = this.readTimestampTZValue(resultHolder, n2);
            } else if (n == 91) {
                object = this.readDateValue(resultHolder, n2);
            } else if (n == 92) {
                object = this.readTimeValue(resultHolder, n2);
            } else if (n == 2013) {
                object = this.readTimeTZValue(resultHolder, n2);
            } else if (this.useGetStringForBit && n == -7) {
                object = resultHolder.getString(n2);
            } else if (this.adjustArrayDisplay && n == 2003) {
                Object object2 = resultHolder.getObject(n2);
                object = ArrayConverter.getArrayDisplay(object2, this.resultInfo.getDbmsTypeName(n2 - 1), this.showArrayType, this.isOracle);
            } else if (n == 2002) {
                Object object3 = resultHolder.getObject(n2);
                object = object3 instanceof Struct ? StructConverter.getInstance().getStructDisplay((Struct)object3, this.isOracle) : object3;
            } else if (SqlUtil.isBlobType(n)) {
                if (this.useStreamsForBlobs) {
                    InputStream inputStream = resultHolder.getBinaryStream(n2);
                    if (inputStream == null || resultHolder.wasNull()) {
                        object = null;
                    } else {
                        this.addStream(inputStream);
                        object = inputStream;
                    }
                } else {
                    object = this.readBlob(resultHolder, n2);
                }
            } else if (n == 2009) {
                object = this.readXML(resultHolder, n2, this.useGetXML);
            } else if (SqlUtil.isClobType(n, this.longVarcharAsClob)) {
                if (this.useStreamsForClobs) {
                    Reader reader = resultHolder.getCharacterStream(n2);
                    if (reader == null || resultHolder.wasNull()) {
                        object = null;
                    } else {
                        object = reader;
                        this.addStream(reader);
                    }
                } else {
                    object = this.readClob(resultHolder, n2);
                }
            } else if (n == 1 || n == -15) {
                object = resultHolder.getString(n2);
                if (bl) {
                    object = StringUtil.rtrim((String)object);
                }
            } else {
                object = this.refCursorConsumer != null && this.refCursorConsumer.isRefCursor(n, this.resultInfo.getDbmsTypeName(n2 - 1)) ? this.refCursorConsumer.readRefCursor(resultHolder, n2) : resultHolder.getObject(n2);
            }
        }
        catch (SQLException sQLException) {
            if (this.ignoreReadErrors) {
                object = null;
                LogMgr.logError(new CallerInfo(){}, "Error retrieving data for column '" + this.resultInfo.getColumnName(n2 - 1) + "'. Using NULL!", sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            String string = throwable.getClass().getName();
            if (throwable.getMessage() != null) {
                string = string + ": " + throwable.getMessage();
            }
            throw new SQLException(string, throwable);
        }
        return object;
    }

    protected Object readTimeValue(ResultHolder resultHolder, int n) throws SQLException {
        if (this.useGetObjectForTime) {
            try {
                return resultHolder.getObject(n, LocalTime.class);
            }
            catch (AbstractMethodError | NoSuchMethodError | UnsupportedOperationException throwable) {
                this.useGetObjectForTime = false;
            }
        }
        return resultHolder.getTime(n);
    }

    protected Object readTimeTZValue(ResultHolder resultHolder, int n) throws SQLException {
        return this.readTimeValue(resultHolder, n);
    }

    protected Object readTimestampValue(ResultHolder resultHolder, int n) throws SQLException {
        try {
            if (this.useGetObjectForTimestamps) {
                try {
                    return resultHolder.getObject(n, LocalDateTime.class);
                }
                catch (AbstractMethodError | NoSuchMethodError | UnsupportedOperationException throwable) {
                    this.useGetObjectForTimestamps = false;
                }
            }
            return resultHolder.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            if (this.fixStupidMySQLZeroDate && "S1009".equals(sQLException.getSQLState())) {
                return resultHolder.getString(n);
            }
            throw sQLException;
        }
    }

    protected Object readTimestampTZValue(ResultHolder resultHolder, int n) throws SQLException {
        if (this.useGetObjectForTimestamps) {
            try {
                return resultHolder.getObject(n, OffsetDateTime.class);
            }
            catch (AbstractMethodError | NoSuchMethodError | UnsupportedOperationException throwable) {
                this.useGetObjectForTimestamps = false;
            }
        }
        return this.readTimestampValue(resultHolder, n);
    }

    protected Object readDateValue(ResultHolder resultHolder, int n) throws SQLException {
        if (this.useGetObjectForDates) {
            try {
                return resultHolder.getObject(n, LocalDate.class);
            }
            catch (AbstractMethodError | NoSuchMethodError | UnsupportedOperationException throwable) {
                this.useGetObjectForDates = false;
            }
        }
        return resultHolder.getDate(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStream(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        List<Closeable> list = this.streams;
        synchronized (list) {
            this.streams.add(closeable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStreams() {
        List<Closeable> list = this.streams;
        synchronized (list) {
            if (this.streams.size() > 0) {
                FileUtil.closeStreams(this.streams);
                this.streams.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readXML(ResultHolder resultHolder, int n, boolean bl) throws SQLException {
        Object object = null;
        if (!bl) return this.readCharacterStream(resultHolder, n);
        SQLXML sQLXML = null;
        try {
            sQLXML = resultHolder.getSQLXML(n);
            if (sQLXML == null) return object;
            if (resultHolder.wasNull()) return object;
            object = sQLXML.getString();
            return object;
        }
        finally {
            if (sQLXML != null) {
                sQLXML.free();
            }
        }
    }

    private Object readClob(ResultHolder resultHolder, int n) throws SQLException {
        Object object = null;
        switch (this.clobMethod) {
            case characterStream: {
                object = this.readCharacterStream(resultHolder, n);
                break;
            }
            case string: {
                object = resultHolder.getString(n);
                break;
            }
            case jdbcClob: {
                Clob clob = resultHolder.getClob(n);
                int n2 = (int)clob.length();
                if (n2 < 0) break;
                object = clob.getSubString(1L, n2);
            }
        }
        return object;
    }

    private Object readBlob(ResultHolder resultHolder, int n) throws SQLException {
        Object object = null;
        switch (this.blobMethod) {
            case binaryStream: {
                object = this.readBinaryStream(resultHolder, n);
                break;
            }
            case byteArray: {
                object = resultHolder.getBytes(n);
                if (!resultHolder.wasNull()) break;
                object = null;
                break;
            }
            case jdbcBlob: {
                Blob blob = resultHolder.getBlob(n);
                int n2 = (int)blob.length();
                if (n2 < 0) break;
                object = blob.getBytes(1L, n2);
            }
        }
        return object;
    }

    private Object readBinaryStream(ResultHolder resultHolder, int n) throws SQLException {
        Object object;
        try {
            InputStream inputStream = resultHolder.getBinaryStream(n);
            object = inputStream == null || resultHolder.wasNull() ? null : FileUtil.readBytes(inputStream);
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving binary data for column " + this.resultInfo.getColumnName(n), iOException);
            object = resultHolder.getObject(n);
        }
        return object;
    }

    private Object readCharacterStream(ResultHolder resultHolder, int n) throws SQLException {
        Object object;
        try {
            Reader reader = resultHolder.getCharacterStream(n);
            object = reader != null && !resultHolder.wasNull() ? FileUtil.readCharacters(reader) : null;
        }
        catch (IOException iOException) {
            LogMgr.logWarning(new CallerInfo(){}, "Error retrieving clob data for column " + this.resultInfo.getColumnName(n), iOException);
            object = resultHolder.getObject(n);
        }
        return object;
    }

    public static DataConverter getConverterInstance(WbConnection wbConnection) {
        if (wbConnection == null) {
            return null;
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (dbMetadata == null) {
            return null;
        }
        if (dbMetadata.isPostgres()) {
            return PostgresDataConverter.getInstance();
        }
        if (dbMetadata.isOracle() && Settings.getInstance().getConvertOracleTypes()) {
            return OracleDataConverter.getInstance();
        }
        if (dbMetadata.isSqlServer() && Settings.getInstance().getFixSqlServerTimestampDisplay()) {
            return SqlServerDataConverter.getInstance();
        }
        if (DBID.UCanAccess.isDB(wbConnection)) {
            return UCanAccessDataConverter.getInstance();
        }
        return null;
    }
}

