/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.ThreadDumper;
import workbench.util.WbThread;

public class DeadlockMonitor
extends WbThread {
    private final ThreadDumper monitor = new ThreadDumper();
    private final int sleepTime = Settings.getInstance().getIntProperty("workbench.gui.debug.deadlockmonitor.sleeptime", 5000);
    private final int minLogDuration = Settings.getInstance().getIntProperty("workbench.gui.debug.deadlockmonitor.logduration", 50);
    private boolean keepRunning = true;

    public DeadlockMonitor() {
        super("WbDeadlockMonitor");
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            long l = System.currentTimeMillis();
            String string = this.monitor.getDeadlockDump();
            long l2 = System.currentTimeMillis() - l;
            if (l2 > (long)this.minLogDuration) {
                LogMgr.logInfo(new CallerInfo(){}, "Checking for deadlocks took: " + l2 + "ms");
            }
            if (string != null) {
                LogMgr.logError(new CallerInfo(){}, "Deadlock detected:\n" + string, null);
            }
            if (!this.keepRunning) continue;
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public void cancel() {
        this.keepRunning = false;
        this.interrupt();
    }
}

