/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.ClasspathUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class ImageUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPng(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        boolean bl = false;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
            byte[] byArray2 = new byte[byArray.length];
            ((InputStream)fileInputStream).read(byArray2, 0, byArray.length);
            bl = Arrays.equals(byArray, byArray2);
        }
        catch (Throwable throwable) {
            try {
                bl = false;
            }
            catch (Throwable throwable2) {
                FileUtil.closeQuietely(fileInputStream);
                throw throwable2;
            }
            FileUtil.closeQuietely(fileInputStream);
        }
        FileUtil.closeQuietely(fileInputStream);
        return bl;
    }

    public static boolean isGifIcon(File file) {
        return ImageUtil.getGifType(file) == GifType.Standard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GifType getGifType(File file) {
        GifType gifType;
        BufferedInputStream bufferedInputStream;
        block10: {
            byte[] byArray = new byte[3];
            bufferedInputStream = null;
            gifType = GifType.None;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                ((InputStream)bufferedInputStream).read(byArray, 0, 3);
                byte[] byArray2 = new byte[]{71, 73, 70};
                if (!Arrays.equals(byArray, byArray2)) break block10;
                gifType = GifType.Standard;
                int n = 0;
                boolean bl = false;
                int n2 = ((InputStream)bufferedInputStream).read();
                while (n2 != -1 && n < 2) {
                    if (n2 == 33) {
                        bl = true;
                    } else if (n2 == 249 && bl) {
                        ++n;
                        bl = false;
                    } else {
                        bl = false;
                    }
                    n2 = ((InputStream)bufferedInputStream).read();
                }
                if (n <= 1) break block10;
                gifType = GifType.Animated;
            }
            catch (Throwable throwable) {
                try {
                    gifType = GifType.None;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    FileUtil.closeQuietely(bufferedInputStream);
                }
            }
        }
        FileUtil.closeQuietely(bufferedInputStream);
        return gifType;
    }

    public static List<File> getIcons(String string) {
        ArrayList<File> arrayList = new ArrayList<File>(2);
        if (StringUtil.isBlank(string)) {
            return arrayList;
        }
        ClasspathUtil classpathUtil = new ClasspathUtil();
        try {
            List<String> list = StringUtil.stringToList(string, System.getProperty("path.separator"));
            File file = classpathUtil.getJarFile().getParentFile();
            File file2 = Settings.getInstance().getConfigDir();
            for (String string2 : list) {
                if (!StringUtil.isNonEmpty(string2)) continue;
                File file3 = new File(string2);
                if (!file3.isAbsolute() && !(file3 = new File(file, string2)).exists()) {
                    file3 = new File(file2, string2);
                }
                if (ImageUtil.isPng(file3) || ImageUtil.isGifIcon(file3)) {
                    arrayList.add(file3);
                    continue;
                }
                LogMgr.logWarning(new CallerInfo(){}, "Ignoring invalid icon file: " + file3.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve list of icon files", throwable);
            arrayList.clear();
        }
        return arrayList;
    }

    public static enum GifType {
        Standard,
        Animated,
        None;

    }
}

