/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.List;
import workbench.db.ConnectionProfile;
import workbench.db.IniProfileStorage;
import workbench.db.ProfileStorage;
import workbench.db.XmlProfileStorage;
import workbench.util.WbFile;

public class ProfileConverter {
    public static void main(String[] stringArray) {
        WbFile wbFile;
        if (stringArray.length != 1) {
            System.err.println("Usage: ProfileConverter inputfile");
            System.exit(1);
        }
        if (!(wbFile = new WbFile(stringArray[0])).exists()) {
            System.out.println("File " + wbFile.getFullPath() + " not found!");
            System.exit(2);
        }
        WbFile wbFile2 = null;
        ProfileStorage profileStorage = null;
        ProfileStorage profileStorage2 = null;
        if (wbFile.getExtension().equalsIgnoreCase("properties")) {
            wbFile2 = new WbFile(wbFile.getParentFile(), "WbProfiles.xml");
            profileStorage = new IniProfileStorage();
            profileStorage2 = new XmlProfileStorage();
        } else {
            wbFile2 = new WbFile(wbFile.getParentFile(), "wb-profiles.properties");
            profileStorage = new XmlProfileStorage();
            profileStorage2 = new IniProfileStorage();
        }
        if (wbFile2.exists()) {
            wbFile2.makeBackup();
        }
        System.out.println("Converting " + wbFile.getFullPath() + " to " + wbFile2.getFullPath());
        List<ConnectionProfile> list = profileStorage.readProfiles(wbFile);
        profileStorage2.saveProfiles(list, wbFile2);
    }
}

