/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import workbench.db.WbConnection;
import workbench.gui.completion.CteDefinition;
import workbench.gui.completion.CteParser;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.formatter.WbSqlFormatter;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.ParserType;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class SqlParsingUtil {
    private final SQLLexer lexer;

    private SqlParsingUtil() {
        this.lexer = SQLLexerFactory.createLexer();
    }

    public SqlParsingUtil(WbConnection wbConnection) {
        this(ParserType.getTypeFromConnection(wbConnection));
    }

    public SqlParsingUtil(ParserType parserType) {
        this.lexer = SQLLexerFactory.createLexer(parserType, (CharSequence)"");
    }

    public List<String> getCTEVerbs(WbConnection wbConnection, String string) {
        CteParser cteParser = new CteParser(wbConnection, string);
        List<CteDefinition> list = cteParser.getCteDefinitions();
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + 1);
        for (CteDefinition cteDefinition : list) {
            String string2 = this.getSqlVerb(cteDefinition.getInnerSql());
            arrayList.add(string2);
        }
        arrayList.add(this.getSqlVerb(cteParser.getBaseSql()));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSqlVerb(String string) {
        if (StringUtil.isEmptyString(string)) {
            return "";
        }
        SQLLexer sQLLexer = this.lexer;
        synchronized (sQLLexer) {
            try {
                this.lexer.setInput(string);
                SQLToken sQLToken = this.lexer.getNextToken(false, false);
                if (sQLToken == null) {
                    return "";
                }
                String string2 = sQLToken.getContents();
                if (string2.charAt(0) == '@') {
                    return "@";
                }
                return sQLToken.getContents();
            }
            catch (Exception exception) {
                return "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stripStartingComment(String string) {
        String string2;
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        try {
            SQLLexer sQLLexer = this.lexer;
            synchronized (sQLLexer) {
                this.lexer.setInput(string);
                SQLToken sQLToken = this.lexer.getNextToken(false, false);
                int n = -1;
                if (sQLToken != null) {
                    n = sQLToken.getCharBegin();
                }
                string2 = n > -1 ? string.substring(n).trim() : string;
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error cleaning up SQL", exception);
            string2 = "";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFromPart(String string) {
        SQLLexer sQLLexer = this.lexer;
        synchronized (sQLLexer) {
            return SqlParsingUtil.getFromPart(string, this.lexer);
        }
    }

    public static String getFromPart(String string, SQLLexer sQLLexer) {
        int n = SqlParsingUtil.getKeywordPosition(Collections.singleton("FROM"), string, 0, sQLLexer);
        if (n == -1) {
            return null;
        }
        if ((n += "FROM".length()) >= string.length()) {
            return null;
        }
        int n2 = SqlParsingUtil.getKeywordPosition(WbSqlFormatter.FROM_TERMINAL, string, n, sQLLexer);
        if (n2 == -1) {
            return string.substring(n);
        }
        return string.substring(n, n2);
    }

    public int getFromPosition(String string) {
        Set<String> set = Collections.singleton("FROM");
        return this.getKeywordPosition(set, (CharSequence)string);
    }

    public int getJoinPosition(String string) {
        return this.getKeywordPosition(SqlUtil.getJoinKeyWords(), (CharSequence)string);
    }

    public int getWherePosition(String string) {
        Set<String> set = Collections.singleton("WHERE");
        return this.getKeywordPosition(set, (CharSequence)string);
    }

    public int getKeywordPosition(String string, CharSequence charSequence) {
        if (string == null) {
            return -1;
        }
        Set<String> set = Collections.singleton(string.toUpperCase());
        return this.getKeywordPosition(set, charSequence);
    }

    public int getKeywordPosition(Set<String> set, CharSequence charSequence) {
        return this.getKeywordPosition(set, charSequence, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeywordPosition(Set<String> set, CharSequence charSequence, int n) {
        SQLLexer sQLLexer = this.lexer;
        synchronized (sQLLexer) {
            return SqlParsingUtil.getKeywordPosition(set, charSequence, n, this.lexer);
        }
    }

    public static int getKeywordPosition(Set<String> set, CharSequence charSequence, int n, SQLLexer sQLLexer) {
        if (StringUtil.isEmptyString(charSequence)) {
            return -1;
        }
        sQLLexer.setInput(charSequence);
        int n2 = -1;
        try {
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            int n3 = 0;
            while (sQLToken != null) {
                if (sQLToken.getCharBegin() < n) {
                    sQLToken = sQLLexer.getNextToken(false, false);
                    continue;
                }
                String string = sQLToken.getContents();
                if ("(".equals(string)) {
                    ++n3;
                } else if (")".equals(string)) {
                    --n3;
                } else if (n3 == 0 && set.contains(string)) {
                    n2 = sQLToken.getCharBegin();
                    break;
                }
                sQLToken = sQLLexer.getNextToken(false, false);
            }
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stripVerb(String string) {
        String string2;
        try {
            SQLLexer sQLLexer = this.lexer;
            synchronized (sQLLexer) {
                this.lexer.setInput(string);
                SQLToken sQLToken = this.lexer.getNextToken(false, false);
                int n = -1;
                if (sQLToken != null) {
                    n = sQLToken.getCharEnd();
                }
                string2 = n > -1 ? string.substring(n).trim() : "";
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error cleaning up SQL", exception);
            string2 = "";
        }
        return string2;
    }

    public static SqlParsingUtil getInstance(WbConnection wbConnection) {
        if (wbConnection == null) {
            return LazyInstanceHolder.INSTANCE;
        }
        return wbConnection.getParsingUtil();
    }

    private static class LazyInstanceHolder {
        static final SqlParsingUtil INSTANCE = new SqlParsingUtil();

        private LazyInstanceHolder() {
        }
    }
}

