/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class VersionNumber {
    private int major = -1;
    private int minor = -1;
    private int patchLevel = -1;

    public VersionNumber(int n, int n2) {
        this.major = n;
        this.minor = n2;
    }

    public VersionNumber(int n, int n2, int n3) {
        this.major = n;
        this.minor = n2;
        this.patchLevel = n3;
    }

    public VersionNumber(String string) {
        if (StringUtil.isEmptyString(string)) {
            return;
        }
        if ((string = string.toLowerCase()).contains("beta")) {
            string = string.replaceAll("beta[0-9.]*", "");
            this.minor = 0;
            this.patchLevel = 0;
        } else if (string.contains("(")) {
            string = string.replaceAll("\\(.*\\)", "");
        }
        if ("@build_number@".equals(string)) {
            this.major = 999;
            this.minor = 999;
        } else {
            try {
                String[] stringArray = string.split("\\.");
                this.major = Integer.parseInt(stringArray[0]);
                if (stringArray.length > 1) {
                    this.minor = this.parseValue(stringArray[1]);
                }
                if (stringArray.length > 2) {
                    this.patchLevel = this.parseValue(stringArray[2]);
                }
            }
            catch (Exception exception) {
                this.minor = -1;
                this.major = -1;
            }
        }
    }

    private int parseValue(String string) {
        Pattern pattern = Pattern.compile("[^0-9]");
        Matcher matcher = pattern.matcher(string);
        int n = -1;
        if (matcher.find()) {
            n = matcher.start();
        }
        if (n > -1) {
            String string2 = string.substring(0, n);
            return Integer.parseInt(string2);
        }
        return Integer.parseInt(string);
    }

    public boolean isValid() {
        return this.major != -1;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getPatchLevel() {
        return this.patchLevel;
    }

    public boolean isNewerThan(VersionNumber versionNumber) {
        if (!this.isValid()) {
            return false;
        }
        if (this.major > versionNumber.major) {
            return true;
        }
        if (this.major == versionNumber.major) {
            if (this.minor == versionNumber.minor) {
                return this.patchLevel > versionNumber.patchLevel;
            }
            return this.minor > versionNumber.minor;
        }
        return false;
    }

    public boolean isNewerOrEqual(VersionNumber versionNumber) {
        if (this.isNewerThan(versionNumber)) {
            return true;
        }
        return this.major == versionNumber.major && this.minor == versionNumber.minor && this.patchLevel == versionNumber.patchLevel;
    }

    public String toString() {
        if (this.major == -1) {
            return "n/a";
        }
        if (this.major == 999) {
            return "999";
        }
        if (this.patchLevel == -1 && this.minor != -1) {
            return Integer.toString(this.major) + "." + Integer.toString(this.minor);
        }
        if (this.minor == -1 && this.patchLevel == -1) {
            return Integer.toString(this.major);
        }
        return Integer.toString(this.major) + "." + Integer.toString(this.minor) + "." + Integer.toString(this.patchLevel);
    }

    private static String cleanup(String string) {
        if (string == null) {
            return string;
        }
        return string.replaceAll("[^0-9]", "");
    }

    public static VersionNumber getJavaVersion() {
        String string = System.getProperty("java.version", null);
        if (string == null) {
            string = System.getProperty("java.runtime.version");
        }
        try {
            String[] stringArray = string.split("\\.");
            if (stringArray.length > 1) {
                if (stringArray[0].equals("1")) {
                    return new VersionNumber(Integer.valueOf(VersionNumber.cleanup(stringArray[1])), 0);
                }
                return new VersionNumber(Integer.valueOf(VersionNumber.cleanup(stringArray[0])), Integer.valueOf(VersionNumber.cleanup(stringArray[1])));
            }
            return new VersionNumber(Integer.valueOf(VersionNumber.cleanup(stringArray[0])), 0);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve Java version", throwable);
            return new VersionNumber(1, 8);
        }
    }
}

