/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.WbCipher;
import workbench.util.WbNullCipher;

public class WbDesCipher
implements WbCipher {
    private static final byte[] KEY_DATA = new byte[]{-108, -50, -5, -75, -98, 28, -116, 107};
    private static final SecretKeySpec KEY = new SecretKeySpec(KEY_DATA, "DES");
    private Cipher cipher;
    private static WbCipher instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WbCipher getInstance() {
        byte[] byArray = KEY_DATA;
        synchronized (KEY_DATA) {
            if (instance == null) {
                WbDesCipher wbDesCipher = new WbDesCipher();
                if (wbDesCipher.cipher == null) {
                    LogMgr.logWarning(new CallerInfo(){}, "Could not create cipher. Using NullCipher!");
                    instance = new WbNullCipher();
                } else {
                    LogMgr.logDebug(new CallerInfo(){}, "WbDesCipher created");
                    instance = wbDesCipher;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private WbDesCipher() {
        try {
            this.cipher = Cipher.getInstance("DES");
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "No encryption available!");
            this.cipher = null;
        }
    }

    @Override
    public String decryptString(String string) {
        if (string == null) {
            return string;
        }
        try {
            this.cipher.init(2, KEY);
            byte[] byArray = this.makeArray(string);
            byte[] byArray2 = this.cipher.doFinal(byArray);
            String string2 = new String(byArray2);
            return string2;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not decrypt", exception);
            return string;
        }
    }

    @Override
    public String encryptString(String string) {
        if (string == null) {
            return null;
        }
        if (this.cipher == null) {
            return string;
        }
        try {
            this.cipher.init(1, KEY);
            byte[] byArray = string.getBytes();
            byte[] byArray2 = this.cipher.doFinal(byArray);
            return this.makeString(byArray2);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not encrypt", exception);
            return string;
        }
    }

    private String makeString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 3);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append('#');
            stringBuilder.append(byArray[i]);
        }
        return stringBuilder.toString();
    }

    private byte[] makeArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
        byte[] byArray = new byte[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                byte by;
                byArray[n] = by = Byte.parseByte(string2);
                ++n;
            }
            catch (NumberFormatException numberFormatException) {
                return new byte[1];
            }
        }
        return byArray;
    }
}

